/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.sessionBean;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SessionBeanPropertyPage
extends AbstractModelElementPropertyPage {
    private Map delegates = new HashMap();
    private Map bodies = new HashMap();
    private Button radio3x;
    private Button radio2x;
    private StackLayout stackLayout;
    private Composite bodyStack;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        AbstractModelElementPropertyPage delegate = this.getCreateDelegate();
        delegate.loadFieldsFromElement(symbol, element);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        AbstractModelElementPropertyPage delegate = this.getCreateDelegate();
        delegate.loadElementFromFields(symbol, element);
    }

    @Override
    public Object getAdapter(Class adapter) {
        AbstractModelElementPropertyPage delegate = this.getCreateDelegate();
        return delegate.getAdapter(adapter);
    }

    @Override
    public Control createBody(Composite parent) {
        Composite bodyComposite = FormBuilder.createComposite((Composite)parent, (int)1);
        Group versionGroup = FormBuilder.createGroup((Composite)bodyComposite, (String)"Version", (int)2);
        versionGroup.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData());
        this.radio3x = FormBuilder.createRadioButton((Composite)versionGroup, (String)"EJB 3.x");
        this.radio3x.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SessionBeanPropertyPage.this.radio3x.getSelection()) {
                    SessionBeanPropertyPage.this.setEJBVersion("sessionBean30");
                }
            }
        });
        this.radio2x = FormBuilder.createRadioButton((Composite)versionGroup, (String)"EJB 2.x");
        this.radio2x.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SessionBeanPropertyPage.this.radio2x.getSelection()) {
                    SessionBeanPropertyPage.this.setEJBVersion("sessionBean20");
                }
            }
        });
        String style = this.getSetVersionAttribute();
        this.radio3x.setSelection("sessionBean30".equals(style));
        this.radio2x.setSelection("sessionBean20".equals(style));
        this.bodyStack = FormBuilder.createComposite((Composite)bodyComposite, (int)1);
        this.stackLayout = new StackLayout();
        this.bodyStack.setLayout((Layout)this.stackLayout);
        this.setCreateBody();
        return bodyComposite;
    }

    private void setCreateBody() {
        String style = this.getSetVersionAttribute();
        Control body = (Control)this.bodies.get(style);
        if (body == null) {
            AbstractModelElementPropertyPage delegate = this.getCreateDelegate();
            body = delegate.createBody(this.bodyStack);
            this.bodies.put(style, body);
        }
        this.stackLayout.topControl = body;
        this.bodyStack.layout();
    }

    protected void setEJBVersion(String version) {
        ApplicationType app = (ApplicationType)this.getModelElement();
        AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:ejbVersion", (String)version);
        boolean mustInitialize = !this.delegates.containsKey(version);
        this.setCreateBody();
        if (mustInitialize) {
            AbstractModelElementPropertyPage delegate = this.getCreateDelegate();
            IModelElementNodeSymbol symbol = this.getModelElementNodeSymbol();
            IModelElement element = this.getModelElementFromSymbol(symbol);
            delegate.loadFieldsFromElement(symbol, element);
        }
    }

    private AbstractModelElementPropertyPage getCreateDelegate() {
        String style = this.getSetVersionAttribute();
        AbstractModelElementPropertyPage delegate = (AbstractModelElementPropertyPage)this.delegates.get(style);
        if (delegate == null) {
            try {
                delegate = (AbstractModelElementPropertyPage)SpiExtensionRegistry.createPropertyPage((String)"_cwm_spi_application_", (String)style);
                delegate.setContainer(this.getContainer());
                delegate.setElement(this.getElement());
            }
            catch (Exception exception) {}
            this.delegates.put(style, delegate);
        }
        return delegate;
    }

    private String getSetVersionAttribute() {
        String style = "sessionBean30";
        ApplicationType app = (ApplicationType)this.getModelElement();
        if (app.getAttribute().isEmpty()) {
            AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:ejbVersion", (String)style);
        } else {
            style = AttributeUtil.getAttributeValue((IExtensibleElement)app, (String)"carnot:engine:ejbVersion");
            if (style == null) {
                style = "sessionBean20";
                AttributeUtil.setAttribute((IExtensibleElement)app, (String)"carnot:engine:ejbVersion", (String)style);
            }
        }
        return style;
    }
}

