/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ModelElementAdaptable;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSMappingPropertyPage;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSPartsPropertyPage;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSPropertyPage;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSResource;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSTemplatesPropertyPage;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSTypesPropertyPage;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSXmlTemplatePropertyPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class JaxWSOutlineSynchronizer {
    private static final String BASE_ID = "_cwm_spi_application_";
    private static final String PARTS_NODE = "_cwm_parts_";
    private static final String TYPES_NODE = "_cwm_types_";
    private static final String TEMPLATES_NODE = "_cwm_templates_";
    private static final ConfigHolder<?>[] NAMES = new ConfigHolder[]{new ConfigHolder<JaxWSPartsPropertyPage>("_cwm_parts_", Diagram_Messages.CONFIG_Parts, JaxWSPartsPropertyPage.class), new ConfigHolder<JaxWSTypesPropertyPage>("_cwm_types_", Diagram_Messages.ELEMENT_TypeMappings, JaxWSTypesPropertyPage.class), new ConfigHolder<JaxWSTemplatesPropertyPage>("_cwm_templates_", Diagram_Messages.ELEMENT_XMLTemplates, JaxWSTemplatesPropertyPage.class)};
    private JaxWSPropertyPage page;
    private BindingOperation operation;
    private Set<Part> mappedParts = new HashSet<Part>();
    private Set<Part> xmlParts = new HashSet<Part>();
    private Map<Object, String> javaValues = new HashMap<Object, String>();
    private Map<Object, String> xmlValues = new HashMap<Object, String>();

    public JaxWSOutlineSynchronizer(JaxWSPropertyPage page) {
        this.page = page;
    }

    public void init(ApplicationType target) {
        for (AttributeType attribute : target.getAttribute()) {
            this.checkAddValue(attribute, "carnot:engine:mapping:", this.javaValues);
            this.checkAddValue(attribute, "carnot:engine:template:", this.xmlValues);
        }
    }

    private void checkAddValue(AttributeType attribute, String prefix, Map<Object, String> map) {
        if (attribute.getName().startsWith(prefix)) {
            String key = attribute.getName().substring(prefix.length());
            String value = attribute.getValue();
            if (value != null && value.trim().length() > 0) {
                map.put(key, value.trim());
            }
        }
    }

    public void setOperation(BindingOperation operation) {
        this.operation = operation;
        this.mappedParts.clear();
        this.xmlParts.clear();
        this.checkMappings();
        this.updatePage(PARTS_NODE);
        this.updateChildPages(TYPES_NODE, JaxWSMappingPropertyPage.class, this.mappedParts);
        this.updateChildPages(TEMPLATES_NODE, JaxWSXmlTemplatePropertyPage.class, this.xmlParts);
        this.page.refreshTree();
    }

    private void updatePage(String id) {
        String label = null;
        final Class[] propertyPageClass = new Class[1];
        int i = 0;
        while (i < NAMES.length) {
            if (((ConfigHolder)NAMES[i]).id.equals(id)) {
                label = ((ConfigHolder)NAMES[i]).name;
                propertyPageClass[0] = ((ConfigHolder)NAMES[i]).propertyPageClass;
                break;
            }
            ++i;
        }
        String composedId = this.page.composePageId(BASE_ID, id);
        Object node = this.page.getNode(composedId);
        if (node == null) {
            ConfigurationElement config = ConfigurationElement.createPageConfiguration(id, label, null, propertyPageClass[0].getName());
            node = new CarnotPreferenceNode(config, new ModelElementAdaptable(new Class[]{IModelElement.class, JaxWSOutlineSynchronizer.class}, new Object[]{this.page.getApplication(), this}, this.page.getElement())){

                @Override
                public void createPage() {
                    try {
                        IWorkbenchPropertyPage page = (IWorkbenchPropertyPage)propertyPageClass[0].newInstance();
                        this.internalSetPage(page);
                    }
                    catch (Exception e) {
                        ErrorDialog.openError((Shell)JaxWSOutlineSynchronizer.this.page.getShell(), (String)"Exception", (String)e.getMessage(), (IStatus)Status.CANCEL_STATUS);
                    }
                }
            };
            this.page.addNodeTo(BASE_ID, (CarnotPreferenceNode)((Object)node), null);
        } else {
            AbstractModelElementPropertyPage page = (AbstractModelElementPropertyPage)node.getPage();
            page.elementChanged();
        }
    }

    private void checkMappings() {
        if (this.operation == null) {
            return;
        }
        Operation op = this.operation.getOperation();
        this.checkMappings(op.getInput() == null ? null : op.getInput().getMessage(), "input", DirectionType.IN_LITERAL);
        this.checkMappings(op.getOutput() == null ? null : op.getOutput().getMessage(), "output", DirectionType.OUT_LITERAL);
        for (Fault fault : op.getFaults().values()) {
            this.checkMappings(fault.getMessage(), "fault:" + fault.getName(), DirectionType.OUT_LITERAL);
        }
        for (Part part : this.xmlParts) {
            this.checkReplace("input", part, this.xmlValues);
        }
    }

    private void checkMappings(Message message, String category, DirectionType direction) {
        if (message != null) {
            for (Part part : message.getParts().values()) {
                if (this.isDefault(part)) continue;
                this.checkReplace(category, part, this.javaValues);
                this.setMappedLocal(part, this.javaValues.containsKey(part), direction);
            }
        }
    }

    private void checkReplace(String prefix, Part part, Map<Object, String> where) {
        String name = String.valueOf(prefix) + ":" + part.getName();
        if (!where.containsKey(part) && where.containsKey(name)) {
            String value = where.remove(name);
            where.put(part, value);
        }
    }

    public BindingOperation getOperation() {
        return this.operation;
    }

    public void setMappedLocal(Part part, boolean mapped, DirectionType direction) {
        if (mapped) {
            this.mappedParts.add(part);
        } else {
            this.mappedParts.remove(part);
        }
        if (direction.getValue() == 1 || direction.getValue() == 3) {
            if (mapped) {
                this.xmlParts.remove(part);
            } else {
                this.xmlParts.add(part);
            }
        }
    }

    public void setMapped(Part part, boolean mapped, DirectionType direction) {
        this.setMappedLocal(part, mapped, direction);
        this.updateChildPages(TYPES_NODE, JaxWSMappingPropertyPage.class, this.mappedParts);
        this.updateChildPages(TEMPLATES_NODE, JaxWSXmlTemplatePropertyPage.class, this.xmlParts);
        this.page.refreshTree();
    }

    private <T> void updateChildPages(String rootPageId, final Class<T> pageClass, Set<Part> parts) {
        String composedId = this.page.composePageId(BASE_ID, rootPageId);
        if (!parts.isEmpty()) {
            this.updatePage(rootPageId);
            IPreferenceNode node = this.page.getNode(composedId);
            IPreferenceNode[] children = node.getSubNodes();
            HashSet<Part> partSet = new HashSet<Part>();
            int i = 0;
            while (i < children.length) {
                Part part = (Part)((CarnotPreferenceNode)children[i]).getAdaptable().getAdapter(Part.class);
                if (parts.contains(part)) {
                    partSet.add(part);
                } else {
                    this.page.removePreferenceNodes(this.page.composePageId(composedId, part.getName()), true);
                }
                ++i;
            }
            for (Part part : parts) {
                if (partSet.contains(part)) continue;
                ConfigurationElement config = ConfigurationElement.createPageConfiguration(part.getName(), part.getName(), null, pageClass.getName());
                CarnotPreferenceNode child = new CarnotPreferenceNode(config, new ModelElementAdaptable(new Class[]{IModelElement.class, JaxWSOutlineSynchronizer.class, Part.class}, new Object[]{this.page.getApplication(), this, part}, this.page.getElement())){

                    @Override
                    public void createPage() {
                        try {
                            IWorkbenchPropertyPage page = (IWorkbenchPropertyPage)pageClass.newInstance();
                            this.internalSetPage(page);
                        }
                        catch (Exception e) {
                            ErrorDialog.openError((Shell)JaxWSOutlineSynchronizer.this.page.getShell(), (String)"Exception", (String)e.getMessage(), (IStatus)Status.CANCEL_STATUS);
                        }
                    }
                };
                this.page.addNodeTo(composedId, child, null);
            }
        } else {
            this.page.removePreferenceNodes(composedId, true);
        }
    }

    public boolean isDefault(Part part) {
        QName name = JaxWSResource.getType(part);
        return JaxWSResource.getDefaultMappedClass(name) != null;
    }

    public boolean isMapped(Part part) {
        return this.mappedParts.contains(part);
    }

    public String getTemplate(Part part) {
        String value = this.xmlValues.get(part);
        return value == null ? "" : value;
    }

    public void setTemplate(Part part, String value) {
        if (value.length() == 0) {
            this.xmlValues.remove(part);
        } else {
            this.xmlValues.put(part, value);
        }
        this.updatePage(TEMPLATES_NODE);
    }

    public Set<Part> getXmlParts() {
        return this.xmlParts;
    }

    public Set<Part> getMappedParts() {
        return this.mappedParts;
    }

    public String getMapping(Part part) {
        String value = this.javaValues.get(part);
        return value == null ? "" : value;
    }

    public void setMapping(Part part, String value) {
        if (value.length() == 0) {
            this.javaValues.remove(part);
        } else {
            this.javaValues.put(part, value);
        }
        this.updatePage(TYPES_NODE);
    }

    public String getWsdlLocation() {
        return this.page.getWsdlLocation();
    }

    private static class ConfigHolder<T> {
        private String id;
        private String name;
        private Class<T> propertyPageClass;

        public ConfigHolder(String id, String name, Class<T> propertyPageClass) {
            this.id = id;
            this.name = name;
            this.propertyPageClass = propertyPageClass;
        }
    }
}

