/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotBooleanEditor;
import org.eclipse.stardust.modeling.core.editors.ui.DefaultTableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.IClassGenerator;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSASTVisitor;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSResource;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class JaxWSPartsPropertyPage
extends AbstractModelElementPropertyPage {
    private static final String JAXWS_CLASS_GENERATOR = "jaxwsClassGenerator";
    private static final String EMPTY_STRING = "";
    private static final String[][] LABELS = new String[][]{{new String("_input_"), Diagram_Messages.ELEMENT_Input}, {new String("_output_"), Diagram_Messages.ELEMENT_Output}, {new String("_faults_"), Diagram_Messages.ELEMENT_Faults}};
    private static final int MAPPED_COLUMN = 2;
    private TreeViewer viewer;
    private CarnotBooleanEditor cellEditor;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.cellEditor.dispose();
        this.viewer.setInput((Object)this.getSynchronizer().getOperation());
        this.viewer.expandAll();
        this.cellEditor.setTree(this.viewer.getTree());
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        Tree tree = new Tree(composite, 67584);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)tree);
        String[] columnProperties = new String[]{Diagram_Messages.COL_NAME_Parts, Diagram_Messages.COL_NAME_XMLType, Diagram_Messages.COL_NAME_Mapped};
        this.viewer = new TreeViewer(tree);
        TableUtil.createColumns(tree, columnProperties);
        TableUtil.setInitialColumnSizes(tree, new int[]{30, 58, 12});
        DefaultTableLabelProvider labelProvider = new DefaultTableLabelProvider(null){

            @Override
            public String getText(int index, Object element) {
                if (element instanceof PartWrapper) {
                    Part part = ((PartWrapper)element).part;
                    switch (index) {
                        case 0: {
                            return part.getName();
                        }
                        case 1: {
                            return JaxWSResource.getType(part).toString();
                        }
                    }
                } else if (element instanceof Fault) {
                    Fault fault = (Fault)element;
                    switch (index) {
                        case 0: {
                            return fault.getName();
                        }
                    }
                } else {
                    int i = 0;
                    while (i < LABELS.length) {
                        if (LABELS[i][0] == element) {
                            switch (index) {
                                case 0: {
                                    return LABELS[i][1];
                                }
                            }
                            return JaxWSPartsPropertyPage.EMPTY_STRING;
                        }
                        ++i;
                    }
                }
                return JaxWSPartsPropertyPage.EMPTY_STRING;
            }
        };
        TableUtil.setLabelProvider(this.viewer, (TableLabelProvider)labelProvider, columnProperties);
        this.viewer.setContentProvider((IContentProvider)new OperationParameterTreeContentProvider());
        this.cellEditor = new CarnotBooleanEditor(2){

            @Override
            public boolean canEdit(Object element) {
                return element instanceof PartWrapper;
            }

            @Override
            public Object getValue(Object element) {
                return JaxWSPartsPropertyPage.this.getSynchronizer().isMapped(((PartWrapper)element).part) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public void setValue(Object element, Object value) {
                PartWrapper wrapper = (PartWrapper)element;
                Part part = wrapper.part;
                boolean mapped = (Boolean)value;
                JaxWSPartsPropertyPage.this.getSynchronizer().setMapped(part, mapped, wrapper.direction);
                if (mapped && JaxWSPartsPropertyPage.this.getSynchronizer().isDefault(part) && JaxWSPartsPropertyPage.this.getSynchronizer().getMapping(part).length() == 0) {
                    QName qName = JaxWSResource.getType(part);
                    String mapping = JaxWSResource.getDefaultMappedClass(qName);
                    JaxWSPartsPropertyPage.this.getSynchronizer().setMapping(part, mapping);
                }
            }
        };
        return composite;
    }

    private JaxWSOutlineSynchronizer getSynchronizer() {
        return (JaxWSOutlineSynchronizer)this.getElement().getAdapter(JaxWSOutlineSynchronizer.class);
    }

    @Override
    public void contributeButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(Diagram_Messages.WebServicePropertyPage_Generate_Classes);
        this.setButtonLayoutData(button);
        button.setEnabled(!SpiExtensionRegistry.instance().getExtensions(JAXWS_CLASS_GENERATOR).isEmpty());
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    IJavaProject project = JavaCore.create((IProject)this.getCurrentProject());
                    IPackageFragmentRoot root = JaxWSPartsPropertyPage.this.generateClasses(project);
                    JaxWSPartsPropertyPage.this.performMappings(root);
                    JaxWSPartsPropertyPage.this.cellEditor.refresh();
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }

            private IProject getCurrentProject() {
                IModelElement modelElement = (IModelElement)JaxWSPartsPropertyPage.this.getModelElement();
                Resource eResource = modelElement.eResource();
                if (eResource != null) {
                    URI eUri = eResource.getURI();
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(eUri.segment(1));
                    if (resource instanceof IProject) {
                        return (IProject)resource;
                    }
                    if (resource != null) {
                        return resource.getProject();
                    }
                }
                return null;
            }
        });
    }

    private Object[] wrap(Message message, DirectionType direction, Object parent) {
        Collection parts = message.getParts().values();
        Object[] result = new Object[parts.size()];
        int j = 0;
        for (Part part : parts) {
            result[j] = new PartWrapper(part, direction, parent);
            ++j;
        }
        return result;
    }

    private void performMappings(IPackageFragmentRoot root) throws JavaModelException {
        Map<String, IPackageFragment> ns2pkgs = this.collectPackages(root);
        Operation operation = this.getSynchronizer().getOperation().getOperation();
        for (Object part : operation.getInput().getMessage().getParts().values()) {
            this.performMapping(ns2pkgs, (Part)part, DirectionType.IN_LITERAL);
        }
        for (Object part : operation.getOutput().getMessage().getParts().values()) {
            this.performMapping(ns2pkgs, (Part)part, DirectionType.OUT_LITERAL);
        }
        for (Object fault : operation.getFaults().values()) {
            for (Object part : ((Fault)fault).getMessage().getParts().values()) {
                this.performMapping(ns2pkgs, (Part)part, DirectionType.OUT_LITERAL);
            }
        }
    }

    private void performMapping(Map<String, IPackageFragment> ns2pkgs, Part part, DirectionType direction) {
        String localPart;
        ICompilationUnit unit;
        IPackageFragment fragment;
        QName qName = JaxWSResource.getType(part);
        String mapping = JaxWSResource.getDefaultMappedClass(qName);
        if (mapping == null && (fragment = ns2pkgs.get(qName.getNamespaceURI())) != null && (unit = fragment.getCompilationUnit(this.toJavaClassName(localPart = qName.getLocalPart().trim()))).exists()) {
            mapping = String.valueOf(fragment.getElementName()) + '.' + unit.getElementName();
            mapping = mapping.substring(0, mapping.length() - 5);
        }
        if (mapping != null) {
            this.getSynchronizer().setMapped(part, true, direction);
            this.getSynchronizer().setMapping(part, mapping);
        }
    }

    private String toJavaClassName(String localPart) {
        return String.valueOf(localPart.substring(0, 1).toUpperCase()) + localPart.substring(1) + ".java";
    }

    private Map<String, IPackageFragment> collectPackages(IPackageFragmentRoot root) throws JavaModelException {
        HashMap<String, IPackageFragment> ns2pkgs = new HashMap<String, IPackageFragment>();
        IJavaElement[] fragments = root.getChildren();
        int i = 0;
        while (i < fragments.length) {
            NormalAnnotation annotation;
            ICompilationUnit unit = ((IPackageFragment)fragments[i]).getCompilationUnit("package-info.java");
            if (unit.exists() && (annotation = (NormalAnnotation)JaxWSASTVisitor.getAnnotation(unit, XmlSchema.class)) != null) {
                List values = annotation.values();
                for (MemberValuePair valuePair : values) {
                    if (!"namespace".equals(valuePair.getName().toString())) continue;
                    ns2pkgs.put(this.unquote(valuePair.getValue().toString()), (IPackageFragment)fragments[i]);
                    break;
                }
            }
            ++i;
        }
        return ns2pkgs;
    }

    private String unquote(String namespace) {
        return namespace.substring(1, namespace.length() - 1);
    }

    private IPackageFragmentRoot getSourceLocation(IJavaProject project) throws Throwable {
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    private IPackageFragmentRoot generateClasses(IJavaProject project) throws Throwable {
        IPackageFragmentRoot root = this.getSourceLocation(project);
        IPath location = root.getCorrespondingResource().getLocation();
        String wsdlLocation = this.getSynchronizer().getWsdlLocation();
        Map extensions = SpiExtensionRegistry.instance().getExtensions(JAXWS_CLASS_GENERATOR);
        if (!extensions.isEmpty()) {
            IConfigurationElement config = (IConfigurationElement)extensions.values().iterator().next();
            IClassGenerator generator = (IClassGenerator)config.createExecutableExtension("class");
            generator.generateClasses(location, wsdlLocation);
            project.getResource().refreshLocal(2, null);
        }
        return root;
    }

    private class OperationParameterTreeContentProvider
    implements ITreeContentProvider {
        private BindingOperation operation;

        private OperationParameterTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (LABELS[0][0] == parentElement) {
                Message message = this.operation.getOperation().getInput().getMessage();
                return JaxWSPartsPropertyPage.this.wrap(message, DirectionType.IN_LITERAL, parentElement);
            }
            if (LABELS[1][0] == parentElement) {
                Message message = this.operation.getOperation().getOutput().getMessage();
                return JaxWSPartsPropertyPage.this.wrap(message, DirectionType.OUT_LITERAL, parentElement);
            }
            if (LABELS[2][0] == parentElement) {
                return this.operation.getOperation().getFaults().values().toArray();
            }
            if (parentElement instanceof Fault) {
                Message message = ((Fault)parentElement).getMessage();
                return JaxWSPartsPropertyPage.this.wrap(message, DirectionType.OUT_LITERAL, parentElement);
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof Fault) {
                return LABELS[2][0];
            }
            if (element instanceof PartWrapper) {
                return ((PartWrapper)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (LABELS[0][0] == element) {
                return this.hasInputParts();
            }
            if (LABELS[1][0] == element) {
                return this.hasOutputParts();
            }
            if (LABELS[2][0] == element) {
                return this.hasFaults();
            }
            if (element instanceof Fault) {
                return this.hasFaultParts((Fault)element);
            }
            return false;
        }

        private boolean hasFaults() {
            return !this.operation.getOperation().getFaults().isEmpty();
        }

        private boolean hasFaultParts(Fault fault) {
            return fault.getMessage() != null && !fault.getMessage().getParts().isEmpty();
        }

        private boolean hasOutputParts() {
            return this.operation.getOperation().getOutput() != null && this.operation.getOperation().getOutput().getMessage() != null && !this.operation.getOperation().getOutput().getMessage().getParts().isEmpty();
        }

        private boolean hasInputParts() {
            return this.operation.getOperation().getInput() != null && this.operation.getOperation().getInput().getMessage() != null && !this.operation.getOperation().getInput().getMessage().getParts().isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<String> result = new ArrayList<String>(3);
            if (this.hasInputParts()) {
                result.add(LABELS[0][0]);
            }
            if (this.hasOutputParts()) {
                result.add(LABELS[1][0]);
            }
            if (this.hasFaults()) {
                result.add(LABELS[2][0]);
            }
            return result.toArray();
        }

        public void dispose() {
            this.operation = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.operation = (BindingOperation)newInput;
        }
    }

    public static class PartWrapper {
        private Part part;
        private DirectionType direction;
        private Object parent;

        public PartWrapper(Part part, DirectionType direction, Object parent) {
            this.part = part;
            this.direction = direction;
            this.parent = parent;
        }
    }
}

