/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.engine.extensions.jaxws.addressing.EndpointReferenceType;
import org.eclipse.stardust.engine.extensions.jaxws.addressing.WSAddressing;
import org.eclipse.stardust.engine.extensions.jaxws.app.IBasicAuthenticationParameters;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IAttributeCategory;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.BindingWrapper;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.DynamicBoundService;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSResource;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.JaxWSUtil;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice.QNameLabelProvider;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionHandler;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.ResourceHandler;
import org.eclipse.stardust.modeling.validation.util.ProjectClassLoader;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.xml.sax.InputSource;

public class JaxWSPropertyPage
extends AbstractModelElementPropertyPage {
    private static final String EMPTY_STRING = "";
    private static final String ENGINE_SCOPE = "carnot:engine";
    private static final String TEMPLATE_CATEGORY = "template";
    private static final String MAPPING_CATEGORY = "mapping";
    private static final String NAMESPACE_CATEGORY = "namespace";
    private static final String INPUT_CATEGORY = "input";
    private static final String OUTPUT_CATEGORY = "output";
    private static final String FAULT_CATEGORY = "fault";
    private static final String ENDPOINT_REFERENCE_LABEL = Diagram_Messages.WebServicePropertyPage_WsAddressingEndpointReferenceAccessPointName;
    private static final String ENDPOINT_ADDRESS_LABEL = Diagram_Messages.WebServicePropertyPage_EndpointAddressAccessPointName;
    private static final String AUTHENTICATION_LABEL = Diagram_Messages.WebServicePropertyPage_AuthenticationAccessPointName;
    private static final String WSDL_URL_LABEL = Diagram_Messages.WebServicePropertyPage_WsdlUrlLabel;
    private static final String LOAD_BUTTON_LABEL = Diagram_Messages.WebServicePropertyPage_LoadButtonLabel;
    private static final String[][] implementationLabels = new String[][]{{"generic", Diagram_Messages.WebServicePropertyPage_GenericResourceLabel}, {"carnot", Diagram_Messages.WebServicePropertyPage_InfinitySpecificLabel}};
    private static final String[][] mechanismLabels = new String[][]{{"basic", Diagram_Messages.WebServicePropertyPage_HttpBasicAuthorizationLabel}, {"ws-security", Diagram_Messages.WebServicePropertyPage_WsSecurityLabel}};
    private static final String[][] variantLabels = new String[][]{{"passwordText", Diagram_Messages.WebServicePropertyPage_UsernamePasswordLabel}, {"passwordDigest", Diagram_Messages.WebServicePropertyPage_UsernamePasswordDigestLabel}};
    private LabeledText wsdlText;
    private ComboViewer serviceViewer;
    private Label portLabel;
    private ComboViewer portViewer;
    private LabelWithStatus operationLabel;
    private ComboViewer operationViewer;
    private Label styleLabel;
    private Label useLabel;
    private Label protocolLabel;
    private Button addressingButton;
    private Button authenticationButton;
    private Combo implementationCombo;
    private Combo mechanismCombo;
    private Combo variantCombo;
    private Definition wsdlDefinition;
    private Service service;
    private Port port;
    private Binding binding;
    private BindingOperation operation;
    private JaxWSOutlineSynchronizer synchronizer;
    private Label endpointLabel;
    private Text endpoint;
    private DynamicBoundService dynamicBoundService;
    private MessageDialog dialog;
    private Map<Runnable, Boolean> threadMap = new HashMap<Runnable, Boolean>();
    private ModelType model;
    private WSDLLoader currentLoader;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ApplicationType application = (ApplicationType)element;
        this.model = (ModelType)application.eContainer();
        this.synchronizer.init(application);
        this.setWSDLData(application);
        this.setServiceData(application);
        this.setAddressingData(application);
        this.setSecurityData(application);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ApplicationType application = (ApplicationType)element;
        this.updateAttributes(application);
        this.updateMappings(application);
        this.updateTemplates(application);
        this.updateAccessPoints(application);
    }

    private void updateAttributes(ApplicationType application) {
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsdlUrl", (String)this.wsdlText.getText().getText().trim());
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsServiceName", this.service == null ? null : this.service.getQName().toString());
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsPortName", this.port == null ? null : (this.port instanceof BindingWrapper ? ((BindingWrapper)this.port).getQName().toString() : this.port.getName()));
        if (this.service instanceof DynamicBoundService) {
            String access = this.endpoint.getText().trim();
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsUddiAccessPoint", (String)(access.length() > 0 ? access : null));
        } else {
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsUddiAccessPoint", null);
        }
        if (this.operation != null) {
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsOperationName", (String)this.operation.getName());
            BindingInput input = this.operation.getBindingInput();
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsOperationInputName", (String)(input == null ? null : input.getName()));
            BindingOutput output = this.operation.getBindingOutput();
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsOperationOutputName", (String)(output == null ? null : output.getName()));
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsSoapActionUri", (String)JaxWSResource.getSoapActionUri(this.operation));
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsSoapProtocol", (String)JaxWSResource.getOperationProtocol(this.operation));
            List inputOrdering = this.operation.getOperation().getInput() == null || this.operation.getOperation().getInput().getMessage() == null ? Collections.emptyList() : this.operation.getOperation().getInput().getMessage().getOrderedParts(null);
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsInputOrder", (String)this.getPartsOrder(inputOrdering));
            List outputOrdering = this.operation.getOperation().getOutput() == null || this.operation.getOperation().getOutput().getMessage() == null ? Collections.emptyList() : this.operation.getOperation().getOutput().getMessage().getOrderedParts(null);
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsOutputOrder", (String)this.getPartsOrder(outputOrdering));
        } else {
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsOperationName", null);
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsOperationInputName", null);
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsOperationOutputName", null);
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsSoapActionUri", null);
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsInputOrder", null);
            AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsOutputOrder", null);
        }
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsImplementation", this.addressingButton.getSelection() ? implementationLabels[this.implementationCombo.getSelectionIndex()][0] : null);
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsAuthentication", this.authenticationButton.getSelection() ? mechanismLabels[this.mechanismCombo.getSelectionIndex()][0] : null);
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:wsAuthenticationVariant", this.authenticationButton.getSelection() && mechanismLabels[this.mechanismCombo.getSelectionIndex()][0].equals("ws-security") ? variantLabels[this.variantCombo.getSelectionIndex()][0] : null);
    }

    private String getPartsOrder(List<Part> ordering) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < ordering.size()) {
            Part part = ordering.get(i);
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(part.getName());
            ++i;
        }
        return buffer.toString();
    }

    private void updateMappings(ApplicationType application) {
        IAttributeCategory engineScope = AttributeUtil.createAttributeCategory((IExtensibleElement)application, (String)ENGINE_SCOPE);
        IAttributeCategory mappingScope = engineScope.createAttributeCategory(MAPPING_CATEGORY);
        IAttributeCategory namespaceScope = engineScope.createAttributeCategory(NAMESPACE_CATEGORY);
        engineScope.removeAttributeCategory(mappingScope.getId());
        engineScope.removeAttributeCategory(namespaceScope.getId());
        if (this.operation != null) {
            IAttributeCategory inputMappingScope = mappingScope.createAttributeCategory(INPUT_CATEGORY);
            IAttributeCategory inputNamespaceScope = namespaceScope.createAttributeCategory(INPUT_CATEGORY);
            List inputParts = this.operation.getOperation().getInput() == null || this.operation.getOperation().getInput().getMessage() == null ? Collections.emptyList() : this.operation.getOperation().getInput().getMessage().getOrderedParts(null);
            this.addMappings(inputMappingScope, inputNamespaceScope, inputParts);
            IAttributeCategory outputMappingScope = mappingScope.createAttributeCategory(OUTPUT_CATEGORY);
            IAttributeCategory outputNamespaceScope = namespaceScope.createAttributeCategory(OUTPUT_CATEGORY);
            List outputParts = this.operation.getOperation().getOutput() == null || this.operation.getOperation().getOutput().getMessage() == null ? Collections.emptyList() : this.operation.getOperation().getOutput().getMessage().getOrderedParts(null);
            this.addMappings(outputMappingScope, outputNamespaceScope, outputParts);
            IAttributeCategory allFaultsScope = mappingScope.createAttributeCategory(FAULT_CATEGORY);
            List<Fault> faults = this.operation.getOperation().getFaults() == null ? Collections.emptyList() : this.operation.getOperation().getFaults().values();
            for (Fault fault : faults) {
                IAttributeCategory faultScope = allFaultsScope.createAttributeCategory(fault.getName());
                List faultParts = fault.getMessage() == null ? Collections.emptyList() : fault.getMessage().getOrderedParts(null);
                this.addMappings(faultScope, null, faultParts);
            }
        }
    }

    private void addMappings(IAttributeCategory mappingScope, IAttributeCategory namespaceScope, List<Part> parts) {
        int i = 0;
        while (i < parts.size()) {
            Part part = parts.get(i);
            String mapping = this.synchronizer.getMapping(part);
            if (!StringUtils.isEmpty((String)mapping)) {
                String partName = part.getName();
                AttributeType mappingAttribute = mappingScope.createAttribute(partName);
                mappingAttribute.setValue(mapping);
                if (namespaceScope != null) {
                    AttributeType namespaceAttribute = namespaceScope.createAttribute(partName);
                    QName elementName = part.getElementName();
                    namespaceAttribute.setValue(elementName == null ? partName : elementName.toString());
                }
            }
            ++i;
        }
    }

    private void updateTemplates(ApplicationType application) {
        IAttributeCategory engineScope = AttributeUtil.createAttributeCategory((IExtensibleElement)application, (String)ENGINE_SCOPE);
        IAttributeCategory templateScope = engineScope.createAttributeCategory(TEMPLATE_CATEGORY);
        engineScope.removeAttributeCategory(templateScope.getId());
        if (this.operation != null) {
            IAttributeCategory inputScope = templateScope.createAttributeCategory(INPUT_CATEGORY);
            List inputParts = this.operation.getOperation().getInput() == null || this.operation.getOperation().getInput().getMessage() == null ? Collections.emptyList() : this.operation.getOperation().getInput().getMessage().getOrderedParts(null);
            this.addTemplates(inputScope, inputParts);
        }
    }

    private void addTemplates(IAttributeCategory scope, List<Part> parts) {
        int i = 0;
        while (i < parts.size()) {
            Part part = parts.get(i);
            String mapping = this.synchronizer.getTemplate(part);
            if (!StringUtils.isEmpty((String)mapping)) {
                AttributeType attribute = scope.createAttribute(part.getName());
                attribute.setValue(mapping);
            }
            ++i;
        }
    }

    private void updateAccessPoints(ApplicationType application) {
        String className;
        HashMap<String, AccessPointType> inAPs = new HashMap<String, AccessPointType>();
        HashMap<String, AccessPointType> outAPs = new HashMap<String, AccessPointType>();
        EList accessPoints = application.getAccessPoint();
        for (AccessPointType ap : accessPoints) {
            if (AccessPointUtil.isIn((DirectionType)ap.getDirection())) {
                inAPs.put(ap.getId(), ap);
            }
            if (!AccessPointUtil.isOut((DirectionType)ap.getDirection())) continue;
            outAPs.put(ap.getId(), ap);
        }
        DataTypeType serializable = ModelUtils.getDataType((IModelElement)application, (String)"serializable");
        DataTypeType plainXML = ModelUtils.getDataType((IModelElement)application, (String)"plainXML");
        if (this.addressingButton.getSelection()) {
            className = "carnot".equals(implementationLabels[this.implementationCombo.getSelectionIndex()][0]) ? WSAddressing.IPPEndpointReference.class.getName() : EndpointReferenceType.class.getName();
            JaxWSUtil.createAccessPoint(inAPs, application, "carnot:engine:endpointReference", ENDPOINT_REFERENCE_LABEL, DirectionType.IN_LITERAL, serializable, className);
        } else {
            JaxWSUtil.createAccessPoint(inAPs, application, "carnot:engine:endpointAddress", ENDPOINT_ADDRESS_LABEL, DirectionType.IN_LITERAL, serializable, String.class.getName());
        }
        if (this.authenticationButton.getSelection()) {
            className = IBasicAuthenticationParameters.class.getName();
            JaxWSUtil.createAccessPoint(inAPs, application, "carnot:engine:authentication", AUTHENTICATION_LABEL, DirectionType.IN_LITERAL, serializable, className);
        }
        if (this.operation != null) {
            String bindingStyle = this.styleLabel.getText();
            if (this.operation.getOperation().getInput() != null && this.operation.getOperation().getInput().getMessage() != null) {
                JaxWSUtil.createAccessPoints(application, this.operation.getOperation().getInput().getMessage(), bindingStyle, DirectionType.IN_LITERAL, serializable, plainXML, inAPs, this.synchronizer);
            }
            if (this.operation.getOperation().getOutput() != null && this.operation.getOperation().getOutput().getMessage() != null) {
                JaxWSUtil.createAccessPoints(application, this.operation.getOperation().getOutput().getMessage(), bindingStyle, DirectionType.OUT_LITERAL, serializable, plainXML, outAPs, this.synchronizer);
            }
        }
        accessPoints.removeAll(inAPs.values());
        accessPoints.removeAll(outAPs.values());
    }

    private void setSecurityData(ApplicationType application) {
        String authentication = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:wsAuthentication");
        int index = this.findIndex(mechanismLabels, authentication);
        this.authenticationButton.setSelection(index >= 0);
        this.authenticationChanged(index);
        String variant = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:wsAuthenticationVariant");
        int vIndex = this.findIndex(variantLabels, variant);
        this.mechanismChanged(vIndex < 0 && index >= 0 ? 0 : vIndex);
    }

    private int findIndex(String[][] labels, String value) {
        int index = -1;
        int i = 0;
        while (i < labels.length) {
            if (labels[i][0].equals(value)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private void setAddressingData(ApplicationType application) {
        String implementation = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:wsImplementation");
        int index = this.findIndex(implementationLabels, implementation);
        this.addressingButton.setSelection(index >= 0);
        this.addressingChanged(index);
    }

    private void setWSDLData(ApplicationType application) {
        String wsdlUrl = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:wsdlUrl");
        this.wsdlText.getText().setText(wsdlUrl == null ? EMPTY_STRING : wsdlUrl);
        this.loadWsdl();
    }

    private void setServiceData(ApplicationType application) {
        String serviceName;
        if (this.wsdlDefinition != null && (serviceName = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:wsServiceName")) != null) {
            String operationName;
            String portName;
            QName qName;
            QName serviceQName = QName.valueOf(serviceName);
            this.setViewerSelection((StructuredViewer)this.serviceViewer, this.findService(serviceQName));
            this.serviceChanged();
            if (this.service != null) {
                if (this.service instanceof DynamicBoundService) {
                    String access = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:wsUddiAccessPoint");
                    this.endpoint.setText(access == null ? EMPTY_STRING : access);
                } else {
                    this.endpoint.setText(EMPTY_STRING);
                }
            }
            QName qName2 = qName = (portName = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:wsPortName")) == null ? null : QName.valueOf(portName);
            this.setViewerSelection((StructuredViewer)this.portViewer, qName == null ? null : (this.service instanceof DynamicBoundService ? ((DynamicBoundService)this.service).getPort(qName) : this.service.getPort(portName)));
            this.portChanged();
            if (this.binding != null && !StringUtils.isEmpty((String)(operationName = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:wsOperationName")))) {
                String inputName = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:wsOperationInputName");
                String outputName = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:wsOperationOutputName");
                List operations = this.binding.getBindingOperations();
                for (BindingOperation operation : operations) {
                    String opOutputName;
                    if (!operationName.equals(operation.getName())) continue;
                    String opInputName = operation.getBindingInput() == null ? null : operation.getBindingInput().getName();
                    String string = opOutputName = operation.getBindingOutput() == null ? null : operation.getBindingOutput().getName();
                    if (!CompareHelper.areEqual((Object)inputName, (Object)opInputName) || !CompareHelper.areEqual((Object)outputName, (Object)opOutputName)) continue;
                    this.setViewerSelection((StructuredViewer)this.operationViewer, operation);
                    this.operationChanged();
                    break;
                }
            }
        }
    }

    private Service findService(QName serviceName) {
        Service service = this.wsdlDefinition.getService(serviceName);
        if (service == null && this.dynamicBoundService != null && this.dynamicBoundService.getQName().equals(serviceName)) {
            service = this.dynamicBoundService;
        }
        return service;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)4);
        LabelWithStatus wsdlLabel = FormBuilder.createLabelWithLeftAlignedStatus((Composite)composite, (String)WSDL_URL_LABEL);
        Composite wsdlComposite = FormBuilder.createComposite((Composite)composite, (int)2, (int)3);
        GridLayout layout = (GridLayout)wsdlComposite.getLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        ((GridData)wsdlComposite.getLayoutData()).grabExcessVerticalSpace = false;
        this.wsdlText = new LabeledText(FormBuilder.createText((Composite)wsdlComposite), wsdlLabel);
        FormBuilder.createButton((Composite)wsdlComposite, (String)LOAD_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String wsdlUrl = JaxWSPropertyPage.this.getWsdlResource();
                    if (wsdlUrl.length() != 0) {
                        JaxWSPropertyPage.this.wsdlChanged();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JaxWSPropertyPage.this.showError(Diagram_Messages.WebServicePropertyPage_LoadErrorMessage, 1, ex);
                }
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_ServiceLabel);
        Combo serviceCombo = FormBuilder.createCombo((Composite)composite, (int)3);
        this.serviceViewer = new ComboViewer(serviceCombo);
        this.serviceViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.serviceViewer.setLabelProvider((IBaseLabelProvider)new QNameLabelProvider());
        this.serviceViewer.setSorter(new ViewerSorter());
        serviceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JaxWSPropertyPage.this.serviceChanged();
            }
        });
        this.portLabel = FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_PortLabel);
        Combo portCombo = FormBuilder.createCombo((Composite)composite);
        this.portViewer = new ComboViewer(portCombo);
        this.portViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.portViewer.setLabelProvider((IBaseLabelProvider)new QNameLabelProvider());
        this.portViewer.setSorter(new ViewerSorter());
        portCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JaxWSPropertyPage.this.portChanged();
            }
        });
        this.operationLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_OperationLabel);
        Combo operationCombo = FormBuilder.createCombo((Composite)composite);
        this.operationViewer = new ComboViewer(operationCombo);
        this.operationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.operationViewer.setLabelProvider((IBaseLabelProvider)new QNameLabelProvider());
        this.operationViewer.setSorter(new ViewerSorter());
        operationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JaxWSPropertyPage.this.operationChanged();
            }
        });
        operationCombo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                String validationWarning;
                if (JaxWSPropertyPage.this.operation != null && (validationWarning = JaxWSPropertyPage.this.validateOperation(JaxWSPropertyPage.this.operation)) != null) {
                    JaxWSPropertyPage.this.operationLabel.setValidationStatus(IQuickValidationStatus.WARNINGS);
                    JaxWSPropertyPage.this.operationLabel.setToolTipText(validationWarning);
                }
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_StyleLabel);
        this.styleLabel = FormBuilder.createLabel((Composite)composite, (String)EMPTY_STRING);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_UseLabel);
        this.useLabel = FormBuilder.createLabel((Composite)composite, (String)EMPTY_STRING);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_ProtocolLabel);
        this.protocolLabel = FormBuilder.createLabel((Composite)composite, (String)EMPTY_STRING, (int)3);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_AddressingLabel);
        this.addressingButton = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_IncludeAddressingCheckBoxLabel);
        this.addressingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private int cache = 0;

            public void widgetSelected(SelectionEvent e) {
                this.cache = JaxWSPropertyPage.this.addressingChanged(this.cache);
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_ImplementationLabel);
        this.implementationCombo = FormBuilder.createCombo((Composite)composite);
        this.addLabels(this.implementationCombo, implementationLabels);
        SelectionAdapter mechSel = new SelectionAdapter(){
            private int cache = JaxWSPropertyPage.access$18().length - 1;

            public void widgetSelected(SelectionEvent e) {
                this.cache = JaxWSPropertyPage.this.mechanismChanged(this.cache);
            }
        };
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_AuthenticationLabel);
        this.authenticationButton = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_RequiredCheckBoxLabel);
        this.authenticationButton.addSelectionListener((SelectionListener)new SelectionAdapter((SelectionListener)mechSel){
            private int cache = 0;
            private final /* synthetic */ SelectionListener val$mechSel;
            {
                this.val$mechSel = selectionListener;
            }

            public void widgetSelected(SelectionEvent e) {
                this.cache = JaxWSPropertyPage.this.authenticationChanged(this.cache);
                this.val$mechSel.widgetSelected(null);
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_MechanismLabel);
        this.mechanismCombo = FormBuilder.createCombo((Composite)composite);
        this.mechanismCombo.addSelectionListener((SelectionListener)mechSel);
        this.addLabels(this.mechanismCombo, mechanismLabels);
        FormBuilder.createLabel((Composite)composite, (String)EMPTY_STRING, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_VariantLabel);
        this.variantCombo = FormBuilder.createCombo((Composite)composite);
        this.addLabels(this.variantCombo, variantLabels);
        this.endpointLabel = FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.WebServicePropertyPage_EndpointLabel);
        this.endpoint = FormBuilder.createText((Composite)composite, (int)3);
        this.endpointLabel.setVisible(false);
        this.endpoint.setVisible(false);
        this.synchronizer = new JaxWSOutlineSynchronizer(this);
        return composite;
    }

    protected String validateOperation(BindingOperation operationToVerify) {
        try {
            Operation soapOperation = operationToVerify.getOperation();
            if (soapOperation != null) {
                Message message;
                Output output;
                Message message2;
                Input input = soapOperation.getInput();
                if (input != null && (message2 = input.getMessage()) != null) {
                    Map inputParts = message2.getParts();
                    for (Part part : inputParts.values()) {
                        if (JaxWSUtil.findMatchingTypeDeclaration(this.getApplication(), part) != null) continue;
                        return MessageFormat.format(Diagram_Messages.WebServicePropertyPage_TypeNotFoundForInputPart, part.getName());
                    }
                }
                if ((output = soapOperation.getOutput()) != null && (message = output.getMessage()) != null) {
                    Map outputParts = message.getParts();
                    for (Part part : outputParts.values()) {
                        if (JaxWSUtil.findMatchingTypeDeclaration(this.getApplication(), part) != null) continue;
                        return MessageFormat.format(Diagram_Messages.WebServicePropertyPage_TypeNotFoundForOutputPart, part.getName());
                    }
                }
            }
        }
        catch (Exception e) {
            String messageString = Diagram_Messages.WebServicePropertyPage_UnknownPartValidationError;
            this.showError(messageString, 0, e);
            return messageString;
        }
        return null;
    }

    private void showError(String message, int code, Exception exception) {
        ErrorDialog.openError(null, (String)Diagram_Messages.WebServicePropertyPage_ErrorDialogTitle, (String)message, (IStatus)new Status(2, "org.eclipse.stardust.modeling.core", code, exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage(), (Throwable)exception));
    }

    private int addressingChanged(int cache) {
        return this.buttonChanged(cache, this.addressingButton.getSelection(), this.implementationCombo);
    }

    private int authenticationChanged(int cache) {
        return this.buttonChanged(cache, this.authenticationButton.getSelection(), this.mechanismCombo);
    }

    private int buttonChanged(int cache, boolean selected, Combo control) {
        if (selected) {
            control.select(cache);
        } else {
            cache = control.getSelectionIndex();
            control.deselectAll();
        }
        control.setEnabled(selected);
        return cache;
    }

    private int mechanismChanged(int cache) {
        boolean wsSecuritySelected;
        int index = this.mechanismCombo.getSelectionIndex();
        boolean bl = wsSecuritySelected = index >= 0 && index < mechanismLabels.length && mechanismLabels[index][0].equals("ws-security");
        if (wsSecuritySelected) {
            this.variantCombo.select(cache);
        } else {
            cache = this.variantCombo.getSelectionIndex();
            if (index >= 0 && index < mechanismLabels.length) {
                this.variantCombo.select(0);
            } else {
                this.variantCombo.deselectAll();
            }
        }
        this.variantCombo.setEnabled(wsSecuritySelected);
        return cache;
    }

    private void addLabels(Combo combo, String[][] strings) {
        int i = 0;
        while (i < strings.length) {
            combo.add(strings[i][1]);
            ++i;
        }
    }

    private String getWsdlResource() {
        return this.wsdlText.getText().getText().trim();
    }

    private void loadWsdl() {
        if (this.getWsdlResource().length() > 0) {
            try {
                this.wsdlChanged();
            }
            catch (Exception ex) {
                this.showError(Diagram_Messages.WebServicePropertyPage_LoadErrorMessage, 1, ex);
            }
        }
    }

    private void wsdlChanged() throws Exception {
        ClassLoader cclBackup = Thread.currentThread().getContextClassLoader();
        try {
            IProject project = WorkspaceUtils.getProjectFromEObject((EObject)this.getApplication());
            String resource = this.getWsdlResource();
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)new ProjectClassLoader(XmlUtils.class.getClassLoader(), project, resource));
            String[] buttons = new String[]{IDialogConstants.CANCEL_LABEL};
            this.dialog = new MessageDialog(Display.getDefault().getActiveShell(), Diagram_Messages.WebServicePropertyPage_WSDL, null, Diagram_Messages.WebServicePropertyPage_Retrieving_WSDL, 2, buttons, 0){

                protected void buttonPressed(int buttonId) {
                    JaxWSPropertyPage.this.threadMap.put(JaxWSPropertyPage.this.currentLoader, true);
                    super.buttonPressed(buttonId);
                }
            };
            this.currentLoader = new WSDLLoader(resource);
            this.threadMap.put(this.currentLoader, false);
            Thread thread = new Thread(this.currentLoader);
            thread.start();
            this.dialog.open();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cclBackup);
        }
    }

    private Definition getWSDL(String resource) throws CoreException, Exception {
        Definition definition;
        block5: {
            if (resource != null) {
                resource = VariableContextHelper.getInstance().getContext(this.model).replaceAllVariablesByDefaultValue(resource);
            }
            definition = null;
            try {
                definition = JaxWSResource.getDefinition(resource);
            }
            catch (Exception ex) {
                Connection connection;
                URI uri;
                String connectionId;
                ConnectionManager cm;
                String connectionUri = AttributeUtil.getAttributeValue((IExtensibleElement)this.getApplication(), (String)"carnot:connection:uri");
                if (connectionUri != null && (cm = this.getEditor().getConnectionManager()) != null && (connectionId = (uri = URI.createURI((String)connectionUri)).authority()) != null && (connection = cm.getConnection(connectionId)) != null) {
                    InputSource source;
                    cm.open(connection);
                    ConnectionHandler handler = cm.getConnectionHandler(connection);
                    if (handler instanceof ResourceHandler && (source = ((ResourceHandler)handler).getInputSource(resource)) != null) {
                        definition = JaxWSResource.getDefinition(resource, source);
                    }
                }
                if (definition != null) break block5;
                throw ex;
            }
        }
        return definition;
    }

    private List<Service> getServices() {
        ArrayList<Service> services = new ArrayList<Service>();
        Iterator i = this.wsdlDefinition.getServices().values().iterator();
        while (i.hasNext()) {
            services.add((Service)i.next());
        }
        services.add(this.dynamicBoundService);
        return services;
    }

    private void serviceChanged() {
        this.service = (Service)this.getSelectedItem((StructuredViewer)this.serviceViewer);
        boolean isDynamic = this.service instanceof DynamicBoundService;
        this.portLabel.setText(isDynamic ? Diagram_Messages.WebServicePropertyPage_BindingLabel : Diagram_Messages.WebServicePropertyPage_PortLabel);
        this.endpointLabel.setVisible(isDynamic);
        this.endpoint.setVisible(isDynamic);
        this.setViewerData((StructuredViewer)this.portViewer, this.getPorts());
        this.portChanged();
    }

    private List<Port> getPorts() {
        ArrayList<Port> ports = new ArrayList<Port>();
        if (this.service != null) {
            Iterator i = this.service.getPorts().values().iterator();
            while (i.hasNext()) {
                ports.add((Port)i.next());
            }
        }
        return ports;
    }

    private List<BindingOperation> getOperations() {
        return this.binding == null ? null : this.binding.getBindingOperations();
    }

    private void portChanged() {
        this.port = (Port)this.getSelectedItem((StructuredViewer)this.portViewer);
        this.binding = this.port == null ? null : this.port.getBinding();
        String style = JaxWSResource.getBindingStyle(this.binding);
        this.styleLabel.setText(style == null ? EMPTY_STRING : style);
        this.setViewerData((StructuredViewer)this.operationViewer, this.getOperations());
        this.operationChanged();
    }

    private Object getSelectedItem(StructuredViewer viewer) {
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        return selection.isEmpty() ? null : selection.getFirstElement();
    }

    private void setViewerData(StructuredViewer viewer, List<?> data) {
        if (data == null) {
            data = Collections.EMPTY_LIST;
        }
        viewer.setInput((Object)data);
        viewer.getControl().setEnabled(!data.isEmpty());
        if (data.size() > 0) {
            viewer.setSelection((ISelection)new StructuredSelection(data.get(0)));
        }
    }

    private void operationChanged() {
        this.operation = (BindingOperation)this.getSelectedItem((StructuredViewer)this.operationViewer);
        String style = JaxWSResource.getOperationStyle(this.operation);
        if (style == null) {
            style = JaxWSResource.getBindingStyle(this.binding);
        }
        this.styleLabel.setText(style == null ? EMPTY_STRING : style);
        String use = JaxWSResource.getOperationUse(this.operation);
        this.useLabel.setText(use == null ? EMPTY_STRING : use);
        String protocol = JaxWSResource.getOperationProtocol(this.operation);
        this.protocolLabel.setText(protocol == null ? EMPTY_STRING : protocol);
        this.synchronizer.setOperation(this.operation);
    }

    private void setViewerSelection(StructuredViewer viewer, Object selection) {
        viewer.setSelection((ISelection)(selection != null ? new StructuredSelection(selection) : StructuredSelection.EMPTY), true);
    }

    protected ApplicationType getApplication() {
        Object element = this.getElement();
        if (element instanceof EditPart) {
            element = ((EditPart)element).getModel();
        }
        if (element instanceof IModelElementNodeSymbol) {
            element = ((IModelElementNodeSymbol)element).getModelElement();
        }
        return element instanceof ApplicationType ? (ApplicationType)element : null;
    }

    public String getWsdlLocation() {
        IProject project = WorkspaceUtils.getProjectFromEObject((EObject)this.getApplication());
        String resource = this.wsdlText.getText().getText().trim();
        ProjectClassLoader cl = new ProjectClassLoader(XmlUtils.class.getClassLoader(), project, resource.startsWith("/") ? resource.substring(1) : resource);
        URL url = cl.getResource(resource);
        return url == null ? resource : url.toString();
    }

    static /* synthetic */ String[][] access$18() {
        return variantLabels;
    }

    class WSDLLoader
    implements Runnable {
        private String resource;
        private Definition definition = null;
        private Exception e;

        public Definition getDefinition() {
            return this.definition;
        }

        public WSDLLoader(String resource) {
            this.resource = resource;
        }

        @Override
        public void run() {
            block10: {
                try {
                    try {
                        this.definition = JaxWSPropertyPage.this.getWSDL(this.resource);
                        JaxWSPropertyPage.this.dynamicBoundService = new DynamicBoundService(this.definition);
                        JaxWSPropertyPage.this.wsdlDefinition = this.definition;
                        if (this.definition != null) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    JaxWSPropertyPage.this.setViewerData((StructuredViewer)JaxWSPropertyPage.this.serviceViewer, JaxWSPropertyPage.this.getServices());
                                    JaxWSPropertyPage.this.serviceChanged();
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        boolean isCanceled;
                        this.e = ex;
                        boolean isCanceled2 = (Boolean)JaxWSPropertyPage.this.threadMap.get(this);
                        if (!isCanceled2 && JaxWSPropertyPage.this.currentLoader == this) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    String message = WSDLLoader.this.e.getMessage() == null ? WSDLLoader.this.e.toString() : WSDLLoader.this.e.getMessage();
                                    ErrorDialog.openError(null, (String)JaxWSPropertyPage.EMPTY_STRING, (String)JaxWSPropertyPage.EMPTY_STRING, (IStatus)new Status(2, "org.eclipse.stardust.modeling.core", 1, message, (Throwable)WSDLLoader.this.e));
                                }
                            });
                        }
                        if (!(isCanceled = ((Boolean)JaxWSPropertyPage.this.threadMap.get(this)).booleanValue()) && JaxWSPropertyPage.this.currentLoader == this) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    JaxWSPropertyPage.this.dialog.close();
                                }
                            });
                        }
                        JaxWSPropertyPage.this.threadMap.remove(this);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    boolean isCanceled = (Boolean)JaxWSPropertyPage.this.threadMap.get(this);
                    if (!isCanceled && JaxWSPropertyPage.this.currentLoader == this) {
                        Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                    JaxWSPropertyPage.this.threadMap.remove(this);
                    throw throwable;
                }
                boolean isCanceled = (Boolean)JaxWSPropertyPage.this.threadMap.get(this);
                if (!isCanceled && JaxWSPropertyPage.this.currentLoader == this) {
                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                }
                JaxWSPropertyPage.this.threadMap.remove(this);
            }
        }
    }
}

