/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.conditionTypes.timer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IConditionPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.utils.NumericFieldVerifier;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.AccessPathBrowserComposite;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathModelAdapter2;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathWidgetAdapter2;
import org.eclipse.stardust.modeling.core.utils.TimeAttrUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TimerPropertyPage
extends AbstractModelElementPropertyPage
implements IConditionPropertyPage {
    private static final String DATA_PATH = Diagram_Messages.DATA_PATH;
    private static final String DATA = Diagram_Messages.DATA;
    private static final String CONSTANT_RADIO = Diagram_Messages.CONSTANT_RADIO;
    private static final String DATA_RADIO = Diagram_Messages.DATA_RADIO;
    private static final String USE = Diagram_Messages.USE;
    private static final String SECS = Diagram_Messages.SECS;
    private static final String MINS = Diagram_Messages.MINS;
    private static final String HOURS = Diagram_Messages.HOURS;
    private static final String DAYS = Diagram_Messages.DAYS;
    private static final String MONTHS = Diagram_Messages.MONTHS;
    private static final String YEARS = Diagram_Messages.YEARS;
    private static final String PERIOD = Diagram_Messages.PERIOD;
    private static final int MAX_SECS = 2;
    private static final int MAX_MINS = 2;
    private static final int MAX_HOURS = 2;
    private static final int MAX_DAYS = 3;
    private static final int MAX_MONTHS = 2;
    private static final int MAX_YEARS = 3;
    private Text hoursText;
    private Text daysText;
    private Text monthsText;
    private Text yearsText;
    private Text minText;
    private Text secsText;
    private StackLayout useStackLayout;
    private Composite useComposite;
    private Composite constantComposite;
    private Composite dataComposite;
    private Button dataDataCompButton;
    private Button constantDataCompButton;
    private Button dataConstCompButton;
    private Button constantConstCompButton;
    private LabeledViewer dataLabel;
    private AccessPathBrowserComposite dataPathBrowser;
    private LabeledText dataPathLabel;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        WidgetBindingManager binding = this.getWidgetBindingManager();
        binding.getModelBindingManager().bind((IModelAdapter)new Data2DataPathModelAdapter2(model, model.getData()), (IWidgetAdapter)new Data2DataPathWidgetAdapter2(this.dataLabel.getViewer(), this.dataPathBrowser, DirectionType.IN_LITERAL));
        if (AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:useData")) {
            this.selectDataComposite();
        } else {
            this.selectConstantComposite();
            AttributeType attrPeriod = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:period");
            TimeAttrUtils.initPeriod(new Text[]{this.yearsText, this.monthsText, this.daysText, this.hoursText, this.minText, this.secsText}, attrPeriod);
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        IExtensibleElement extElement = (IExtensibleElement)element;
        if (AttributeUtil.getAttribute((IExtensibleElement)extElement, (String)"carnot:engine:useData") == null) {
            AttributeUtil.setAttribute((IExtensibleElement)extElement, (String)"carnot:engine:useData", (String)Reflect.getAbbreviatedName(Boolean.class), (String)Boolean.FALSE.toString());
        }
        if (!AttributeUtil.getBooleanValue((IExtensibleElement)extElement, (String)"carnot:engine:useData")) {
            TimeAttrUtils.updatePeriodAttr(extElement, "carnot:engine:period", new Text[]{this.yearsText, this.monthsText, this.daysText, this.hoursText, this.minText, this.secsText});
        }
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1, (int)3);
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        this.useComposite = this.createUseComposite(composite);
        this.createConstantComposite(parent);
        this.createDataComposite();
        this.createRadioButtonSelectionListener();
        this.useStackLayout.topControl = this.constantComposite;
        return composite;
    }

    private void createConstantComposite(Composite parent) {
        this.constantComposite = FormBuilder.createComposite((Composite)this.useComposite, (int)13);
        GridLayout constantGridLayout = new GridLayout();
        constantGridLayout.numColumns = 13;
        constantGridLayout.marginWidth = 0;
        constantGridLayout.marginHeight = 0;
        this.constantComposite.setLayout((Layout)constantGridLayout);
        FormBuilder.createLabel((Composite)this.constantComposite, (String)USE);
        Composite constantButtonComposite = FormBuilder.createComposite((Composite)this.constantComposite, (int)2, (int)12);
        ((GridLayout)constantButtonComposite.getLayout()).marginWidth = 0;
        constantButtonComposite.setLayoutData((Object)new GridData(0, 0, false, false, 12, 1));
        this.dataConstCompButton = FormBuilder.createRadioButton((Composite)constantButtonComposite, (String)DATA_RADIO);
        this.dataConstCompButton.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.constantConstCompButton = FormBuilder.createRadioButton((Composite)constantButtonComposite, (String)CONSTANT_RADIO);
        this.constantConstCompButton.setSelection(true);
        this.constantConstCompButton.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        GridData gdPeriod = new GridData();
        gdPeriod.widthHint = FormBuilder.getTextSize((Control)parent, (int)4);
        FormBuilder.createLabel((Composite)this.constantComposite, (String)PERIOD);
        this.createYearsText(gdPeriod);
        FormBuilder.createLabel((Composite)this.constantComposite, (String)YEARS);
        this.createMonthText(gdPeriod);
        FormBuilder.createLabel((Composite)this.constantComposite, (String)MONTHS);
        this.createDaysText(gdPeriod);
        FormBuilder.createLabel((Composite)this.constantComposite, (String)DAYS);
        this.createHoursText(gdPeriod);
        FormBuilder.createLabel((Composite)this.constantComposite, (String)HOURS);
        this.createMinText(gdPeriod);
        FormBuilder.createLabel((Composite)this.constantComposite, (String)MINS);
        this.createSecText(gdPeriod);
        FormBuilder.createLabel((Composite)this.constantComposite, (String)SECS);
    }

    private void createDataComposite() {
        this.dataComposite = FormBuilder.createComposite((Composite)this.useComposite, (int)3);
        GridLayout dataGridLayout = new GridLayout();
        dataGridLayout.numColumns = 3;
        dataGridLayout.marginWidth = 0;
        dataGridLayout.marginHeight = 0;
        this.dataComposite.setLayout((Layout)dataGridLayout);
        FormBuilder.createLabel((Composite)this.dataComposite, (String)USE);
        this.dataDataCompButton = FormBuilder.createRadioButton((Composite)this.dataComposite, (String)DATA_RADIO);
        this.dataDataCompButton.setSelection(true);
        this.constantDataCompButton = FormBuilder.createRadioButton((Composite)this.dataComposite, (String)CONSTANT_RADIO);
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.dataComposite, (String)DATA);
        ComboViewer dataText = new ComboViewer(FormBuilder.createCombo((Composite)this.dataComposite));
        dataText.setSorter(new ViewerSorter());
        dataText.setContentProvider((IContentProvider)new ArrayContentProvider());
        dataText.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        dataText.getCombo().setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.dataLabel = new LabeledViewer((StructuredViewer)dataText, label);
        label = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.dataComposite, (String)DATA_PATH);
        this.dataPathBrowser = new AccessPathBrowserComposite(this.getEditor(), this.dataComposite, DATA_PATH, 2);
        this.dataPathLabel = new LabeledText(this.dataPathBrowser.getMethodText(), label);
    }

    private Composite createUseComposite(Composite composite) {
        Composite useComposite = FormBuilder.createComposite((Composite)composite, (int)1);
        useComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.useStackLayout = new StackLayout();
        useComposite.setLayout((Layout)this.useStackLayout);
        return useComposite;
    }

    private void createRadioButtonSelectionListener() {
        this.dataConstCompButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimerPropertyPage.this.selectDataComposite();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.constantDataCompButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimerPropertyPage.this.selectConstantComposite();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void selectConstantComposite() {
        this.useStackLayout.topControl = this.constantComposite;
        this.useComposite.layout();
        this.dataDataCompButton.setSelection(true);
        this.constantDataCompButton.setSelection(false);
        IExtensibleElement element = (IExtensibleElement)this.getModelElement();
        AttributeUtil.setBooleanAttribute((IExtensibleElement)element, (String)"carnot:engine:useData", (Boolean)false);
        WidgetBindingManager binding = this.getWidgetBindingManager();
        binding.unbind(this.dataLabel, element, (Object)"carnot:engine:data");
        binding.unbind(this.dataPathLabel, element, (Object)"carnot:engine:dataPath");
        AttributeUtil.setAttribute((IExtensibleElement)element, (String)"carnot:engine:data", null);
        AttributeUtil.setAttribute((IExtensibleElement)element, (String)"carnot:engine:dataPath", null);
    }

    private void selectDataComposite() {
        this.useStackLayout.topControl = this.dataComposite;
        this.useComposite.layout();
        this.constantConstCompButton.setSelection(true);
        this.dataConstCompButton.setSelection(false);
        IExtensibleElement element = (IExtensibleElement)this.getModelElement();
        AttributeUtil.setBooleanAttribute((IExtensibleElement)element, (String)"carnot:engine:useData", (Boolean)true);
        WidgetBindingManager binding = this.getWidgetBindingManager();
        binding.bind(this.dataLabel, element, "carnot:engine:data", (EObject)ModelUtils.findContainingModel((EObject)element), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_Data());
        binding.bind(this.dataPathLabel, element, "carnot:engine:dataPath");
        AttributeUtil.setAttribute((IExtensibleElement)element, (String)"carnot:engine:period", null);
    }

    private void createYearsText(GridData gdPeriod) {
        this.yearsText = FormBuilder.createText((Composite)this.constantComposite);
        this.yearsText.setTextLimit(3);
        this.yearsText.setLayoutData((Object)gdPeriod);
        this.yearsText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 999));
    }

    private void createMonthText(GridData gdPeriod) {
        this.monthsText = FormBuilder.createText((Composite)this.constantComposite);
        this.monthsText.setTextLimit(2);
        this.monthsText.setLayoutData((Object)gdPeriod);
        this.monthsText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 11));
    }

    private void createDaysText(GridData gdPeriod) {
        this.daysText = FormBuilder.createText((Composite)this.constantComposite);
        this.daysText.setTextLimit(3);
        this.daysText.setLayoutData((Object)gdPeriod);
        this.daysText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 999));
    }

    private void createHoursText(GridData gdPeriod) {
        this.hoursText = FormBuilder.createText((Composite)this.constantComposite);
        this.hoursText.setTextLimit(2);
        this.hoursText.setLayoutData((Object)gdPeriod);
        this.hoursText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 23));
    }

    private void createMinText(GridData gdPeriod) {
        this.minText = FormBuilder.createText((Composite)this.constantComposite);
        this.minText.setTextLimit(2);
        this.minText.setLayoutData((Object)gdPeriod);
        this.minText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 59));
    }

    private void createSecText(GridData gdPeriod) {
        this.secsText = FormBuilder.createText((Composite)this.constantComposite);
        this.secsText.setTextLimit(2);
        this.secsText.setLayoutData((Object)gdPeriod);
        this.secsText.addVerifyListener((VerifyListener)new NumericFieldVerifier(0, 59));
    }
}

