/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.dataTypes.plainXML;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.engine.core.struct.ClientXPathMap;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.emfxsd.XPathFinder;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDParser;
import org.eclipse.xsd.util.XSDResourceImpl;

public class PlainXMLUtils {
    public static IXPathMap getXPathMap(DataType data) {
        String elementName = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:typeId");
        XSDSchema schema = PlainXMLUtils.getXMLDataTypeSchema(data);
        if (schema != null) {
            Set allXPaths = null;
            if (!StringUtils.isEmpty((String)elementName)) {
                allXPaths = XPathFinder.findAllXPaths((XSDSchema)schema, (String)elementName, (boolean)false);
                return new ClientXPathMap(allXPaths);
            }
        }
        return null;
    }

    public static XSDSchema getXMLDataTypeSchema(DataType data) {
        String schemaType = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:schemaType");
        String schemaUrl = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:schemaURL");
        if (schemaUrl != null) {
            schemaUrl.trim();
        }
        if (schemaType == null) {
            return null;
        }
        if (schemaType.equals("none") || StringUtils.isEmpty((String)schemaUrl)) {
            return null;
        }
        String resolvedUri = XmlUtils.resolveResourceUri((String)schemaUrl);
        if (schemaType.equals("xsd")) {
            try {
                XSDParser parser = new XSDParser();
                parser.parse(resolvedUri);
                XSDSchema schema = parser.getSchema();
                return schema;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (schemaType.equals("wsdl")) {
            HashMap options = new HashMap();
            URI uri = !resolvedUri.toLowerCase().startsWith("http://") ? URI.createPlatformResourceURI((String)resolvedUri, (boolean)true) : URI.createURI((String)resolvedUri);
            XSDResourceImpl resource = new XSDResourceImpl(uri);
            try {
                resource.load(options);
                EList l = resource.getContents();
                int i = 0;
                while (i < l.size()) {
                    EObject eObject = (EObject)l.get(i);
                    if (eObject instanceof XSDSchema) {
                        return (XSDSchema)eObject;
                    }
                    ++i;
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

