/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.dataTypes.plainXML;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XML11DTDProcessor;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class SchemaUtils {
    public static List getDTDSchemaElements(String dtdURL) {
        try {
            ArrayList<QName> symbols = new ArrayList<QName>();
            XML11DTDProcessor scanner = new XML11DTDProcessor();
            URL sourceURL = new URL(dtdURL);
            DTDGrammar grammar = (DTDGrammar)scanner.loadGrammar(SchemaUtils.getXMLInputSource(sourceURL));
            XMLElementDecl decl = new XMLElementDecl();
            int ix = grammar.getFirstElementDeclIndex();
            while (ix >= 0) {
                grammar.getElementDecl(ix, decl);
                String uri = decl.name.uri;
                String local = decl.name.localpart;
                String prefix = decl.name.prefix;
                int px = local.indexOf(58);
                if (prefix == null && px > 0) {
                    prefix = local.substring(0, px);
                    local = local.substring(px + 1);
                }
                QName qname = new QName(uri, local);
                symbols.add(qname);
                ix = grammar.getNextElementDeclIndex(ix);
            }
            return symbols;
        }
        catch (Exception e) {
            throw new PublicException(Diagram_Messages.EXC_CANNOT_PARSE_DTD_FILE, (Throwable)e);
        }
    }

    public static List getXSDSchemaElements(String xsdURL) {
        Document doc = XmlUtils.newDocument();
        Element def = doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "definitions");
        def.setAttribute("targetNamespace", xsdURL);
        def.setAttribute("xmlns", "http://schemas.xmlsoap.org/wsdl/");
        def.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        doc.appendChild(def);
        Element typ = doc.createElementNS("http://schemas.xmlsoap.org/wsdl/", "types");
        def.appendChild(typ);
        Element schema = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
        schema.setPrefix("xsd");
        schema.setAttribute("targetNamespace", xsdURL);
        typ.appendChild(schema);
        Element imp = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
        imp.setPrefix("xsd");
        imp.setAttribute("namespace", xsdURL);
        imp.setAttribute("schemaLocation", xsdURL);
        schema.appendChild(imp);
        Parser parser = new Parser();
        try {
            parser.run(xsdURL, doc);
        }
        catch (Exception e) {
            throw new PublicException(Diagram_Messages.EXC_CANNOT_PARSE_XSD_FILE, (Throwable)e);
        }
        return Arrays.asList(parser.getSymbolTable().getElementIndex().keySet().toArray());
    }

    public static List getWSDLSchemaElements(String wsdlURL) throws PublicException {
        Parser parser = new Parser();
        try {
            parser.run(wsdlURL);
        }
        catch (Exception e) {
            throw new PublicException(Diagram_Messages.EXC_CANNOT_PARSE_WSDL_FILE, (Throwable)e);
        }
        return Arrays.asList(parser.getSymbolTable().getElementIndex().keySet().toArray());
    }

    private SchemaUtils() {
    }

    private static XMLInputSource getXMLInputSource(URL sourceURL) throws IOException {
        InputSource source = new InputSource(sourceURL.openStream());
        XMLInputSource xmlIS = new XMLInputSource(null, sourceURL.toExternalForm(), null);
        xmlIS.setByteStream(source.getByteStream());
        xmlIS.setCharacterStream(source.getCharacterStream());
        xmlIS.setEncoding(source.getEncoding());
        return xmlIS;
    }
}

