/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.dataTypes.serializable;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataInitializer;

public class SerializableDataInitializer
implements IDataInitializer {
    public List initialize(DataType data, List attributes) {
        String className = null;
        int i = 0;
        while (i < attributes.size()) {
            AttributeType attribute = (AttributeType)attributes.get(i);
            if ("carnot:engine:className".equals(attribute.getName())) {
                className = attribute.getValue();
            } else if ("carnot:engine:remoteInterface".equals(attribute.getName())) {
                className = attribute.getValue();
            } else if ("carnot:engine:type".equals(attribute.getName())) {
                try {
                    Class type = Reflect.getClassFromAbbreviatedName((String)attribute.getValue());
                    if (type != null) {
                        className = type.getName();
                    }
                }
                catch (InternalException internalException) {}
            }
            if (!StringUtils.isEmpty((String)className)) break;
            ++i;
        }
        AttributeType attribute = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
        attribute.setName("carnot:engine:className");
        attribute.setValue(className == null ? Serializable.class.getName() : className);
        return Collections.singletonList(attribute);
    }
}

