/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.dataTypes.serializable;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.TypeSelectionComposite;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SerializablePropertyPage
extends AbstractModelElementPropertyPage
implements IDataPropertyPage {
    private static final String BLANK_STRING = " ";
    private static final String[] columnProperties = new String[]{Diagram_Messages.SerializablePropertyPage_ParameterColumnLabel, Diagram_Messages.SerializablePropertyPage_TypeColumnLabel};
    private LabelWithStatus classLabel;
    private TypeSelectionComposite classBrowser;
    private Label genericInfoLabel;
    private TreeViewer viewer;
    private TypeFinder finder;
    private TypeModel model;
    private HashMap typeCache = new HashMap();
    private String variableType = null;
    private Button autoInitializeCheckBox;
    private Button volatileCheckBox;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement node) {
        this.volatileCheckBox.setSelection(AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)node), (String)"carnot:engine:volatile"));
        this.finder = new TypeFinder((EObject)node);
        this.classBrowser.setTypeFinder(this.finder);
        this.classBrowser.setModel((ModelType)node.eContainer());
        String fullClassName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)node), (String)"carnot:engine:className");
        boolean autoInitialize = AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)node), (String)"carnot:engine:autoInstantiate");
        this.autoInitializeCheckBox.setSelection(autoInitialize);
        if (!StringUtils.isEmpty((String)fullClassName)) {
            if (fullClassName.indexOf("${") > -1) {
                this.variableType = fullClassName;
            }
            fullClassName = VariableContextHelper.getInstance().getContext((ModelType)this.getModelElement().eContainer()).replaceAllVariablesByDefaultValue(fullClassName);
            this.findType(fullClassName);
            if (this.model != null) {
                this.classBrowser.setType(this.model.getType());
            }
            if (this.variableType != null) {
                this.classBrowser.setTypeText(this.variableType);
            }
        }
        this.setViewerInput();
        if (this.isPredefined(node)) {
            this.disableControls();
        }
        this.getWidgetBindingManager().getValidationBindingManager().bind((EObject)node, (Object)"carnot:engine:className", this.classLabel);
    }

    private void findType(String fullClassName) {
        TypeInfo info;
        fullClassName = VariableContextHelper.getInstance().getContext((ModelType)this.getModelElement().eContainer()).replaceAllVariablesByDefaultValue(fullClassName);
        this.model = (TypeModel)this.typeCache.get(fullClassName);
        if (this.model == null && (info = this.finder.findType(fullClassName)) != null) {
            this.model = new TypeModel(info);
            this.typeCache.put(fullClassName, this.model);
        }
    }

    private void setViewerInput() {
        try {
            boolean hasDefaultConstructor;
            boolean hasParams = this.model == null ? false : this.model.hasParameters();
            this.genericInfoLabel.setText(!hasParams ? "" : MessageFormat.format(Diagram_Messages.SerializablePropertyPage_ParametersTableLabel, this.model.getSimpleName()));
            this.viewer.setInput((Object)this.model);
            this.viewer.getTree().setVisible(hasParams);
            boolean bl = hasDefaultConstructor = this.model == null ? false : this.model.hasDefaultConstructor();
            if (hasDefaultConstructor) {
                this.autoInitializeCheckBox.setEnabled(true);
            } else {
                this.autoInitializeCheckBox.setSelection(false);
                this.autoInitializeCheckBox.setEnabled(false);
            }
        }
        catch (JavaModelException e) {
            this.log(Diagram_Messages.EXC_CANNOT_RETRIEVE_TYPE_PARAMETERS, e);
            this.viewer.setInput(null);
        }
    }

    private void disableControls() {
        this.classBrowser.setEnabled(false);
        this.volatileCheckBox.setEnabled(false);
        this.autoInitializeCheckBox.setEnabled(false);
    }

    private boolean isPredefined(IModelElement element) {
        return ((DataType)element).isPredefined();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        String fullClassName = null;
        if (this.variableType != null) {
            fullClassName = this.variableType;
        }
        if (this.model != null) {
            if (this.variableType == null) {
                fullClassName = this.model.getFullName();
            }
            AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className", (String)fullClassName);
            if (this.autoInitializeCheckBox.getSelection()) {
                AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:autoInstantiate", (Boolean)true);
            } else {
                AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:autoInstantiate", null);
            }
        } else {
            AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className", (String)fullClassName);
        }
    }

    @Override
    public Control createBody(Composite parent) {
        final Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.volatileCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.LBL_Volatile_Data, (int)2);
        this.volatileCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataType data = (DataType)SerializablePropertyPage.this.getModelElement();
                boolean selection = ((Button)e.widget).getSelection();
                if (selection) {
                    AttributeUtil.setBooleanAttribute((IExtensibleElement)data, (String)"carnot:engine:volatile", (Boolean)true);
                } else {
                    AttributeUtil.setAttribute((IExtensibleElement)data, (String)"carnot:engine:volatile", null);
                }
            }
        });
        final String browserTitle = Diagram_Messages.SerializablePropertyPage_Class;
        this.classLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_ClassName);
        this.classBrowser = new TypeSelectionComposite(composite, browserTitle);
        FormBuilder.createLabel((Composite)composite, (String)BLANK_STRING);
        this.autoInitializeCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.SerializablePropertyPage_AutoInstantiateLabel);
        FormBuilder.createLabel((Composite)composite, (String)BLANK_STRING, (int)2);
        this.genericInfoLabel = FormBuilder.createLabel((Composite)composite, (String)BLANK_STRING, (int)2);
        this.classBrowser.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SerializablePropertyPage.this.model == null || !SerializablePropertyPage.this.classBrowser.getTypeText().equals(SerializablePropertyPage.this.model.getTypeName())) {
                    String typeName = SerializablePropertyPage.this.classBrowser.getTypeText();
                    if (typeName.indexOf("${") > -1) {
                        SerializablePropertyPage.this.variableType = typeName;
                    } else {
                        SerializablePropertyPage.this.variableType = null;
                    }
                    typeName = VariableContextHelper.getInstance().getContext((ModelType)SerializablePropertyPage.this.getModelElement().eContainer()).replaceAllVariablesByDefaultValue(typeName);
                    SerializablePropertyPage.this.findType(typeName);
                    SerializablePropertyPage.this.setViewerInput();
                    if (SerializablePropertyPage.this.model != null) {
                        String fullClassName = SerializablePropertyPage.this.model.getFullName();
                        if (SerializablePropertyPage.this.variableType != null) {
                            fullClassName = SerializablePropertyPage.this.variableType;
                        }
                        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)SerializablePropertyPage.this.getModelElement()), (String)"carnot:engine:className", (String)fullClassName);
                    }
                }
            }
        });
        Tree table = FormBuilder.createTree((Composite)composite, (int)67588, (String[])columnProperties, (int[])new int[]{25, 70}, (int)2);
        table.setVisible(false);
        this.viewer = new TreeViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ParameterContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ParameterLabelProvider());
        this.viewer.setColumnProperties(columnProperties);
        this.viewer.setCellModifier((ICellModifier)new CellModifier());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new DialogCellEditor((Composite)table){

            protected Object openDialogBox(Control cellEditorWindow) {
                ApplicationWindow context = new ApplicationWindow(composite.getShell());
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{SerializablePropertyPage.this.finder.getJavaProject()});
                try {
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)composite.getShell(), (IRunnableContext)context, (IJavaSearchScope)scope, (int)256, (boolean)false);
                    dialog.setTitle(browserTitle);
                    if (dialog.open() == 0) {
                        IType type = (IType)dialog.getResult()[0];
                        return type.getFullyQualifiedName();
                    }
                }
                catch (JavaModelException e) {
                    SerializablePropertyPage.this.log(Diagram_Messages.EXC_CANNOT_SEARCH_AVAILABLE_TYPES, e);
                }
                return null;
            }
        };
        this.viewer.setCellEditors(cellEditorArray);
        return composite;
    }

    public void log(String message, JavaModelException e) {
        DiagramPlugin.log((IStatus)new Status(2, "org.eclipse.stardust.modeling.core", 0, message, (Throwable)e));
    }

    public void updateTypes(TypeInfo type, ParameterModel[] parameters) {
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                ParameterModel param = parameters[i];
                if (param.type != null) {
                    type.setParameterType(param.getElementName(), param.getFullName());
                }
                ++i;
            }
        }
    }

    private static String getTypeName(TypeInfo type) {
        return type == null ? "" : type.getType().getFullyQualifiedName();
    }

    public boolean hasParameters(TypeInfo type) throws JavaModelException {
        if (type != null) {
            ITypeParameter[] parameters = type.getType().getTypeParameters();
            return parameters.length > 0;
        }
        return false;
    }

    private ParameterModel[] getParameters(TypeInfo type) throws JavaModelException {
        ITypeParameter[] typeParameters;
        if (type != null && (typeParameters = type.getType().getTypeParameters()).length > 0) {
            ParameterModel[] parameters = new ParameterModel[typeParameters.length];
            int i = 0;
            while (i < typeParameters.length) {
                parameters[i] = new ParameterModel(this, type, typeParameters[i]);
                String fullClassName = type.getParameterType(typeParameters[i].getElementName());
                if (fullClassName != null) {
                    parameters[i].setType(this.finder.findType(fullClassName));
                }
                ++i;
            }
            return parameters;
        }
        return new ParameterModel[0];
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(columnProperties[1]);
        }

        public Object getValue(Object element, String property) {
            return ((ITableLabelProvider)SerializablePropertyPage.this.viewer.getLabelProvider()).getColumnText(element, 1);
        }

        public void modify(Object element, String property, Object value) {
            Object local;
            Object object = local = element instanceof TreeItem ? ((TreeItem)element).getData() : element;
            if (property.equals(columnProperties[1])) {
                ParameterModel model = (ParameterModel)local;
                TypeInfo type = SerializablePropertyPage.this.finder.findType((String)value);
                model.setType(type);
                SerializablePropertyPage.this.viewer.refresh((Object)model);
            }
        }
    }

    private class ParameterContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private ParameterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            TypeModel model = (TypeModel)inputElement;
            try {
                return model.getChildren();
            }
            catch (JavaModelException e) {
                SerializablePropertyPage.this.log(Diagram_Messages.EXC_CANNOT_RETRIEVE_TYPE_PARAMETERS, e);
                return new Object[0];
            }
        }

        public Object[] getChildren(Object parentElement) {
            ParameterModel model = (ParameterModel)parentElement;
            try {
                return model.getChildren();
            }
            catch (JavaModelException e) {
                SerializablePropertyPage.this.log(Diagram_Messages.EXC_CANNOT_RETRIEVE_TYPE_PARAMETERS, e);
                return new Object[0];
            }
        }

        public Object getParent(Object element) {
            if (element instanceof ParameterModel) {
                ParameterModel model = (ParameterModel)element;
                return model.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            ParameterModel model = (ParameterModel)element;
            try {
                return model.hasParameters();
            }
            catch (JavaModelException e) {
                SerializablePropertyPage.this.log(Diagram_Messages.EXC_CANNOT_RETRIEVE_TYPE_PARAMETERS, e);
                return false;
            }
        }
    }

    private class ParameterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ParameterLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            ParameterModel model = (ParameterModel)element;
            switch (columnIndex) {
                case 0: {
                    result = model.getParameterName();
                    break;
                }
                case 1: {
                    result = model.getTypeName();
                }
            }
            return result == null ? "" : result;
        }
    }

    private class ParameterModel {
        private Object parent;
        private TypeInfo owner;
        private ITypeParameter param;
        private TypeInfo type;
        private ParameterModel[] parameters;

        public ParameterModel(Object parent, TypeInfo owner, ITypeParameter param) {
            this.parent = parent;
            this.owner = owner;
            this.param = param;
        }

        public void setType(TypeInfo type) {
            String otherTypeName = SerializablePropertyPage.getTypeName(type);
            if (!this.getTypeName().equals(otherTypeName)) {
                this.type = type;
                this.owner.setParameterType(this.param.getElementName(), type == null ? null : otherTypeName);
                this.parameters = null;
            }
        }

        public String getTypeName() {
            return SerializablePropertyPage.getTypeName(this.type);
        }

        public Object getParent() {
            return this.parent;
        }

        public String getParameterName() {
            return this.param.getElementName();
        }

        public boolean hasParameters() throws JavaModelException {
            return SerializablePropertyPage.this.hasParameters(this.type);
        }

        public String getFullName() {
            SerializablePropertyPage.this.updateTypes(this.type, this.parameters);
            return this.type.getFullName();
        }

        public ParameterModel[] getChildren() throws JavaModelException {
            if (this.parameters == null) {
                this.parameters = SerializablePropertyPage.this.getParameters(this.type);
            }
            return this.parameters;
        }

        public String getElementName() {
            return this.param.getElementName();
        }
    }

    private class TypeModel {
        private TypeInfo type;
        private ParameterModel[] parameters;

        public TypeModel(TypeInfo type) {
            this.type = type;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean hasDefaultConstructor() {
            try {
                MethodInfo ctor;
                Iterator iterator = this.type.getConstructors().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while ((ctor = (MethodInfo)iterator.next()).getParameterCount() != 0);
                return true;
            }
            catch (JavaModelException e) {
                SerializablePropertyPage.this.log(Diagram_Messages.SerializablePropertyPage_CannotFetchConstructorsErrorMessage, e);
            }
            return false;
        }

        public TypeInfo getType() {
            return this.type;
        }

        public String getSimpleName() {
            return this.type.getType().getElementName();
        }

        public String getFullName() {
            SerializablePropertyPage.this.updateTypes(this.type, this.parameters);
            return this.type.getFullName();
        }

        public String getTypeName() {
            return this.type.getType().getFullyQualifiedName();
        }

        public boolean hasParameters() throws JavaModelException {
            return SerializablePropertyPage.this.hasParameters(this.type);
        }

        public ParameterModel[] getChildren() throws JavaModelException {
            if (this.parameters == null) {
                this.parameters = SerializablePropertyPage.this.getParameters(this.type);
            }
            return this.parameters;
        }
    }
}

