/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.AbstractWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.core.editors.ui.AccessPathBrowserComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public class Data2DataPathWidgetAdapter2
extends AbstractWidgetAdapter {
    private StructuredViewer dataText;
    private DirectionType direction;
    private ISelectionChangedListener dataListener;
    private AccessPathBrowserComposite dataPathBrowser;

    public Data2DataPathWidgetAdapter2(StructuredViewer dataText, AccessPathBrowserComposite dataPathBrowser, DirectionType direction) {
        this.dataText = dataText;
        this.dataPathBrowser = dataPathBrowser;
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Data2DataPathWidgetAdapter2)) {
            return false;
        }
        Data2DataPathWidgetAdapter2 data2DataPathWidgetAdapter2 = (Data2DataPathWidgetAdapter2)((Object)o);
        if (!this.dataPathBrowser.equals(data2DataPathWidgetAdapter2.dataPathBrowser)) {
            return false;
        }
        if (!this.dataText.equals(data2DataPathWidgetAdapter2.dataText)) {
            return false;
        }
        return this.direction.equals((Object)data2DataPathWidgetAdapter2.direction);
    }

    public int hashCode() {
        int result = this.dataText.hashCode();
        result = 29 * result + this.direction.hashCode();
        result = 29 * result + this.dataPathBrowser.hashCode();
        return result;
    }

    public void bind(IBindingMediator manager) {
        super.bind(manager);
        this.dataListener = this.createDataListener(ModelUtils.getDualDirection((DirectionType)this.direction));
        this.dataText.addSelectionChangedListener(this.dataListener);
        this.dataText.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Data2DataPathWidgetAdapter2.this.unbind();
            }
        });
    }

    public void updateVisuals(Object value) {
        if (value instanceof Collection) {
            ISelection selection = this.dataText.getSelection();
            this.dataText.setInput(value);
            this.dataText.setSelection(selection);
            this.updateDataPathData(this.dataText.getSelection(), ModelUtils.getDualDirection((DirectionType)this.direction));
        }
    }

    public void unbind() {
        if (this.dataListener != null) {
            if (!this.dataText.getControl().isDisposed()) {
                this.dataText.removeSelectionChangedListener(this.dataListener);
            }
            this.dataListener = null;
        }
        super.unbind();
    }

    private ISelectionChangedListener createDataListener(final DirectionType direction) {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Data2DataPathWidgetAdapter2.this.updateDataPathData(event.getSelection(), direction);
            }
        };
    }

    private void updateDataPathData(ISelection selection, DirectionType direction) {
        IStructuredSelection structuredSelection;
        ITypedElement data = null;
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
            data = (ITypedElement)structuredSelection.getFirstElement();
        }
        if (this.dataPathBrowser != null) {
            this.dataPathBrowser.setAccessPoint(data, direction);
        }
    }
}

