/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DiagramSelectionDialog
extends ElementListSelectionDialog {
    private final IFile modelFile;
    private final WorkflowModelManager modelManager;
    private ModelType model;
    private boolean selectProcessDiagram = true;
    private ProcessDefinitionType processDefinition;

    public DiagramSelectionDialog(Shell parentShell, IFile modelFile, ProcessDefinitionType processDefinition, boolean selectProcessDiagram, WorkflowModelEditor editor) {
        super(parentShell, (ILabelProvider)new EObjectLabelProvider(editor));
        this.modelFile = modelFile;
        this.processDefinition = processDefinition;
        this.selectProcessDiagram = selectProcessDiagram;
        this.modelManager = new WorkflowModelManager();
        try {
            this.init();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void init() throws PartInitException, CoreException {
        this.loadModel();
        EList diagrams = new ArrayList();
        if (this.processDefinition != null) {
            diagrams = this.processDefinition.getDiagram();
        } else {
            diagrams.addAll(this.model.getDiagram());
            if (this.selectProcessDiagram) {
                Iterator iter = this.model.getProcessDefinition().iterator();
                while (iter.hasNext()) {
                    diagrams.addAll(((ProcessDefinitionType)iter.next()).getDiagram());
                }
            }
        }
        this.setElements(diagrams.toArray());
        this.setMultipleSelection(true);
    }

    private void loadModel() throws PartInitException, CoreException {
        if (this.modelFile.exists()) {
            try {
                this.modelManager.load(URI.createPlatformResourceURI((String)this.modelFile.getFullPath().toString()));
            }
            catch (Exception e) {
                throw new PartInitException(Diagram_Messages.MSG_LoadingModelFailed, (Throwable)e);
            }
            this.model = this.modelManager.getModel();
            if (this.model == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.core", 0, Diagram_Messages.MSG_LoadingModelFailed, null));
            }
        }
    }
}

