/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.List;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.swt.widgets.Composite;

public class ModelElementListCellEditor
extends ComboBoxCellEditor {
    private List list;

    public static ModelElementListCellEditor createInstance(Composite parent, List elements) {
        return new ModelElementListCellEditor(parent, elements);
    }

    protected ModelElementListCellEditor(Composite parent, List values) {
        super(parent, ModelElementListCellEditor.getItemLabels(values));
        this.list = values;
    }

    public Object doGetValue() {
        int index = (Integer)super.doGetValue();
        return index < this.list.size() && index >= 0 ? this.list.get((Integer)super.doGetValue()) : null;
    }

    public void doSetValue(Object value) {
        super.doSetValue((Object)new Integer(this.list.indexOf(value)));
    }

    private static String[] getItemLabels(List list) {
        String[] result;
        if (list != null && list.size() > 0) {
            result = new String[list.size()];
            int i = 0;
            for (Object element : list) {
                if (element instanceof IIdentifiableElement) {
                    IIdentifiableElement identifiable = (IIdentifiableElement)element;
                    result[i] = identifiable.getName() == null || identifiable.getName().length() == 0 ? identifiable.getId() : identifiable.getName();
                } else if (element instanceof IModelElement) {
                    IModelElement modelElement = (IModelElement)element;
                    result[i] = Long.toString(modelElement.getElementOid());
                } else {
                    result[i] = element.toString();
                }
                ++i;
            }
        } else {
            result = new String[]{""};
        }
        return result;
    }
}

