/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.modeling.core.ui.ModelElementListCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ModelElementListPropertyDescriptor
extends PropertyDescriptor {
    private final List elements;

    public ModelElementListPropertyDescriptor(Object id, String displayName, List elements) {
        super(id, displayName);
        this.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof IIdentifiableElement) {
                    IIdentifiableElement identifiable = (IIdentifiableElement)object;
                    return identifiable.getName() == null || identifiable.getName().length() == 0 ? (identifiable.getId() == null ? "?" : identifiable.getId()) : identifiable.getName();
                }
                if (object instanceof IModelElement) {
                    IModelElement element = (IModelElement)object;
                    return Long.toString(element.getElementOid());
                }
                return super.getText(object);
            }
        });
        this.elements = elements;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ModelElementListCellEditor editor = ModelElementListCellEditor.createInstance(parent, this.elements);
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }
}

