/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ModelElementSelectionDialog
extends ElementListSelectionDialog {
    private final IFile modelFile;
    private final Class[] elementTypeFilter;
    private final WorkflowModelManager modelManager;
    private ModelType model;

    public ModelElementSelectionDialog(Shell parentShell, IFile modelFile, Class[] elementTypeFilter, WorkflowModelEditor editor) {
        super(parentShell, (ILabelProvider)new EObjectLabelProvider(editor));
        this.modelFile = modelFile;
        this.elementTypeFilter = elementTypeFilter;
        this.modelManager = new WorkflowModelManager();
        try {
            this.init();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void init() throws PartInitException, CoreException {
        this.loadModel();
        EList processDefinitions = this.model.getProcessDefinition();
        this.setElements(processDefinitions.toArray());
    }

    private void loadModel() throws PartInitException, CoreException {
        if (this.modelFile.exists()) {
            try {
                this.modelManager.load(URI.createPlatformResourceURI((String)this.modelFile.getFullPath().toString()));
            }
            catch (Exception e) {
                throw new PartInitException(Diagram_Messages.MSG_LoadingModelFailed, (Throwable)e);
            }
            this.model = this.modelManager.getModel();
            if (this.model == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.core", 0, Diagram_Messages.MSG_LoadingModelFailed, null));
            }
        }
    }
}

