/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.IdentifiableLabelProvider;
import org.eclipse.stardust.modeling.core.properties.ReferencedModelSorter;
import org.eclipse.swt.widgets.Composite;

public class ProcessDefinitionSelectionViewer
extends TableViewer {
    private List<ProcessDefinitionType> processes;

    public ProcessDefinitionSelectionViewer(Composite parent, WorkflowModelEditor editor) {
        super(parent, 2048);
        this.getTable().setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        this.setLabelProvider((IBaseLabelProvider)new IdentifiableLabelProvider(editor));
        this.setSorter(new ReferencedModelSorter());
        this.reset(editor.getWorkflowModel());
    }

    public List<ProcessDefinitionType> reset(ModelType model) {
        ((IdentifiableLabelProvider)this.getLabelProvider()).setModel(model);
        this.getTable().removeAll();
        this.processes = ProcessDefinitionSelectionViewer.collectProcessDefinitions(model);
        this.add(this.processes.toArray());
        return this.processes;
    }

    private static List<ProcessDefinitionType> collectProcessDefinitions(ModelType model) {
        final List processes = CollectionUtils.newList();
        processes.addAll(model.getProcessDefinition());
        ModelUtils.forEachReferencedModel((ModelType)model, (Predicate)new Predicate<ModelType>(){

            public boolean accept(ModelType externalModel) {
                for (ProcessDefinitionType extProcess : externalModel.getProcessDefinition()) {
                    if (extProcess.getFormalParameters() == null) continue;
                    processes.add(extProcess);
                }
                return true;
            }
        });
        return processes;
    }

    public void setGrouped(boolean grouped) {
        ((ReferencedModelSorter)this.getSorter()).setGrouped(grouped);
        ((IdentifiableLabelProvider)this.getLabelProvider()).setShowGroupInfo(grouped);
        ISelection selection = this.getSelection();
        this.getTable().removeAll();
        this.add(this.processes.toArray());
        this.setSelection(selection);
    }
}

