/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ResourceTreeAndListGroup
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object root;
    private Object currentTreeSelection;
    private Collection expandedTreeNodes = new HashSet();
    private ITreeContentProvider treeContentProvider;
    private IStructuredContentProvider listContentProvider;
    private ILabelProvider treeLabelProvider;
    private ILabelProvider listLabelProvider;
    private CheckboxTreeViewer treeViewer;
    private CheckboxTableViewer listViewer;
    private ListenerList listeners = new ListenerList();
    private static int PREFERRED_HEIGHT = 150;

    public ResourceTreeAndListGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, boolean useHeightHint) {
        this.root = rootObject;
        this.treeContentProvider = treeContentProvider;
        this.listContentProvider = listContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.listLabelProvider = listLabelProvider;
        this.createContents(parent, style, useHeightHint);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void checkStateChanged(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (event.getCheckable().equals(ResourceTreeAndListGroup.this.treeViewer)) {
                    ResourceTreeAndListGroup.this.listViewer.setAllChecked(false);
                    this.setTreeViewerAllChecked(false, ResourceTreeAndListGroup.this.treeViewer.getTree().getItems());
                } else {
                    ResourceTreeAndListGroup.this.listViewer.setAllChecked(false);
                    this.setTreeViewerAllChecked(false, ResourceTreeAndListGroup.this.treeViewer.getTree().getItems());
                    ResourceTreeAndListGroup.this.treeViewer.setChecked(ResourceTreeAndListGroup.this.currentTreeSelection, true);
                }
                ResourceTreeAndListGroup.this.notifyCheckStateChangeListeners(event);
            }

            private void setTreeViewerAllChecked(boolean state, TreeItem[] items) {
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(state);
                    TreeItem[] children = items[i].getItems();
                    this.setTreeViewerAllChecked(state, children);
                    ++i;
                }
            }
        });
    }

    protected void createContents(Composite parent, int style, boolean useHeightHint) {
        Composite composite = new Composite(parent, style);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite, useHeightHint);
        this.createListViewer(composite, useHeightHint);
        this.initialize();
    }

    protected void createListViewer(Composite parent, boolean useHeightHint) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected void createTreeViewer(Composite parent, boolean useHeightHint) {
        Tree tree = new Tree(parent, 2080);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void expandAll() {
        this.treeViewer.expandAll();
    }

    public List getAllCheckedListItems() {
        ArrayList<Object> checkedElements = new ArrayList<Object>();
        int j = 0;
        while (j < this.listViewer.getCheckedElements().length) {
            if (this.listViewer.getCheckedElements()[j] instanceof IFile) {
                checkedElements.add(this.listViewer.getCheckedElements()[j]);
            }
            ++j;
        }
        return checkedElements;
    }

    public void initialCheckListItem(Object element) {
        Object parent = this.treeContentProvider.getParent(element);
        this.selectAndReveal(parent);
        this.listViewer.setChecked(element, true);
    }

    public void initialCheckTreeItem(Object element) {
        if (element.equals(this.currentTreeSelection)) {
            this.listViewer.setAllChecked(false);
        }
        this.treeViewer.setChecked(element, true);
        this.selectAndReveal(element);
    }

    private void selectAndReveal(Object treeElement) {
        this.treeViewer.reveal(treeElement);
        StructuredSelection selection = new StructuredSelection(treeElement);
        this.treeViewer.setSelection((ISelection)selection);
    }

    protected void initialize() {
        this.treeViewer.setInput(this.root);
        this.expandedTreeNodes = new ArrayList();
        this.expandedTreeNodes.add(this.root);
    }

    protected void notifyCheckStateChangeListeners(final CheckStateChangedEvent event) {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ICheckStateListener l = (ICheckStateListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
            ++i;
        }
    }

    protected void populateListViewer(Object treeElement) {
        this.listViewer.setInput(treeElement);
        if (!this.expandedTreeNodes.contains(treeElement)) {
            BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ResourceTreeAndListGroup.this.listViewer.setAllChecked(false);
                }
            });
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            this.currentTreeSelection = null;
            this.listViewer.setInput(this.currentTreeSelection);
            return;
        }
        if (selectedElement != this.currentTreeSelection) {
            this.populateListViewer(selectedElement);
        }
        this.currentTreeSelection = selectedElement;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }
}

