/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.createUtils.CreateModelElementUtil;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandUtils;

public class ConvertGatewayUtil {
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private EObject element;
    private boolean modified = false;
    private ModelType model;

    public boolean isModified() {
        return this.modified;
    }

    public ConvertGatewayUtil(EObject element) {
        this.element = element;
        this.model = ModelUtils.findContainingModel((EObject)element);
    }

    public void convert() {
        if (this.element instanceof ProcessDefinitionType) {
            this.convertGateway((ProcessDefinitionType)this.element);
        } else {
            for (ProcessDefinitionType process : ((ModelType)this.element).getProcessDefinition()) {
                this.convertGateway(process);
            }
        }
    }

    private void convertGateway(ProcessDefinitionType process) {
        ActivityType startActivity = ConvertGatewayUtil.findStartActivity(process);
        Set allActivities = CollectionUtils.newSet();
        allActivities.addAll(process.getActivity());
        LinkedList reachedActivities = CollectionUtils.newLinkedList();
        Set visitedActivities = CollectionUtils.newSet();
        reachedActivities.add(startActivity);
        while (!reachedActivities.isEmpty()) {
            ActivityType activity = (ActivityType)reachedActivities.remove(0);
            if (visitedActivities.contains(activity)) continue;
            visitedActivities.add(activity);
            for (TransitionType transition : activity.getOutTransitions()) {
                if (visitedActivities.contains(transition.getTo())) continue;
                reachedActivities.add(transition.getTo());
            }
            String activityId = activity.getId();
            JoinSplitType join = activity.getJoin();
            JoinSplitType split = activity.getSplit();
            if (!StringUtils.isEmpty((String)activityId) && activityId.matches("^(?i)gateway.*")) continue;
            if (!split.equals((Object)JoinSplitType.NONE_LITERAL)) {
                this.addGatewayActivity(activity, split, true);
            }
            if (join.equals((Object)JoinSplitType.NONE_LITERAL)) continue;
            this.addGatewayActivity(activity, join, false);
        }
    }

    private void addGatewayActivity(ActivityType activity, JoinSplitType type, boolean isSplit) {
        this.modified = true;
        IdFactory idFactoryTransition = new IdFactory(Diagram_Messages.BASENAME_Transition, Diagram_Messages.BASENAME_Transition);
        IdFactory idFactoryActivity = new IdFactory("gateway", "gateway");
        ProcessDefinitionType process = (ProcessDefinitionType)activity.eContainer();
        TransitionType newTransition = (TransitionType)CreateModelElementUtil.createModelElement(idFactoryTransition, PKG.getTransitionType(), (EObject)process, this.model);
        ActivityType newActivity = (ActivityType)CreateModelElementUtil.createModelElement(idFactoryActivity, PKG.getActivityType(), (EObject)process, this.model);
        process.getActivity().add((Object)newActivity);
        process.getTransition().add((Object)newTransition);
        if (isSplit) {
            this.removeGatewaySymbols(activity, newActivity, isSplit);
            EList outTransitions = activity.getOutTransitions();
            ArrayList transitions = new ArrayList();
            transitions.addAll(outTransitions);
            for (TransitionType transition : transitions) {
                transition.setFrom(newActivity);
            }
            newTransition.setFrom(activity);
            newTransition.setTo(newActivity);
            activity.setSplit(JoinSplitType.NONE_LITERAL);
            newActivity.setSplit(type);
            newActivity.setJoin(type);
        } else {
            this.removeGatewaySymbols(activity, newActivity, isSplit);
            EList inTransitions = activity.getInTransitions();
            ArrayList transitions = new ArrayList();
            transitions.addAll(inTransitions);
            for (TransitionType transition : transitions) {
                transition.setTo(newActivity);
            }
            newTransition.setFrom(newActivity);
            newTransition.setTo(activity);
            activity.setJoin(JoinSplitType.NONE_LITERAL);
            newActivity.setSplit(type);
            newActivity.setJoin(type);
        }
        this.createSymbols(activity, newActivity, isSplit);
    }

    private void removeGatewaySymbols(ActivityType activity, ActivityType newActivity, boolean isSplit) {
        for (INodeSymbol symbol : activity.getSymbols()) {
            ArrayList<GatewaySymbol> remove = new ArrayList<GatewaySymbol>();
            EList gateways = ((ActivitySymbolType)symbol).getGatewaySymbols();
            for (GatewaySymbol gatewaySymbol : gateways) {
                if (isSplit && FlowControlType.SPLIT_LITERAL.equals((Object)gatewaySymbol.getFlowKind())) {
                    remove.add(gatewaySymbol);
                    continue;
                }
                if (isSplit || !FlowControlType.JOIN_LITERAL.equals((Object)gatewaySymbol.getFlowKind())) continue;
                remove.add(gatewaySymbol);
            }
            for (INodeSymbol iNodeSymbol : remove) {
                ISymbolContainer container = (ISymbolContainer)iNodeSymbol.eContainer();
                PoolSymbol connectionContainer = ModelUtils.findContainingPool((EObject)container);
                ArrayList<IConnectionSymbol> connections = new ArrayList<IConnectionSymbol>();
                FeatureMap.ValueListIterator iter = connectionContainer.getConnections().valueListIterator();
                while (iter.hasNext()) {
                    IConnectionSymbol connection = (IConnectionSymbol)iter.next();
                    if ((connection.getSourceNode() == null || !connection.getSourceNode().equals(iNodeSymbol)) && (connection.getTargetNode() == null || !connection.getTargetNode().equals(iNodeSymbol))) continue;
                    connections.add(connection);
                }
                for (IConnectionSymbol connection : connections) {
                    connection.setSourceNode(null);
                    connection.setTargetNode(null);
                    Object ref = connectionContainer.eGet(connection.eContainingFeature());
                    if (!(ref instanceof List)) continue;
                    ((List)ref).remove(connection);
                }
                ((GatewaySymbol)iNodeSymbol).setActivitySymbol(null);
                ((ActivitySymbolType)symbol).getGatewaySymbols().remove((Object)iNodeSymbol);
                container.getGatewaySymbol().remove((Object)iNodeSymbol);
            }
        }
    }

    private void createSymbols(ActivityType activity, ActivityType newActivity, boolean isSplit) {
        int distance = 80;
        for (INodeSymbol symbol : activity.getSymbols()) {
            TransitionConnectionType connection;
            DiagramType activitySymbolDiagram;
            ISymbolContainer activitySymbolContainer = (ISymbolContainer)symbol.eContainer();
            IdFactory idFactoryGateway = new IdFactory("Gateway", Diagram_Messages.BASENAME_Gateway);
            IdFactory idFactorySymbol = new IdFactory("Symbol", Diagram_Messages.BASENAME_Symbol);
            ActivitySymbolType activitySymbol = (ActivitySymbolType)CreateModelElementUtil.createModelElement(idFactorySymbol, PKG.getActivitySymbolType(), (EObject)activitySymbolContainer, this.model);
            activitySymbolContainer.getActivitySymbol().add((Object)activitySymbol);
            activitySymbol.setWidth(40);
            activitySymbol.setHeight(40);
            activitySymbol.setXPos(symbol.getXPos() + (long)(symbol.getWidth() / 2) - 20L);
            if (isSplit) {
                activitySymbol.setYPos(symbol.getYPos() + (long)symbol.getHeight() + 40L);
            } else {
                activitySymbol.setYPos(symbol.getYPos() - (long)distance);
            }
            newActivity.getSymbols().add((Object)activitySymbol);
            activitySymbol.setActivity(newActivity);
            GatewaySymbol gatewaySymbolIn = (GatewaySymbol)CreateModelElementUtil.createModelElement(idFactoryGateway, PKG.getGatewaySymbol(), (EObject)activitySymbolContainer, this.model);
            gatewaySymbolIn.setActivitySymbol(activitySymbol);
            gatewaySymbolIn.setXPos(activitySymbol.getXPos());
            gatewaySymbolIn.setYPos(activitySymbol.getYPos() - (long)(distance / 2));
            gatewaySymbolIn.setFlowKind(FlowControlType.JOIN_LITERAL);
            activitySymbolContainer.getGatewaySymbol().add((Object)gatewaySymbolIn);
            GatewaySymbol gatewaySymbolOut = (GatewaySymbol)CreateModelElementUtil.createModelElement(idFactoryGateway, PKG.getGatewaySymbol(), (EObject)activitySymbolContainer, this.model);
            gatewaySymbolOut.setActivitySymbol(activitySymbol);
            gatewaySymbolOut.setXPos(activitySymbol.getXPos());
            gatewaySymbolOut.setYPos(activitySymbol.getYPos() + (long)(distance / 2));
            gatewaySymbolOut.setFlowKind(FlowControlType.SPLIT_LITERAL);
            activitySymbolContainer.getGatewaySymbol().add((Object)gatewaySymbolOut);
            TransitionConnectionType connectionIn = (TransitionConnectionType)CreateModelElementUtil.createModelElement(null, PKG.getTransitionConnectionType(), null, this.model);
            connectionIn.setSourceNode((INodeSymbol)gatewaySymbolIn);
            connectionIn.setTargetNode((INodeSymbol)activitySymbol);
            this.addConnection(activitySymbolContainer, connectionIn);
            TransitionConnectionType connectionOut = (TransitionConnectionType)CreateModelElementUtil.createModelElement(null, PKG.getTransitionConnectionType(), null, this.model);
            connectionOut.setSourceNode((INodeSymbol)activitySymbol);
            connectionOut.setTargetNode((INodeSymbol)gatewaySymbolOut);
            this.addConnection(activitySymbolContainer, connectionOut);
            for (TransitionType transition : newActivity.getOutTransitions()) {
                ActivityType to = transition.getTo();
                for (ActivitySymbolType toSymbol : to.getActivitySymbols()) {
                    DiagramType toSymbolDiagram = ModelUtils.findContainingDiagram((IGraphicalObject)toSymbol);
                    if (!toSymbolDiagram.equals(activitySymbolDiagram = ModelUtils.findContainingDiagram((IGraphicalObject)activitySymbol)) || toSymbol.equals(activitySymbol)) continue;
                    connection = (TransitionConnectionType)CreateModelElementUtil.createModelElement(null, PKG.getTransitionConnectionType(), null, this.model);
                    connection.setSourceNode((INodeSymbol)gatewaySymbolOut);
                    connection.setTargetNode((INodeSymbol)toSymbol);
                    connection.setTransition(transition);
                    this.addConnection(activitySymbolContainer, connection);
                }
            }
            for (TransitionType transition : newActivity.getInTransitions()) {
                ActivityType from = transition.getFrom();
                for (ActivitySymbolType fromSymbol : from.getActivitySymbols()) {
                    DiagramType fromSymbolDiagram = ModelUtils.findContainingDiagram((IGraphicalObject)fromSymbol);
                    if (!fromSymbolDiagram.equals(activitySymbolDiagram = ModelUtils.findContainingDiagram((IGraphicalObject)activitySymbol)) || fromSymbol.equals(activitySymbol)) continue;
                    connection = (TransitionConnectionType)CreateModelElementUtil.createModelElement(null, PKG.getTransitionConnectionType(), null, this.model);
                    connection.setSourceNode((INodeSymbol)fromSymbol);
                    connection.setTargetNode((INodeSymbol)gatewaySymbolIn);
                    connection.setTransition(transition);
                    this.addConnection(activitySymbolContainer, connection);
                }
            }
        }
    }

    private void addConnection(ISymbolContainer container, TransitionConnectionType connection) {
        EStructuralFeature containmentFeature;
        Object ref = (container = ModelUtils.findContainingPool((EObject)container)).eGet(containmentFeature = CommandUtils.findContainmentFeature(container.getConnectionContainingFeatures(), (IGraphicalObject)connection));
        if (ref instanceof List) {
            ((List)ref).add(connection);
        }
    }

    public static ActivityType findStartActivity(ProcessDefinitionType process) {
        ActivityType startActivity = null;
        for (ActivityType activity : process.getActivity()) {
            if (!activity.getInTransitions().isEmpty()) continue;
            if (startActivity == null) {
                startActivity = activity;
                continue;
            }
            return null;
        }
        if (startActivity != null) {
            Set allActivities = CollectionUtils.newSet();
            allActivities.addAll(process.getActivity());
            LinkedList reachedActivities = CollectionUtils.newLinkedList();
            Set visitedActivities = CollectionUtils.newSet();
            reachedActivities.add(startActivity);
            while (!reachedActivities.isEmpty()) {
                ActivityType activity = (ActivityType)reachedActivities.remove(0);
                if (visitedActivities.contains(activity)) continue;
                visitedActivities.add(activity);
                for (TransitionType transition : activity.getOutTransitions()) {
                    if (visitedActivities.contains(transition.getTo())) continue;
                    reachedActivities.add(transition.getTo());
                }
            }
            allActivities.removeAll(visitedActivities);
            if (!allActivities.isEmpty()) {
                return null;
            }
        }
        return startActivity;
    }
}

