/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractSwimlaneFigure;
import org.eclipse.stardust.modeling.core.editors.figures.LaneFigure;
import org.eclipse.stardust.modeling.core.editors.figures.PoolFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveNodeSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.tools.SnapCenterToGrid;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.HierarchyUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.stardust.modeling.core.utils.SnapGridUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class PoolLaneHelper {
    public static boolean resizeLeft = false;
    public static boolean resizeTop = false;
    public static Comparator RECT_COMPARATOR = new RectangleComparator();
    public static int space = 10;
    public static final int CHILD_LANES_MINSIZE = 1;
    public static final int CHILD_LANES_MAXSIZE = 2;
    public static final int CHILD_LANES_CONTAINER_SIZE = 3;
    public static final int CHILD_LANES_SAME_SIZE = 4;

    public static int getSpace() {
        int space = PoolLaneUtils.space;
        DiagramEditorPage diagramEditorPage = (DiagramEditorPage)((WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getCurrentPage();
        EditPart diagramEP = diagramEditorPage.findEditPart(diagramEditorPage.getDiagram());
        if (SnapGridUtils.getSnapToHelper((AbstractGraphicalEditPart)diagramEP) != null) {
            space = SnapGridUtils.getNextSnapSize(space);
        }
        return space;
    }

    public static boolean containsSymbols(EditPart editPart) {
        if (PoolLaneUtils.containsLanes(editPart)) {
            List children = editPart.getChildren();
            int i = 0;
            while (i < children.size()) {
                EditPart childEP = (EditPart)children.get(i);
                if (childEP instanceof AbstractSwimlaneEditPart && PoolLaneHelper.containsSymbols(childEP)) {
                    return true;
                }
                ++i;
            }
        } else if (PoolLaneUtils.containsOthers((AbstractSwimlaneEditPart)editPart)) {
            return true;
        }
        return false;
    }

    public static void checkChildrenForShrinkToFit(int[] currentSpace, AbstractSwimlaneEditPart swimLaneEP, List siblings, boolean childSibling, boolean[] fixGrid, Dimension dimension) {
        boolean isSibling = false;
        if (!siblings.isEmpty() && siblings.contains(swimLaneEP)) {
            isSibling = true;
        }
        if (childSibling) {
            isSibling = true;
        }
        if (!PoolLaneHelper.containsLanes((EditPart)swimLaneEP) && !PoolLaneHelper.containsOthers(swimLaneEP)) {
            Rectangle rect = GenericUtils.getSymbolRectangle((EditPart)swimLaneEP);
            if (rect.width < dimension.width) {
                dimension.width = rect.width;
            }
            if (rect.height < dimension.height) {
                dimension.height = rect.height;
            }
        }
        if (PoolLaneHelper.containsOthers(swimLaneEP)) {
            PoolLaneHelper.getSpaceForShrinkToFit(currentSpace, (EditPart)swimLaneEP, isSibling, fixGrid);
        } else if (PoolLaneHelper.containsLanes((EditPart)swimLaneEP)) {
            List children = swimLaneEP.getChildren();
            int i = 0;
            while (i < children.size()) {
                LaneEditPart childEP = (LaneEditPart)children.get(i);
                PoolLaneHelper.checkChildrenForShrinkToFit(currentSpace, childEP, siblings, isSibling, fixGrid, dimension);
                ++i;
            }
        }
    }

    public static boolean canShrink(AbstractSwimlaneEditPart editPart, int[] currentSpace) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)editPart.getModel()));
        OrientationType direction = diagram.getOrientation();
        ArrayList siblings = new ArrayList();
        if (!(editPart instanceof PoolEditPart)) {
            EditPart parentEP = editPart.getParent();
            AbstractSwimlaneEditPart checkEP = editPart;
            while (!(parentEP instanceof DiagramEditPart)) {
                List checkSiblings = PoolLaneUtils.getSiblings(parentEP, (EditPart)checkEP);
                if (!checkSiblings.isEmpty()) {
                    siblings.addAll(checkSiblings);
                }
                checkEP = parentEP;
                parentEP = parentEP.getParent();
            }
        }
        boolean[] fixGrid = new boolean[2];
        AbstractSwimlaneEditPart poolEP = (AbstractSwimlaneEditPart)PoolLaneHelper.getPoolEditPart((EditPart)editPart);
        PoolFigure poolFigure = (PoolFigure)poolEP.getFigure();
        Insets insets = poolFigure.getInsets();
        Dimension dimension = new Dimension(GenericUtils.getSymbolRectangle((EditPart)poolEP).getSize());
        PoolLaneHelper.checkChildrenForShrinkToFit(currentSpace, poolEP, siblings, false, fixGrid, dimension);
        if (SnapGridUtils.getSnapToHelper(editPart) != null) {
            if (fixGrid[0]) {
                currentSpace[0] = currentSpace[0] - SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE / 2;
            }
            if (fixGrid[1]) {
                currentSpace[1] = currentSpace[1] - SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE / 2;
            }
        }
        if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
            if (currentSpace[1] >= currentSpace[3]) {
                if (currentSpace[1] >= dimension.height) {
                    currentSpace[1] = dimension.height - insets.getHeight();
                    currentSpace[3] = -1;
                } else {
                    dimension.height -= currentSpace[1];
                    if (currentSpace[3] >= dimension.height) {
                        currentSpace[3] = dimension.height - insets.getHeight();
                    }
                }
            } else if (currentSpace[3] >= dimension.height) {
                currentSpace[3] = dimension.height - insets.getHeight();
                currentSpace[1] = -1;
            } else {
                dimension.height -= currentSpace[3];
                if (currentSpace[1] >= dimension.height) {
                    currentSpace[1] = dimension.height - insets.getHeight();
                }
            }
        } else if (currentSpace[0] >= currentSpace[2]) {
            if (currentSpace[0] >= dimension.width) {
                currentSpace[0] = dimension.width - insets.getWidth();
                currentSpace[2] = -1;
            } else {
                dimension.width -= currentSpace[0];
                if (currentSpace[2] >= dimension.width) {
                    currentSpace[2] = dimension.width - insets.getWidth();
                }
            }
        } else if (currentSpace[2] >= dimension.width) {
            currentSpace[2] = dimension.width - insets.getWidth();
            currentSpace[0] = -1;
        } else {
            dimension.width -= currentSpace[2];
            if (currentSpace[0] >= dimension.width) {
                currentSpace[0] = dimension.width - insets.getWidth();
            }
        }
        return SnapGridUtils.getSnapToHelper(editPart) != null ? currentSpace[0] > SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE || currentSpace[1] > SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE || currentSpace[2] > SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE || currentSpace[3] > SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE : currentSpace[0] > 0 || currentSpace[1] > 0 || currentSpace[2] > 0 || currentSpace[3] > 0;
    }

    public static void getSpaceForShrinkToFit(int[] currentSpace, EditPart laneEP, boolean isSibling, boolean[] fixGrid) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)laneEP.getModel()));
        if (diagram == null) {
            return;
        }
        OrientationType direction = diagram.getOrientation();
        Rectangle drawingArea = null;
        List children = laneEP.getChildren();
        Rectangle parentBounds = GenericUtils.getSymbolRectangle(laneEP);
        Insets insets = ((AbstractSwimlaneFigure)((GraphicalEditPart)laneEP).getFigure()).getAbstractSwimlaneFigureInsets();
        int i = 0;
        while (i < children.size()) {
            Figure childFigure = (Figure)((AbstractGraphicalEditPart)children.get(i)).getFigure();
            if (drawingArea != null) {
                drawingArea.union(childFigure.getBounds());
            } else {
                drawingArea = childFigure.getBounds().getCopy();
            }
            ++i;
        }
        int left = drawingArea.x;
        int top = drawingArea.y - insets.bottom * 2;
        int right = parentBounds.width - (drawingArea.width + drawingArea.x) - insets.getWidth();
        int bottom = parentBounds.height - (drawingArea.height + drawingArea.y) - insets.getHeight() - insets.bottom;
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        if (right < 0) {
            right = 0;
        }
        if (bottom < 0) {
            bottom = 0;
        }
        if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
            if (!(left >= currentSpace[0] && currentSpace[0] != -1 || isSibling)) {
                currentSpace[0] = left;
            }
            if (top < currentSpace[1] || currentSpace[1] == -1) {
                currentSpace[1] = top;
            }
            if (!(right >= currentSpace[2] && currentSpace[2] != -1 || isSibling)) {
                currentSpace[2] = right;
            }
            if (bottom < currentSpace[3] || currentSpace[3] == -1) {
                currentSpace[3] = bottom;
            }
        } else {
            if (left < currentSpace[0] || currentSpace[0] == -1) {
                currentSpace[0] = left;
            }
            if (!(top >= currentSpace[1] && currentSpace[1] != -1 || isSibling)) {
                currentSpace[1] = top;
            }
            if (right < currentSpace[2] || currentSpace[2] == -1) {
                currentSpace[2] = right;
            }
            if (!(bottom >= currentSpace[3] && currentSpace[3] != -1 || isSibling)) {
                currentSpace[3] = bottom;
            }
        }
        if (SnapGridUtils.getSnapToHelper((AbstractGraphicalEditPart)laneEP) != null) {
            PoolLaneHelper.checkAllChildrenForMove(laneEP, currentSpace, fixGrid);
        }
    }

    public static void setResizeFlags(int directions) {
        if (directions == -1) {
            resizeLeft = false;
            resizeTop = false;
            return;
        }
        if (directions == 12) {
            resizeLeft = true;
            resizeTop = false;
        } else if (directions == 8) {
            resizeLeft = true;
            resizeTop = false;
        } else if (directions == 9) {
            resizeLeft = true;
            resizeTop = true;
        } else if (directions == 1) {
            resizeLeft = false;
            resizeTop = true;
        } else if (directions == 17) {
            resizeLeft = false;
            resizeTop = true;
        } else {
            resizeLeft = false;
            resizeTop = false;
        }
    }

    public static Rectangle checkPoolSize(DiagramEditPart part) {
        List children;
        Rectangle drawingArea = null;
        Rectangle newSize = null;
        PoolEditPart poolEP = part.getPoolDelegate();
        if (poolEP == null) {
            return newSize;
        }
        INodeSymbol poolSymbol = (INodeSymbol)poolEP.getModel();
        Rectangle poolRectangle = new Rectangle(0, 0, poolSymbol.getWidth(), poolSymbol.getHeight());
        if (poolRectangle.width == -1 || poolRectangle.height == -1) {
            DiagramType diagram = (DiagramType)part.getModel();
            OrientationType direction = diagram.getOrientation();
            if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                poolRectangle.setSize(PoolFigure.getDimension(true));
            } else {
                poolRectangle.setSize(PoolFigure.getDimension(false));
            }
        }
        if ((children = poolEP.getChildren()).size() == 0) {
            return newSize;
        }
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            Rectangle symbolRectangle = GenericUtils.getSymbolRectangle(editPart);
            if (drawingArea != null) {
                drawingArea.union(symbolRectangle);
            } else {
                drawingArea = symbolRectangle;
            }
            ++i;
        }
        drawingArea.width += drawingArea.x;
        drawingArea.height += drawingArea.y;
        drawingArea.x = 0;
        drawingArea.y = 0;
        Insets insets = ((AbstractSwimlaneFigure)poolEP.getFigure()).getAbstractSwimlaneFigureInsets();
        drawingArea.width += insets.getWidth();
        drawingArea.height += insets.getHeight();
        if (poolRectangle.width < drawingArea.width || poolRectangle.height < drawingArea.height) {
            if (drawingArea.width < poolRectangle.width) {
                drawingArea.width = poolRectangle.width;
            }
            if (drawingArea.height < poolRectangle.height) {
                drawingArea.height = poolRectangle.height;
            }
        }
        newSize = new Rectangle(drawingArea);
        return newSize;
    }

    public static Point findViewportPoint(GraphicalEditPart part) {
        IFigure figure = part.getFigure();
        Viewport port = null;
        while (figure != null) {
            if (figure instanceof Viewport) {
                port = (Viewport)figure;
                break;
            }
            figure = figure.getParent();
        }
        Point view = null;
        if (port != null) {
            view = port.getViewLocation();
        }
        return view;
    }

    /*
     * Unable to fully structure code
     */
    public static EditPart getPoolEditPart(EditPart targetEP) {
        poolEP = targetEP;
        if (poolEP instanceof PoolEditPart) {
            return poolEP;
        }
        if (!(poolEP instanceof DiagramEditPart)) ** GOTO lbl10
        return ((DiagramEditPart)poolEP).getPoolDelegate();
lbl-1000:
        // 1 sources

        {
            if ((poolEP = poolEP.getParent()) instanceof PoolEditPart) {
                return poolEP;
            }
            if (!(poolEP instanceof DiagramEditPart)) continue;
            return ((DiagramEditPart)poolEP).getPoolDelegate();
lbl10:
            // 2 sources

            ** while (!(poolEP instanceof PoolEditPart) || !(poolEP instanceof DiagramEditPart))
        }
lbl11:
        // 1 sources

        return null;
    }

    public static EditPart findTargetEditPart(WorkflowModelEditor editor) {
        IEditorPart part = editor.getCurrentPage();
        if (!(part instanceof DiagramEditorPage)) {
            return null;
        }
        DiagramEditorPage diagramEditorPage = (DiagramEditorPage)part;
        if (diagramEditorPage != null && diagramEditorPage.getMouseLocation() != null) {
            Point location = diagramEditorPage.getMouseLocation().getCopy();
            GraphicalViewer editPartViewer = diagramEditorPage.getGraphicalViewer();
            EditPart editPart = editPartViewer.findObjectAt(location);
            if (editPart instanceof DiagramRootEditPart) {
                editPart = (EditPart)((DiagramRootEditPart)editPart).getChildren().get(0);
            }
            return editPart;
        }
        return null;
    }

    public static List getSiblings(EditPart parent, EditPart changedEP) {
        ArrayList<EditPart> siblings = new ArrayList<EditPart>();
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart childEP = (EditPart)children.get(i);
            if (!childEP.getModel().equals(changedEP.getModel()) && childEP instanceof LaneEditPart) {
                siblings.add(childEP);
            }
            ++i;
        }
        return siblings;
    }

    public static boolean containsOthers(AbstractSwimlaneEditPart containerEP) {
        List children = containerEP.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            if (!(editPart instanceof LaneEditPart)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLanes(EditPart containerEP) {
        if (containerEP instanceof DiagramEditPart && ModelUtils.findContainingProcess((EObject)((EObject)containerEP.getModel())) != null) {
            PoolSymbol pool = DiagramUtil.getDefaultPool((DiagramType)((DiagramType)containerEP.getModel()));
            return pool.getChildLanes().size() > 0;
        }
        List children = ((AbstractSwimlaneEditPart)containerEP).getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            if (editPart instanceof LaneEditPart) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean canMove(LaneEditPart hostEP, LaneEditPart laneEP) {
        IModelParticipant laneParticipant = ((ISwimlaneSymbol)laneEP.getModel()).getParticipantReference();
        List childParticipants = null;
        if (laneParticipant == null && (childParticipants = HierarchyUtils.getTopLevelChildParticipants((LaneSymbol)laneEP.getModel())) == null) {
            return true;
        }
        ModelType model = (ModelType)hostEP.getEditor().getModel();
        IModelParticipant hostParticipant = null;
        Map organizationTree = HierarchyUtils.createHierarchy(model);
        AbstractSwimlaneEditPart parentEP = hostEP;
        IModelParticipant parentParticipant = null;
        while (parentEP != null && !(parentEP instanceof PoolEditPart)) {
            parentParticipant = ((ISwimlaneSymbol)parentEP.getModel()).getParticipantReference();
            if (parentParticipant != null) {
                hostParticipant = parentParticipant;
                break;
            }
            parentEP = (AbstractSwimlaneEditPart)parentEP.getParent();
        }
        if (hostParticipant == null) {
            return true;
        }
        if (!(hostParticipant instanceof OrganizationType)) {
            return false;
        }
        List organizationChildren = HierarchyUtils.getChildHierarchy(organizationTree, (OrganizationType)hostParticipant);
        List participants = new ArrayList();
        if (organizationChildren != null && HierarchyUtils.getParticipants(organizationChildren) != null) {
            participants = HierarchyUtils.getParticipants(organizationChildren);
        }
        return laneParticipant != null ? participants.contains(laneParticipant) : participants.containsAll(childParticipants);
    }

    public static Command moveDefaultPool(PoolEditPart target) {
        MoveNodeSymbolCommand moveCommand = new MoveNodeSymbolCommand();
        moveCommand.setPart((INodeSymbol)target.getModel());
        moveCommand.setLocation(new Point(0, 0));
        return moveCommand;
    }

    public static void getSnapGridResizeValue(EditPart parentEP, int[] resizeValue, boolean[] addFixValue) {
        List children = parentEP.getChildren();
        int correctionX = 0;
        int correctionY = 0;
        int i = 0;
        while (i < children.size()) {
            EditPart childEP = (EditPart)children.get(i);
            INodeSymbol childSymbol = (INodeSymbol)childEP.getModel();
            Point location = new Point(new Long(childSymbol.getXPos()).intValue() + resizeValue[0], new Long(childSymbol.getYPos()).intValue() + resizeValue[1]);
            Point newLocation = SnapGridUtils.getSnapLocation((AbstractGraphicalEditPart)parentEP, (AbstractNodeSymbolEditPart)childEP, null, null, location);
            if (newLocation.x < 0 && newLocation.x < correctionX) {
                correctionX = newLocation.x;
            }
            if (newLocation.y < 0 && newLocation.y < correctionY) {
                correctionY = newLocation.y;
            }
            ++i;
        }
        if (SnapGridUtils.getSnapToHelper((AbstractGraphicalEditPart)parentEP) != null) {
            correctionX = -correctionX;
            correctionY = -correctionY;
            if (correctionX != 0 && correctionX < SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE / 2) {
                correctionX += SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE / 2;
            }
            if (correctionY != 0 && correctionY < SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE / 2) {
                correctionY += SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE / 2;
            }
        }
        resizeValue[0] = resizeValue[0] + correctionX;
        resizeValue[1] = resizeValue[1] + correctionY;
        Rectangle parentBounds = GenericUtils.getSymbolRectangle(parentEP);
        int i2 = 0;
        while (i2 < children.size()) {
            EditPart childEP = (EditPart)children.get(i2);
            INodeSymbol childSymbol = (INodeSymbol)childEP.getModel();
            Point location = new Point(new Long(childSymbol.getXPos()).intValue() + resizeValue[0], new Long(childSymbol.getYPos()).intValue() + resizeValue[1]);
            Point newLocation = SnapGridUtils.getSnapLocation((AbstractGraphicalEditPart)parentEP, (AbstractNodeSymbolEditPart)childEP, null, null, location);
            if (newLocation.x + childSymbol.getWidth() > parentBounds.width && !addFixValue[0]) {
                addFixValue[0] = true;
            }
            if (newLocation.y + childSymbol.getHeight() > parentBounds.height && !addFixValue[1]) {
                addFixValue[1] = true;
            }
            ++i2;
        }
    }

    public static void checkAllChildrenForMove(EditPart parentEP, int[] resizeValue, boolean[] result) {
        List children = parentEP.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart childEP = (EditPart)children.get(i);
            INodeSymbol childSymbol = (INodeSymbol)childEP.getModel();
            Point location = new Point(new Long(childSymbol.getXPos()).intValue() - resizeValue[0], new Long(childSymbol.getYPos()).intValue() - resizeValue[1]);
            Point newLocation = SnapGridUtils.getSnapLocation((AbstractGraphicalEditPart)parentEP, (AbstractNodeSymbolEditPart)childEP, null, null, location);
            if (newLocation.x <= 0 || newLocation.y <= 0) {
                if (newLocation.x <= 0) {
                    result[0] = true;
                }
                if (newLocation.y <= 0) {
                    result[1] = true;
                }
            }
            ++i;
        }
    }

    public static void checkForNegativePositions(PoolSymbol pool, int[] moveValue) {
        FeatureMap.ValueListIterator iter = pool.getNodes().valueListIterator();
        while (iter.hasNext()) {
            INodeSymbol symbol = (INodeSymbol)iter.next();
            int x = new Long(symbol.getXPos()).intValue();
            int y = new Long(symbol.getYPos()).intValue();
            if (x < 0 && (moveValue[0] == 0 || moveValue[0] > x)) {
                moveValue[0] = x;
            }
            if (y >= 0 || moveValue[1] != 0 && moveValue[1] <= y) continue;
            moveValue[1] = y;
        }
    }

    public static CompoundCommand moveAllChildren(EditPart parentEP, int[] resizeValue) {
        CompoundCommand cmd = new CompoundCommand();
        List children = parentEP.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart childEP = (EditPart)children.get(i);
            INodeSymbol childSymbol = (INodeSymbol)childEP.getModel();
            Point location = new Point(new Long(childSymbol.getXPos()).intValue() + resizeValue[0], new Long(childSymbol.getYPos()).intValue() + resizeValue[1]);
            Point newLocation = SnapGridUtils.getSnapLocation((AbstractGraphicalEditPart)parentEP, (AbstractNodeSymbolEditPart)childEP, null, null, location);
            if (newLocation.x >= 0 && newLocation.y >= 0) {
                MoveNodeSymbolCommand moveCommand = new MoveNodeSymbolCommand();
                moveCommand.setPart(childSymbol);
                moveCommand.setLocation(newLocation);
                cmd.add((Command)moveCommand);
            } else {
                cmd.add((Command)UnexecutableCommand.INSTANCE);
            }
            ++i;
        }
        return cmd;
    }

    public static double getOnePercent(AbstractSwimlaneEditPart containerEP, int[] fixValue, AbstractSwimlaneEditPart laneEP) {
        INodeSymbol symbol;
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)containerEP.getModel()));
        OrientationType direction = diagram.getOrientation();
        double onePercent = 0.0;
        int wholeSize = 0;
        List children = containerEP.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            boolean checkLane = true;
            if (laneEP != null) {
                checkLane = PoolLaneHelper.checkContainerForResize(editPart, (EditPart)laneEP);
            }
            symbol = (INodeSymbol)editPart.getModel();
            if (PoolLaneHelper.canChange(editPart) && checkLane) {
                wholeSize = OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? (wholeSize += symbol.getWidth()) : (wholeSize += symbol.getHeight());
            }
            ++i;
        }
        onePercent = (double)wholeSize / 100.0;
        int checkWholeSize = 0;
        int i2 = 0;
        while (i2 < children.size()) {
            EditPart editPart = (EditPart)children.get(i2);
            symbol = (INodeSymbol)editPart.getModel();
            if (PoolLaneHelper.canChange(editPart)) {
                double factor;
                if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                    factor = (double)symbol.getWidth() / onePercent / 100.0;
                    checkWholeSize = (int)((double)checkWholeSize + (double)wholeSize * factor);
                } else {
                    factor = (double)symbol.getHeight() / onePercent / 100.0;
                    checkWholeSize = (int)((double)checkWholeSize + (double)wholeSize * factor);
                }
            }
            ++i2;
        }
        fixValue[0] = wholeSize - checkWholeSize;
        return onePercent;
    }

    public static boolean canChange(EditPart parentEP) {
        List children = parentEP.getChildren();
        if (!PoolLaneHelper.containsLanes(parentEP)) {
            return !(parentEP instanceof LaneEditPart) || !((LaneEditPart)parentEP).getLaneFigure().isCollapsed();
        }
        boolean containsExpanded = false;
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            if (!((LaneEditPart)editPart).getLaneFigure().isCollapsed() && (containsExpanded = PoolLaneHelper.canChange(editPart))) break;
            ++i;
        }
        return containsExpanded;
    }

    public static int[] getNewLaneSizeForValidation(EditPart targetEP, int[] newSpace, boolean resize) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)targetEP.getModel()));
        OrientationType direction = diagram.getOrientation();
        INodeSymbol symbol = (INodeSymbol)targetEP.getModel();
        Insets insets = ((AbstractSwimlaneFigure)((GraphicalEditPart)targetEP).getFigure()).getAbstractSwimlaneFigureInsets();
        int newInnerWidth = 0;
        int newInnerHeight = 0;
        if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
            newInnerWidth = PoolLaneHelper.canChange(targetEP) && resize ? symbol.getWidth() + newSpace[0] : symbol.getWidth();
            newInnerHeight = symbol.getHeight() + newSpace[1];
        } else {
            newInnerWidth = symbol.getWidth() + newSpace[0];
            newInnerHeight = PoolLaneHelper.canChange(targetEP) && resize ? symbol.getHeight() + newSpace[1] : symbol.getHeight();
        }
        if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
            newInnerWidth -= insets.getWidth() / 2;
            newInnerHeight -= insets.top;
        } else {
            newInnerWidth -= insets.left;
            newInnerHeight -= insets.getHeight() / 2;
        }
        int[] innerSpace = new int[]{newInnerWidth, newInnerHeight};
        return innerSpace;
    }

    public static int[] getNewChildLaneSize(EditPart childEP, int[] newSpace, double onePercent) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)childEP.getModel()));
        OrientationType direction = diagram.getOrientation();
        INodeSymbol symbol = (INodeSymbol)childEP.getModel();
        double factor = OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? (double)symbol.getWidth() / onePercent / 100.0 : (double)symbol.getHeight() / onePercent / 100.0;
        int[] newInnerSpace = new int[2];
        if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
            newInnerSpace = new int[]{(int)((double)newSpace[0] * factor), newSpace[1]};
            if (!PoolLaneHelper.canChange(childEP)) {
                int[] nArray = new int[2];
                nArray[1] = newSpace[1];
                newInnerSpace = nArray;
            }
        } else {
            newInnerSpace = new int[]{newSpace[0], (int)((double)newSpace[1] * factor)};
            if (!PoolLaneHelper.canChange(childEP)) {
                int[] nArray = new int[2];
                nArray[0] = newSpace[0];
                newInnerSpace = nArray;
            }
        }
        return newInnerSpace;
    }

    public static boolean checkContainerForResize(EditPart checkEP, EditPart changedEP) {
        if (changedEP instanceof PoolEditPart) {
            return true;
        }
        if (checkEP.equals(changedEP)) {
            return true;
        }
        if (PoolLaneHelper.containsLanes(changedEP)) {
            List children = changedEP.getChildren();
            int i = 0;
            while (i < children.size()) {
                EditPart childEP = (EditPart)children.get(i);
                if (PoolLaneHelper.checkContainerForResize(checkEP, childEP)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean hasCollision(EditPart targetEP, AbstractSwimlaneEditPart laneEP, int[] newSpace) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)targetEP.getModel()));
        OrientationType direction = diagram.getOrientation();
        if (!PoolLaneUtils.containsLanes(targetEP) && targetEP.getChildren().size() != 0) {
            int[] innerSpace = PoolLaneHelper.getNewLaneSizeForValidation(targetEP, newSpace, PoolLaneHelper.checkContainerForResize(targetEP, (EditPart)laneEP));
            int newInnerWidth = innerSpace[0];
            int newInnerHeight = innerSpace[1];
            Rectangle drawingArea = null;
            List children = targetEP.getChildren();
            Rectangle parentBounds = GenericUtils.getSymbolRectangle(targetEP);
            Insets insets = ((AbstractSwimlaneFigure)((GraphicalEditPart)targetEP).getFigure()).getAbstractSwimlaneFigureInsets();
            int i = 0;
            while (i < children.size()) {
                Figure childFigure = (Figure)((AbstractGraphicalEditPart)children.get(i)).getFigure();
                if (drawingArea != null) {
                    drawingArea.union(childFigure.getBounds());
                } else {
                    drawingArea = childFigure.getBounds().getCopy();
                }
                ++i;
            }
            if (drawingArea != null) {
                if (!resizeLeft) {
                    drawingArea.width += drawingArea.x;
                    drawingArea.width += insets.right;
                } else {
                    drawingArea.width += parentBounds.width - (drawingArea.width + drawingArea.x);
                    drawingArea.width -= insets.left;
                }
                if (!resizeTop) {
                    drawingArea.height += drawingArea.y;
                    drawingArea.height += insets.bottom * 2;
                } else {
                    drawingArea.height += parentBounds.height - (drawingArea.height + drawingArea.y);
                    drawingArea.height -= insets.top;
                    drawingArea.height += insets.bottom * 2;
                }
                if (newInnerHeight < drawingArea.height || newInnerWidth < drawingArea.width) {
                    return true;
                }
            }
        } else if (PoolLaneUtils.containsLanes(targetEP)) {
            List children = targetEP.getChildren();
            int[] fixValue = new int[1];
            double onePercent = PoolLaneHelper.getOnePercent((AbstractSwimlaneEditPart)targetEP, fixValue, laneEP);
            int i = 0;
            while (i < children.size()) {
                EditPart childEP = (EditPart)children.get(i);
                int[] newInnerSpace = PoolLaneHelper.getNewChildLaneSize(childEP, newSpace, onePercent);
                if (!PoolLaneHelper.checkContainerForResize(childEP, (EditPart)laneEP)) {
                    if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                        newInnerSpace[0] = newSpace[0];
                    } else {
                        newInnerSpace[1] = newSpace[1];
                    }
                }
                if (PoolLaneHelper.hasCollision(childEP, laneEP, newInnerSpace)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean laneTooSmall(EditPart targetEP, AbstractSwimlaneEditPart laneEP, int[] newSpace) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)targetEP.getModel()));
        OrientationType direction = diagram.getOrientation();
        if (targetEP instanceof LaneEditPart) {
            int[] innerSpace = PoolLaneHelper.getNewLaneSizeForValidation(targetEP, newSpace, PoolLaneHelper.checkContainerForResize(targetEP, (EditPart)laneEP));
            int newInnerWidth = innerSpace[0];
            int newInnerHeight = innerSpace[1];
            if (OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? newInnerHeight < LaneFigure.getCollapsedSize((EditPart)laneEP) / 2 || newInnerWidth < LaneFigure.getCollapsedSize((EditPart)laneEP) : newInnerWidth < LaneFigure.getCollapsedSize((EditPart)laneEP) / 2 || newInnerHeight < LaneFigure.getCollapsedSize((EditPart)laneEP)) {
                return true;
            }
        }
        if (targetEP.getChildren().size() != 0 && PoolLaneUtils.containsLanes(targetEP)) {
            List children = targetEP.getChildren();
            int[] fixValue = new int[1];
            double onePercent = PoolLaneHelper.getOnePercent((AbstractSwimlaneEditPart)targetEP, fixValue, laneEP);
            int i = 0;
            while (i < children.size()) {
                EditPart childEP = (EditPart)children.get(i);
                int[] newInnerSpace = PoolLaneHelper.getNewChildLaneSize(childEP, newSpace, onePercent);
                if (!PoolLaneHelper.checkContainerForResize(childEP, (EditPart)laneEP)) {
                    if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                        newInnerSpace[0] = newSpace[0];
                    } else {
                        newInnerSpace[1] = newSpace[1];
                    }
                }
                if (PoolLaneHelper.laneTooSmall(childEP, laneEP, newInnerSpace)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isSensitiveArea(AbstractSwimlaneEditPart containerEP, Point location) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)containerEP.getModel()));
        OrientationType direction = diagram.getOrientation();
        if (OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? location.x < 0 : location.y < 0) {
            return false;
        }
        Rectangle containerBounds = containerEP.getFigure().getBounds().getCopy();
        int lastPosition = 0;
        ArrayList<Rectangle> areas = new ArrayList<Rectangle>();
        List children = containerEP.getChildren();
        ArrayList<EditPart> lanes = new ArrayList<EditPart>();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            if (editPart instanceof LaneEditPart) {
                lanes.add(editPart);
            }
            ++i;
        }
        if (lanes.size() > 0) {
            i = 0;
            while (i < lanes.size()) {
                LaneEditPart laneEP = (LaneEditPart)lanes.get(i);
                LaneFigure figure = laneEP.getLaneFigure();
                Rectangle figureRectangle = new Rectangle(figure.getBounds().getCopy());
                areas.add(figureRectangle);
                ++i;
            }
        } else {
            return true;
        }
        ((RectangleComparator)RECT_COMPARATOR).setOrientation(direction);
        Collections.sort(areas, RECT_COMPARATOR);
        if (areas.size() > 0) {
            i = 0;
            while (i < areas.size()) {
                Rectangle area = ((Rectangle)areas.get(i)).getCopy();
                if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                    if (location.x > lastPosition && location.x < area.x) {
                        return true;
                    }
                    lastPosition = area.x + area.width;
                } else {
                    if (location.y > lastPosition && location.y < area.y) {
                        return true;
                    }
                    lastPosition = area.y + area.height;
                }
                ++i;
            }
            if (OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? location.x > lastPosition && location.x < containerBounds.width : location.y > lastPosition && location.y < containerBounds.height) {
                return true;
            }
        }
        return false;
    }

    public static Point getLocationDelta(IFigure parentFigure, IFigure hostFigure, DiagramType diagram) {
        Insets insets;
        Point newLocation = new Point(0, 0);
        OrientationType direction = diagram.getOrientation();
        while (parentFigure != null && parentFigure instanceof AbstractSwimlaneFigure) {
            Point parentFigureLocation = parentFigure.getBounds().getLocation().getCopy();
            insets = ((AbstractSwimlaneFigure)parentFigure).getAbstractSwimlaneFigureInsets();
            if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                newLocation.x += insets.getWidth() / 2;
                newLocation.y += insets.top;
            } else {
                newLocation.x += insets.left;
                newLocation.y += insets.getHeight() / 2;
            }
            newLocation.x += parentFigureLocation.x;
            newLocation.y += parentFigureLocation.y;
            parentFigure = parentFigure.getParent();
        }
        while (hostFigure != null && hostFigure instanceof AbstractSwimlaneFigure) {
            Point hostFigureLocation = hostFigure.getBounds().getLocation().getCopy();
            insets = ((AbstractSwimlaneFigure)hostFigure).getAbstractSwimlaneFigureInsets();
            if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                newLocation.x -= insets.getWidth() / 2;
                newLocation.y -= insets.top;
            } else {
                newLocation.x -= insets.left;
                newLocation.y -= insets.getHeight() / 2;
            }
            newLocation.x -= hostFigureLocation.x;
            newLocation.y -= hostFigureLocation.y;
            hostFigure = hostFigure.getParent();
        }
        return newLocation;
    }

    public static Point getAbsoluteLocation(EditPart hostEP, Point location, DiagramType diagram) {
        OrientationType direction = diagram.getOrientation();
        Point newLocation = new Point(location);
        IFigure figure = ((GraphicalEditPart)hostEP).getFigure();
        while (figure != null && !(figure instanceof FreeformLayer)) {
            Point parentFigureLocation = figure.getBounds().getLocation().getCopy();
            newLocation.x += parentFigureLocation.x;
            newLocation.y += parentFigureLocation.y;
            Insets insets = ((AbstractSwimlaneFigure)figure).getAbstractSwimlaneFigureInsets();
            if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                newLocation.x += insets.getWidth() / 2;
                newLocation.y += insets.top;
            } else {
                newLocation.x += insets.left;
                newLocation.y += insets.getHeight() / 2;
            }
            figure = figure.getParent();
        }
        return newLocation;
    }

    public static Point getLocation(GraphicalEditPart part, IFigure hostFigure, Point location, boolean createLocation) {
        Point newLocation = null;
        DiagramType diagram = null;
        diagram = part.getModel() instanceof DiagramType ? (DiagramType)part.getModel() : ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)part.getModel()));
        IFigure partFigure = part.getFigure();
        IFigure parentFigure = partFigure.getParent();
        newLocation = location != null ? location.getCopy() : part.getFigure().getBounds().getLocation().getCopy();
        if (partFigure.equals(hostFigure)) {
            parentFigure = null;
        }
        if (createLocation) {
            parentFigure = null;
            Point viewPortPoint = PoolLaneHelper.findViewportPoint(part);
            newLocation.performTranslate(viewPortPoint.x, viewPortPoint.y);
        }
        DiagramEditorPage diagramEditorPage = (DiagramEditorPage)((WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getCurrentPage();
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)diagramEditorPage.getGraphicalViewer().getRootEditPart();
        ZoomManager zoomManager = rootEditPart.getZoomManager();
        newLocation.performScale(1.0 / zoomManager.getZoom());
        Point locationDelta = PoolLaneUtils.getLocationDelta(parentFigure, hostFigure, diagram);
        newLocation.x += locationDelta.x;
        newLocation.y += locationDelta.y;
        return newLocation;
    }

    public static class RectangleComparator
    implements Comparator {
        OrientationType direction = null;

        public void setOrientation(OrientationType direction) {
            this.direction = direction;
        }

        public int compare(Object o1, Object o2) {
            long lx = ((Rectangle)o1).x;
            long ly = ((Rectangle)o1).y;
            long rx = ((Rectangle)o2).x;
            long ry = ((Rectangle)o2).y;
            if (OrientationType.VERTICAL_LITERAL.equals((Object)this.direction)) {
                if (lx != rx) {
                    return lx < rx ? -1 : 1;
                }
            } else if (ly != ry) {
                return ly < ry ? -1 : 1;
            }
            return 0;
        }
    }
}

