/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.ui.PlatformUI;

public class SymbolCollisionUtils {
    public static boolean isCollision(EditPart targetEP, Point useLocation) {
        FeatureMap.ValueListIterator iter = ((PoolSymbol)targetEP).getNodes().valueListIterator();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!(element instanceof INodeSymbol) || !SymbolCollisionUtils.isSymbolCollision((INodeSymbol)element, useLocation)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSymbolCollision(INodeSymbol symbol, Point useLocation) {
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        AbstractGraphicalEditPart editPart = (AbstractGraphicalEditPart)editor.findEditPart(symbol);
        IFigure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds().getCopy();
        return bounds.intersects(null);
    }
}

