/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.ActivitySymbolFigure;
import org.eclipse.stardust.modeling.core.editors.figures.DiagramLayer;
import org.eclipse.stardust.modeling.core.editors.figures.GatewayFigure;
import org.eclipse.stardust.modeling.core.editors.figures.TransitionConnectionFigure;
import org.eclipse.stardust.modeling.core.editors.figures.anchors.TransitionConnectionAnchor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractConnectionSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.ActivitySymbolNodeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.GatewaySymbolEditPart;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TransitionConnectionUtils {
    public static final int ADD_FIX_VALUE = 10;

    public static synchronized Integer isTransitionWithGateways(Connection conn, List savePositions, Point startPoint, Point endPoint, boolean[] isVertical, boolean[] gatewaysFlag) {
        Point startPoint_ = startPoint;
        Point endPoint_ = endPoint;
        int gateways = 0;
        Integer newPosition = null;
        boolean isLoop = false;
        ConnectionAnchor startAnchor = conn.getSourceAnchor();
        String startAnchorType = null;
        if (startAnchor instanceof TransitionConnectionAnchor) {
            startAnchorType = ((TransitionConnectionAnchor)startAnchor).getType();
        }
        ConnectionAnchor endAnchor = conn.getTargetAnchor();
        String endAnchorType = null;
        if (endAnchor instanceof TransitionConnectionAnchor) {
            endAnchorType = ((TransitionConnectionAnchor)endAnchor).getType();
        }
        if (startAnchor.getOwner() instanceof GatewayFigure || endAnchor.getOwner() instanceof GatewayFigure) {
            if (startAnchor.getOwner() instanceof GatewayFigure) {
                ++gateways;
                startPoint_ = TransitionConnectionUtils.getConnectionPoint(conn, startAnchor, true);
            } else {
                startAnchorType = null;
            }
            if (endAnchor.getOwner() instanceof GatewayFigure) {
                ++gateways;
                endPoint_ = TransitionConnectionUtils.getConnectionPoint(conn, endAnchor, false);
            } else {
                endAnchorType = null;
            }
            if (startPoint_ == null || endPoint_ == null) {
                return null;
            }
            isLoop = TransitionConnectionUtils.orderPoints(isVertical, startPoint_, endPoint_);
            if (isLoop) {
                String anchorType = null;
                if (gateways == 1) {
                    if (startAnchorType != null) {
                        anchorType = startAnchorType;
                        gatewaysFlag[0] = true;
                    } else {
                        anchorType = endAnchorType;
                    }
                } else if (gateways == 2) {
                    String compareAnchorType = null;
                    if (!isVertical[0]) {
                        if (startAnchorType.equals("top") || startAnchorType.equals("bottom")) {
                            anchorType = startAnchorType;
                            gatewaysFlag[0] = true;
                        }
                        if (endAnchorType.equals("top") || endAnchorType.equals("bottom")) {
                            compareAnchorType = endAnchorType;
                        }
                    } else {
                        if (startAnchorType.equals("left") || startAnchorType.equals("right")) {
                            anchorType = startAnchorType;
                            gatewaysFlag[0] = true;
                        }
                        if (endAnchorType.equals("left") || endAnchorType.equals("right")) {
                            compareAnchorType = endAnchorType;
                        }
                    }
                    if (anchorType != null || compareAnchorType != null) {
                        if (anchorType != null && compareAnchorType != null) {
                            if (!anchorType.equals(compareAnchorType)) {
                                anchorType = null;
                            }
                        } else if (anchorType == null) {
                            anchorType = compareAnchorType;
                        }
                    } else if (compareAnchorType != null) {
                        anchorType = compareAnchorType;
                    }
                }
                if (anchorType != null) {
                    boolean increase = true;
                    if (isVertical[0]) {
                        if (anchorType.equals("left")) {
                            increase = false;
                        }
                    } else if (anchorType.equals("top")) {
                        increase = false;
                    }
                    if ((newPosition = TransitionConnectionUtils.getNewPosition(conn, isVertical, increase, startPoint_, endPoint_)) != null) {
                        if (increase) {
                            return new Integer(newPosition + 10);
                        }
                        return new Integer(newPosition - 10);
                    }
                }
            }
        }
        return newPosition;
    }

    public static synchronized boolean orderPoints(boolean[] isVertical, Point startPoint_, Point endPoint_) {
        boolean isLoop = false;
        if (startPoint_.x == endPoint_.x) {
            isLoop = true;
            isVertical[0] = true;
            if (startPoint_.y > endPoint_.y) {
                Point tmpPoint = new Point(startPoint_);
                startPoint_.setLocation(endPoint_.x, endPoint_.y);
                endPoint_.setLocation(tmpPoint);
            }
        } else if (startPoint_.y == endPoint_.y) {
            isLoop = true;
            if (startPoint_.x > endPoint_.x) {
                Point tmpPoint = new Point(startPoint_);
                startPoint_.setLocation(endPoint_.x, endPoint_.y);
                endPoint_.setLocation(tmpPoint);
            }
        }
        return isLoop;
    }

    public static synchronized Integer getNewPosition(Connection conn, boolean[] isVertical, boolean increase, Point startPoint_, Point endPoint_) {
        Point connectionStartPoint = new Point(startPoint_);
        Point connectionEndPoint = new Point(endPoint_);
        boolean hasChanged = false;
        ConnectionAnchor startAnchor = conn.getSourceAnchor();
        IFigure startFigure = startAnchor.getOwner();
        IFigure parent = startFigure.getParent();
        if (parent instanceof DiagramLayer) {
            List children = ((DiagramLayer)parent).getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure figure = (IFigure)children.get(i);
                if (TransitionConnectionUtils.isCrossing(figure, connectionStartPoint, connectionEndPoint, isVertical)) {
                    hasChanged = true;
                    Rectangle figureBounds = figure.getBounds();
                    if (isVertical[0]) {
                        if (increase) {
                            connectionStartPoint.x = figureBounds.x + figureBounds.width;
                            connectionEndPoint.x = figureBounds.x + figureBounds.width;
                        } else {
                            connectionStartPoint.x = figureBounds.x;
                            connectionEndPoint.x = figureBounds.x;
                        }
                    } else if (increase) {
                        connectionStartPoint.y = figureBounds.y + figureBounds.height;
                        connectionEndPoint.y = figureBounds.y + figureBounds.height;
                    } else {
                        connectionStartPoint.y = figureBounds.y;
                        connectionEndPoint.y = figureBounds.y;
                    }
                }
                ++i;
            }
        }
        if (hasChanged) {
            if (isVertical[0]) {
                return new Integer(connectionStartPoint.x);
            }
            return new Integer(connectionStartPoint.y);
        }
        return null;
    }

    public static synchronized boolean isCrossing(IFigure figure, Point connectionStartPoint, Point connectionEndPoint, boolean[] isVertical) {
        Rectangle figureBounds = figure.getBounds();
        return isVertical[0] ? figureBounds.x <= connectionStartPoint.x && figureBounds.x + figureBounds.width >= connectionStartPoint.x && figureBounds.y >= connectionStartPoint.y && figureBounds.y + figureBounds.height <= connectionEndPoint.y : figureBounds.y <= connectionStartPoint.y && figureBounds.y + figureBounds.height >= connectionStartPoint.y && figureBounds.x >= connectionStartPoint.x && figureBounds.x + figureBounds.width <= connectionEndPoint.x;
    }

    public static synchronized Point getConnectionPoint(Connection conn, ConnectionAnchor anchor, boolean isStart) {
        ActivitySymbolNodeEditPart activityEditPart;
        TransitionConnectionType connection;
        IFlowObjectSymbol activitySymbol;
        GatewayFigure gatewayFigure = (GatewayFigure)anchor.getOwner();
        GatewaySymbolEditPart editPart = gatewayFigure.getEditPart();
        WorkflowModelEditor editor = editPart.getEditor();
        GatewaySymbol gatewaySymbol = (GatewaySymbol)editPart.getModel();
        EList inTransitions = gatewaySymbol.getInTransitions();
        EList outTransitions = gatewaySymbol.getOutTransitions();
        if (isStart) {
            ActivitySymbolNodeEditPart activityEditPart2;
            TransitionConnectionType connection2;
            IFlowObjectSymbol activitySymbol2;
            if (!inTransitions.isEmpty() && (activitySymbol2 = (connection2 = (TransitionConnectionType)inTransitions.get(0)).getSourceActivitySymbol()) instanceof ActivitySymbolType && (activityEditPart2 = (ActivitySymbolNodeEditPart)editor.findEditPart(activitySymbol2)) != null) {
                ActivitySymbolFigure activityFigure = (ActivitySymbolFigure)activityEditPart2.getFigure();
                return TransitionConnectionUtils.getPoint(conn, activityFigure, isStart);
            }
        } else if (!outTransitions.isEmpty() && (activitySymbol = (connection = (TransitionConnectionType)outTransitions.get(0)).getTargetActivitySymbol()) instanceof ActivitySymbolType && (activityEditPart = (ActivitySymbolNodeEditPart)editor.findEditPart(activitySymbol)) != null) {
            ActivitySymbolFigure activityFigure = (ActivitySymbolFigure)activityEditPart.getFigure();
            return TransitionConnectionUtils.getPoint(conn, activityFigure, isStart);
        }
        return null;
    }

    public static synchronized Point getPoint(Connection conn, ActivitySymbolFigure activityFigure, boolean isStart) {
        ConnectionLayer layer = (ConnectionLayer)conn.getParent();
        List children = layer.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure figure = (IFigure)children.get(i);
            if (figure instanceof TransitionConnectionFigure && !figure.equals(conn)) {
                ConnectionAnchor startAnchor = ((Connection)figure).getSourceAnchor();
                ConnectionAnchor endAnchor = ((Connection)figure).getTargetAnchor();
                if (startAnchor != null && startAnchor.getOwner() != null && startAnchor.getOwner().equals(activityFigure) && isStart) {
                    return ((TransitionConnectionFigure)figure).getEnd();
                }
                if (endAnchor != null && endAnchor.getOwner() != null && endAnchor.getOwner().equals(activityFigure) && !isStart) {
                    return ((TransitionConnectionFigure)figure).getStart();
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean showForkOnTraversal(TransitionConnectionType transitionConnection) {
        boolean showForkOnTraversal = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.viewForkOnTraversalMode");
        if (!showForkOnTraversal) {
            return false;
        }
        TransitionType transition = transitionConnection.getTransition();
        if (transition == null) {
            return false;
        }
        boolean transitionForkOnTraversal = transition.isForkOnTraversal();
        boolean viewHint = false;
        IFlowObjectSymbol sourceSymbol = transitionConnection.getSourceActivitySymbol();
        IFlowObjectSymbol targetSymbol = transitionConnection.getTargetActivitySymbol();
        if (sourceSymbol instanceof GatewaySymbol && targetSymbol instanceof ActivitySymbolType) {
            FlowControlType type = ((GatewaySymbol)sourceSymbol).getFlowKind();
            ActivitySymbolType activitySymbol = ((GatewaySymbol)sourceSymbol).getActivitySymbol();
            ActivityType activity = activitySymbol.getActivity();
            if (type == FlowControlType.SPLIT_LITERAL) {
                JoinSplitType splitType = activity.getSplit();
                if (splitType.equals((Object)JoinSplitType.XOR_LITERAL)) {
                    viewHint = true;
                } else if (splitType.equals((Object)JoinSplitType.AND_LITERAL)) {
                    return TransitionConnectionUtils.checkTransitions((GatewaySymbol)sourceSymbol, transitionConnection);
                }
            }
        } else if (sourceSymbol instanceof ActivitySymbolType && targetSymbol instanceof ActivitySymbolType) {
            viewHint = true;
        }
        return viewHint && transitionForkOnTraversal;
    }

    private static boolean checkTransitions(GatewaySymbol symbol, TransitionConnectionType transitionConnection) {
        IEditorPart editor;
        int forkOnTraversalTrue = 0;
        int forkOnTraversalFalse = 0;
        EList transitions = symbol.getOutTransitions();
        int size = transitions.size();
        Object firstTransition = null;
        for (TransitionConnectionType outTransitionConnection : transitions) {
            TransitionType outTransition = outTransitionConnection.getTransition();
            if (outTransition == null) {
                return false;
            }
            boolean transitionForkOnTraversal = outTransition.isForkOnTraversal();
            if (transitionForkOnTraversal) {
                ++forkOnTraversalTrue;
                continue;
            }
            ++forkOnTraversalFalse;
            if (firstTransition != null) continue;
            firstTransition = outTransition;
        }
        IWorkbenchWindow workBenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workBenchWindow.getActivePage();
        if (page != null && (editor = page.getActiveEditor()) instanceof WorkflowModelEditor) {
            for (TransitionConnectionType outTransitionConnection : transitions) {
                if (outTransitionConnection.equals(transitionConnection)) continue;
                AbstractConnectionSymbolEditPart editPart = (AbstractConnectionSymbolEditPart)((WorkflowModelEditor)editor).findEditPart(outTransitionConnection);
                if (editPart == null) break;
                if (forkOnTraversalTrue == size) {
                    ((TransitionConnectionFigure)editPart.getFigure()).updateForkOnTraversal(Boolean.TRUE);
                    continue;
                }
                if (forkOnTraversalFalse == 1 && firstTransition.equals(outTransitionConnection.getTransition())) {
                    ((TransitionConnectionFigure)editPart.getFigure()).updateForkOnTraversal(Boolean.FALSE);
                    continue;
                }
                if (forkOnTraversalFalse > 1 && firstTransition.equals(outTransitionConnection.getTransition())) {
                    ((TransitionConnectionFigure)editPart.getFigure()).updateForkOnTraversal(Boolean.FALSE);
                    continue;
                }
                ((TransitionConnectionFigure)editPart.getFigure()).updateForkOnTraversal(Boolean.TRUE);
            }
        }
        if (forkOnTraversalTrue == size) {
            return true;
        }
        if (forkOnTraversalFalse == 1 && firstTransition.equals(transitionConnection.getTransition())) {
            return false;
        }
        return forkOnTraversalFalse <= 1 || !firstTransition.equals(transitionConnection.getTransition());
    }
}

