/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.bookmark;

import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ViewType;
import org.eclipse.stardust.model.xpdl.carnot.ViewableType;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.dnd.ModelElementTransfer;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.AddViewAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DeleteViewAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.RenameViewAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ShowPropertiesAction;
import org.eclipse.stardust.modeling.core.editors.parts.tree.WorkflowModelTreeEditPartFactory;
import org.eclipse.stardust.modeling.core.views.bookmark.BookmarkDragSourceListener;
import org.eclipse.stardust.modeling.core.views.bookmark.BookmarkDropTargetListener;
import org.eclipse.stardust.modeling.core.views.bookmark.BookmarkViewContentProvider;
import org.eclipse.stardust.modeling.core.views.bookmark.BookmarkViewLabelProvider;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class WorkflowModelBookmarkView
extends ViewPart {
    private static final String[] PROPERTIES = new String[]{"viewTypes"};
    public static final String VIEW_ID = "org.eclipse.stardust.modeling.core.views.bookmark";
    private WorkflowModelEditor editor;
    private TreeViewer treeViewer;
    private boolean isDndInit = false;
    private EditDomain editDomain;
    private ModelType model;
    private Tree tree;
    private IAction[] actions = new IAction[4];

    public void createPartControl(Composite parent) {
        this.init(parent);
        this.editor = this.getActiveEditor();
        if (this.editor != null) {
            this.initTree();
        } else {
            this.tree.setVisible(false);
        }
        this.addSelectionListener();
    }

    private void initTree() {
        this.editDomain = this.editor.getEditDomain();
        this.model = this.editor.getWorkflowModel();
        if (this.model != null) {
            this.treeViewer.setInput((Object)this.model.eContainer());
            this.treeViewer.setColumnProperties(PROPERTIES);
            this.treeViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.treeViewer.getTree())});
            this.createActions();
            this.createCtxMenu();
            this.addDnd();
        }
    }

    private void init(Composite parent) {
        this.tree = new Tree(parent, 0);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)new BookmarkViewContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BookmarkViewLabelProvider());
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element instanceof ViewableType) {
                    EditPart part = new WorkflowModelTreeEditPartFactory(WorkflowModelBookmarkView.this.editor).createEditPart(null, ((ViewableType)element).getViewable());
                    WorkflowModelBookmarkView.this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)part));
                } else if (element instanceof ViewType) {
                    WorkflowModelBookmarkView.this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(element));
                } else if (element instanceof ModelType) {
                    WorkflowModelBookmarkView.this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)new WorkflowModelTreeEditPartFactory(WorkflowModelBookmarkView.this.editor).createEditPart(null, element)));
                }
                WorkflowModelBookmarkView.this.actions[0].setEnabled(!(element instanceof ModelType) && !(element instanceof ViewableType));
                WorkflowModelBookmarkView.this.actions[1].setEnabled(!(element instanceof ModelType));
                WorkflowModelBookmarkView.this.actions[2].setEnabled(!(element instanceof ViewType));
                WorkflowModelBookmarkView.this.createCtxMenu();
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element instanceof ViewType) {
                    if (WorkflowModelBookmarkView.this.treeViewer.getExpandedState(element)) {
                        WorkflowModelBookmarkView.this.treeViewer.collapseToLevel(element, -1);
                    } else {
                        WorkflowModelBookmarkView.this.treeViewer.expandToLevel(element, -1);
                    }
                } else {
                    new ShowPropertiesAction(WorkflowModelBookmarkView.this.editor, WorkflowModelBookmarkView.this.getSite().getSelectionProvider()).run();
                }
            }
        });
        this.getSite().setSelectionProvider(new ISelectionProvider(){
            private ISelection selection;

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return this.selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
                this.selection = selection;
            }
        });
    }

    private void addDnd() {
        if (!this.isDndInit) {
            this.treeViewer.addDragSupport(1, new Transfer[]{ModelElementTransfer.getInstance()}, (DragSourceListener)new BookmarkDragSourceListener(this.treeViewer));
            this.treeViewer.addDropSupport(1, new Transfer[]{ModelElementTransfer.getInstance()}, (DropTargetListener)new BookmarkDropTargetListener(this.treeViewer, this.editDomain));
            this.isDndInit = true;
        }
    }

    private void createCtxMenu() {
        MenuManager menuManager = new MenuManager();
        int i = 0;
        while (i < this.actions.length) {
            if (this.actions[i].isEnabled()) {
                menuManager.add(this.actions[i]);
            }
            ++i;
        }
        Menu contextMenu = menuManager.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(contextMenu);
    }

    private void createActions() {
        this.actions[0] = new RenameViewAction(this.editDomain, this.treeViewer);
        this.actions[1] = new DeleteViewAction(this.editDomain, this.treeViewer);
        this.actions[2] = new ShowPropertiesAction(this.editor, this.getSite().getSelectionProvider());
        this.actions[3] = new AddViewAction(this.model, this.editDomain, this.treeViewer);
    }

    private WorkflowModelEditor getActiveEditor() {
        IEditorPart editorPart;
        WorkflowModelEditor editor = null;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && (editorPart = page.getActiveEditor()) instanceof WorkflowModelEditor) {
            editor = (WorkflowModelEditor)editorPart;
        }
        return editor;
    }

    public void setFocus() {
    }

    public void updateViewer() {
        this.treeViewer.refresh();
    }

    private void addSelectionListener() {
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (WorkflowModelBookmarkView.this.getActiveEditor() != null) {
                    if (!WorkflowModelBookmarkView.this.getActiveEditor().equals(WorkflowModelBookmarkView.this.editor)) {
                        WorkflowModelBookmarkView.this.tree.setVisible(true);
                        WorkflowModelBookmarkView.this.editor = WorkflowModelBookmarkView.this.getActiveEditor();
                        WorkflowModelBookmarkView.this.initTree();
                        WorkflowModelBookmarkView.this.updateViewer();
                    }
                } else if (WorkflowModelBookmarkView.this.getActiveEditor() == null) {
                    WorkflowModelBookmarkView.this.tree.setVisible(false);
                    WorkflowModelBookmarkView.this.editor = null;
                }
            }
        });
    }
}

