/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.repository;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.views.repository.ResourceInfo;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;

public class ProjectContentProvider
implements ITreeContentProvider {
    private static final String MEMENTO_PROJECT_TYPE = "org.eclipse.stardust.modeling.core.projectInfo";
    private IResourceChangeListener resourceListener;
    private Job runningJob;
    private ResourceInfo root;
    private Map cache = new HashMap();

    public Object[] getChildren(Object parentElement) {
        return ((ResourceInfo)parentElement).getChildren();
    }

    public Object getParent(Object element) {
        return ((ResourceInfo)element).getParent();
    }

    public boolean hasChildren(Object element) {
        return ((ResourceInfo)element).hasChildren();
    }

    public Object[] getElements(Object inputElement) {
        return this.root.getChildren();
    }

    public void dispose() {
        if (this.runningJob != null) {
            this.runningJob.cancel();
        }
        if (this.resourceListener != null) {
            this.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput != newInput) {
            if (oldInput != null && this.resourceListener != null) {
                this.getWorkspace().removeResourceChangeListener(this.resourceListener);
            }
            if (newInput != null) {
                this.getWorkspace().addResourceChangeListener(this.getResourceChangeListener((TreeViewer)viewer));
                this.root = (ResourceInfo)this.cache.get(((IProject)newInput).getName());
                if (this.root == null) {
                    this.root = new ResourceInfo(null, null, ((IProject)newInput).getName(), null, null);
                    this.cache.put(((IProject)newInput).getName(), this.root);
                    this.updateView((TreeViewer)viewer, (IProject)newInput);
                }
            }
        }
    }

    private void updateView(final TreeViewer viewer, final IProject project) {
        if (this.runningJob != null) {
            this.runningJob.cancel();
            this.runningJob = null;
        }
        if (project != null) {
            this.runningJob = new Job(Diagram_Messages.JOB_RepositoryUpdate){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        project.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (resource instanceof IFolder || resource == project) {
                                    return true;
                                }
                                if (resource instanceof IFile) {
                                    ProjectContentProvider.this.addFileResource(viewer, (IFile)resource);
                                }
                                return false;
                            }
                        });
                        ProjectContentProvider.this.runningJob = null;
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return new Status(2, "org.eclipse.stardust.modeling.core", 0, Diagram_Messages.MSG_ErrorUpdateRepository, (Throwable)e);
                    }
                }
            };
            this.runningJob.schedule();
        }
    }

    private void updateViewer(final TreeViewer viewer) {
        new UIJob(Diagram_Messages.JOB_RepositoryUpdate){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                viewer.refresh();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void addFileResource(final TreeViewer viewer, final IFile file) throws CoreException {
        ModelType model;
        if (("cwm".equalsIgnoreCase(file.getFileExtension()) || "xpdl".equalsIgnoreCase(file.getFileExtension())) && (model = this.create(file)) != null) {
            new UIJob(Diagram_Messages.JOB_RepositoryUpdate){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    String version = AttributeUtil.getAttributeValue((IExtensibleElement)model, (String)"carnot:engine:version");
                    ResourceInfo child = new ResourceInfo(file, model.getId(), model.getName(), version, ResourceInfo.getVersionNumbers(version));
                    ProjectContentProvider.this.traverse(child, child.getVersionNumbers(), true);
                    if (!viewer.getControl().isDisposed()) {
                        viewer.refresh();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private ResourceInfo traverse(ResourceInfo child, int[] version, boolean set) {
        int[] parentVersion = null;
        int ix = version.length - 1;
        if (ix > 0) {
            if (version[ix - 1] != 0) {
                parentVersion = new int[version.length - 1];
                System.arraycopy(version, 0, parentVersion, 0, version.length - 1);
            } else {
                int iy = ix - 1;
                while (iy > 0 && version[iy] == 0) {
                    --iy;
                }
                if (version[iy] != 0) {
                    parentVersion = new int[++iy];
                    System.arraycopy(version, 0, parentVersion, 0, iy);
                }
            }
        }
        ResourceInfo parent = null;
        if (parentVersion != null) {
            ResourceInfo savedParent = parent = this.traverse(child, parentVersion, false);
            int i = parent.getVersionNumbers().length;
            while (i <= ix) {
                parent = this.getCreatePseudoParent(savedParent, version, i);
                ++i;
            }
        } else {
            parent = this.root.getPseudoChild(child.getId(), child.getName(), child.getFile(), child.getVersion());
        }
        ResourceInfo info = parent.findChild(version);
        if (info == null) {
            info = set ? child : new ResourceInfo(null, child.getId(), child.getId(), ResourceInfo.toString(version), version);
            parent.add(info);
            int[] previousVersion = new int[version.length];
            System.arraycopy(version, 0, previousVersion, 0, version.length);
            while (previousVersion[ix] > 1) {
                int n = ix;
                previousVersion[n] = previousVersion[n] - 1;
                if (parent.findChild(previousVersion) != null) continue;
                parent.add(new ResourceInfo(null, child.getId(), null, ResourceInfo.toString(previousVersion), previousVersion));
            }
        } else if (set) {
            info.set(child);
        }
        return info;
    }

    private ResourceInfo getCreatePseudoParent(ResourceInfo parent, int[] version, int iy) {
        int[] parentVersion = new int[iy];
        System.arraycopy(version, 0, parentVersion, 0, version[iy - 1] == 0 ? iy - 1 : iy);
        parent = parent.getPseudoChild(parentVersion);
        return parent;
    }

    private ModelType create(IFile file) throws CoreException {
        ModelType model = null;
        WorkflowModelManager modelManager = new WorkflowModelManager();
        if (file.exists()) {
            try {
                modelManager.load(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
            }
            catch (Exception e) {
                throw new PartInitException(Diagram_Messages.MSG_FailedLoadingModel, (Throwable)e);
            }
            model = modelManager.getModel();
            if (model == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.core", 0, Diagram_Messages.MSG_LoadingModelFailed, null));
            }
        }
        return model;
    }

    private IResourceChangeListener getResourceChangeListener(final TreeViewer viewer) {
        if (this.resourceListener == null) {
            this.resourceListener = new IResourceChangeListener(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void resourceChanged(IResourceChangeEvent event) {
                    if (event.getResource() instanceof IProject) {
                        switch (event.getType()) {
                            case 2: 
                            case 4: {
                                System.out.println(String.valueOf(Diagram_Messages.MSG_ClearingProject) + event.getResource());
                                boolean needClear = ProjectContentProvider.this.root == ProjectContentProvider.this.cache.get(event.getResource());
                                ProjectContentProvider.this.cache.remove(event.getResource());
                                if (!needClear) return;
                                ProjectContentProvider.this.updateView(viewer, null);
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    IResourceDelta delta = event.getDelta();
                    try {
                        delta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                IResource resource = delta.getResource();
                                if (resource instanceof IFile) {
                                    ResourceInfo info;
                                    if (delta.getKind() == 1) {
                                        ProjectContentProvider.this.addFileResource(viewer, (IFile)resource);
                                    }
                                    if (delta.getKind() == 2) {
                                        info = new ResourceInfo((IFile)resource, null, null, null, null);
                                        ProjectContentProvider.this.removeDeep(ProjectContentProvider.this.getComparator((StructuredViewer)viewer), ProjectContentProvider.this.root, info);
                                        ProjectContentProvider.this.updateViewer(viewer);
                                    }
                                    if (delta.getKind() == 4) {
                                        info = new ResourceInfo((IFile)resource, null, null, null, null);
                                        ProjectContentProvider.this.removeDeep(ProjectContentProvider.this.getComparator((StructuredViewer)viewer), ProjectContentProvider.this.root, info);
                                        ProjectContentProvider.this.addFileResource(viewer, (IFile)resource);
                                    }
                                }
                                return true;
                            }
                        });
                        return;
                    }
                    catch (CoreException coreException) {}
                }
            };
        }
        return this.resourceListener;
    }

    private boolean removeDeep(Comparator comparator, ResourceInfo parent, ResourceInfo info) {
        boolean result = false;
        ResourceInfo[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            ResourceInfo child = children[i];
            if (child.equals(info)) {
                child.setVirtual();
                result = true;
            } else {
                result = this.removeDeep(comparator, child, info);
            }
            if (result) {
                parent.cleanUp(comparator);
                break;
            }
            ++i;
        }
        return result;
    }

    private Comparator getComparator(final StructuredViewer viewer) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return viewer.getSorter().compare((Viewer)viewer, o1, o2);
            }
        };
    }

    public void saveState(IMemento memento) {
        IWorkspace workspace = this.getWorkspace();
        for (String name : this.cache.keySet()) {
            IProject project = workspace.getRoot().getProject(name);
            if (project == null || !project.isOpen()) continue;
            ResourceInfo info = (ResourceInfo)this.cache.get(name);
            IMemento m = memento.createChild(MEMENTO_PROJECT_TYPE, name);
            info.saveState(m);
            memento.putMemento(m);
        }
    }

    public void loadState(IMemento memento) {
        IMemento[] children;
        if (memento != null && (children = memento.getChildren(MEMENTO_PROJECT_TYPE)) != null) {
            IWorkspace workspace = this.getWorkspace();
            int i = 0;
            while (i < children.length) {
                IMemento child = children[i];
                ResourceInfo info = new ResourceInfo(child);
                IProject project = workspace.getRoot().getProject(child.getID());
                if (project != null && project.isOpen()) {
                    this.cache.put(child.getID(), info);
                }
                ++i;
            }
        }
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public ResourceInfo findResource(IResource resource) {
        return this.root.findResource(resource);
    }

    public ResourceInfo getRoot() {
        return this.root;
    }

    public IProject[] getProjects() {
        return this.getWorkspace().getRoot().getProjects();
    }

    public void clearCaches() {
        this.cache.clear();
    }
}

