/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.views.repository;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.views.repository.ProjectContentProvider;
import org.eclipse.stardust.modeling.core.views.repository.RepositoryActionSet;
import org.eclipse.stardust.modeling.core.views.repository.ResourceInfo;
import org.eclipse.stardust.modeling.core.views.repository.ResourceInfoLabelProvider;
import org.eclipse.stardust.modeling.core.views.repository.ResourceSelectionProvider;
import org.eclipse.stardust.modeling.core.views.repository.SwitchProjectAction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class VersionRepository
extends ViewPart {
    private TreeViewer viewer;
    private ISelectionListener selectionListener;
    ProjectContentProvider contentProvider = new ProjectContentProvider();
    private Menu contextMenu;
    private SwitchProjectAction switchProjectAction;
    private IProject stickyProject;
    private Action refreshAction;

    public void dispose() {
        if (this.selectionListener != null) {
            this.getViewSite().getPage().removeSelectionListener(this.selectionListener);
        }
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
        }
        this.switchProjectAction.dispose();
        super.dispose();
    }

    public void saveState(IMemento memento) {
        this.contentProvider.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.contentProvider.loadState(memento);
    }

    private ISelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                        IProject project = null;
                        IStructuredSelection sel = (IStructuredSelection)selection;
                        Object o = sel.getFirstElement();
                        if (o instanceof IProject) {
                            project = (IProject)o;
                        } else {
                            IResource resource;
                            if (o instanceof IAdaptable && (resource = (IResource)((IAdaptable)o).getAdapter(IResource.class)) != null) {
                                o = resource;
                            }
                            if (o instanceof IResource) {
                                project = ((IResource)o).getProject();
                            } else if (o instanceof IJavaElement) {
                                project = ((IJavaElement)o).getJavaProject().getProject();
                            } else if (o instanceof EditPart && (o = ((EditPart)o).getModel()) instanceof EObject) {
                                project = WorkspaceUtils.getProjectFromEObject((EObject)((EObject)o));
                            }
                        }
                        VersionRepository.this.setProject(project);
                    }
                }
            };
        }
        return this.selectionListener;
    }

    void setProject(IProject project) {
        if (this.stickyProject != null) {
            project = this.stickyProject;
            this.setActionText(project, Diagram_Messages.LB_VersionRepository_StickyProject);
        } else {
            this.setActionText(project, Diagram_Messages.LB_VersionRepository_Project);
        }
        if (project != null && project != this.viewer.getInput()) {
            this.viewer.setInput((Object)project);
        }
    }

    private void setActionText(IProject project, String label) {
        if (this.switchProjectAction != null) {
            if (project == null) {
                this.switchProjectAction.setText(label);
            } else {
                this.switchProjectAction.setText(String.valueOf(label) + project.getName());
            }
            IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
            tbm.update(true);
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Tree tree = new Tree(parent, 2050);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        this.viewer = new TreeViewer(tree);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ResourceInfo r1 = (ResourceInfo)e1;
                ResourceInfo r2 = (ResourceInfo)e2;
                int result = this.getCollator().compare(r1.getId(), r2.getId());
                if (result == 0) {
                    int[] v2;
                    if (r1.getVersionNumbers() == null || r2.getVersionNumbers() == null) {
                        return 1;
                    }
                    int[] v1 = r1.getVersionNumbers();
                    result = v1.length - (v2 = r2.getVersionNumbers()).length;
                    if (result == 0) {
                        int i = 0;
                        while (i < v1.length) {
                            result = v2[i] - v1[i];
                            if (result != 0) break;
                            ++i;
                        }
                    }
                }
                return result;
            }
        });
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourceInfoLabelProvider());
        WorkflowModelEditor editor = this.getActiveEditor();
        if (editor != null) {
            this.setProject(WorkspaceUtils.getProjectFromEObject((EObject)editor.getWorkflowModel()));
        } else {
            IProject[] projects = this.contentProvider.getProjects();
            if (projects != null && projects.length == 1) {
                this.setProject(projects[0]);
            }
        }
        this.getViewSite().getPage().addSelectionListener(this.getSelectionListener());
        this.addActionBars();
        this.refreshAction.run();
    }

    private void addActionBars() {
        final RepositoryActionSet actionSet = new RepositoryActionSet(this, this.viewer);
        MenuManager menuMgr = new MenuManager(Diagram_Messages.MENU_Repository_PopUp);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GEFActionConstants.addStandardActionGroups((IMenuManager)manager);
                actionSet.addActions(manager);
            }
        });
        this.contextMenu = menuMgr.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(this.contextMenu);
        IWorkbenchPartSite site = this.getSite();
        ResourceSelectionProvider provider = new ResourceSelectionProvider(this.viewer);
        actionSet.setSelectionProvider(provider);
        site.registerContextMenu(menuMgr, (ISelectionProvider)provider);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this.refreshAction = new Action(Diagram_Messages.LB_VersionRepository_Refresh){

            public void run() {
                IProject currentProject = (IProject)VersionRepository.this.viewer.getInput();
                VersionRepository.this.viewer.setInput(null);
                VersionRepository.this.contentProvider.clearCaches();
                VersionRepository.this.viewer.setInput((Object)currentProject);
            }
        };
        tbm.add((IAction)this.refreshAction);
        this.switchProjectAction = new SwitchProjectAction(this);
        tbm.add((IAction)this.switchProjectAction);
        this.setActionText((IProject)this.viewer.getInput(), Diagram_Messages.LB_VersionRepository_Project);
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                actionSet.open(event);
            }
        });
    }

    private WorkflowModelEditor getActiveEditor() {
        IEditorPart editorPart;
        WorkflowModelEditor editor = null;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && (editorPart = page.getActiveEditor()) instanceof WorkflowModelEditor) {
            editor = (WorkflowModelEditor)editorPart;
        }
        return editor;
    }

    public void setFocus() {
    }

    public ProjectContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setStickyProject(IProject project) {
        this.stickyProject = project;
        this.setProject(project == null ? (IProject)this.viewer.getInput() : project);
    }
}

