/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.wizards;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.ui.DiagramSelectionDialog;
import org.eclipse.stardust.modeling.core.ui.ModelElementSelectionDialog;
import org.eclipse.stardust.modeling.core.wizards.ExportDiagramResourceWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.WorkbenchImages;

public class ExportCarnotModelDiagramWizardPage
extends ExportDiagramResourceWizardPage {
    private static final String PROC_DEF_LABEL = Diagram_Messages.WIZARD_LB_Process;
    private static final String DIAGRAM_LABEL = Diagram_Messages.WIZARD_LB_Diagram;
    private static final String FILE_LABEL = Diagram_Messages.WIZARD_LB_ToFile;
    private static final String CONTAINER_BROWSE_BUTTON_LABEL = Diagram_Messages.WIZARD_LB_Browse;
    private Text fileNameField;
    private Text procDefNameField;
    private ProcessDefinitionType processDefinition;
    private Text diagramNameField;
    private List diagrams = new ArrayList();
    private Button pngRadioButton;
    private Button jpgRadioButton;
    private Button gifRadioButton;
    private List modelDiagrams = new ArrayList();
    private Text modelDiagramNameField;
    private WorkflowModelEditor editor;

    public ExportCarnotModelDiagramWizardPage(String pageName, IStructuredSelection selection, IEditorPart editorPart) {
        super(pageName, selection);
        this.editor = (WorkflowModelEditor)(editorPart instanceof WorkflowModelEditor ? editorPart : null);
    }

    protected void createDestinationGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        FormBuilder.createLabel((Composite)containerGroup, (String)Diagram_Messages.LB_ModelDiagram);
        this.modelDiagramNameField = FormBuilder.createText((Composite)containerGroup);
        this.modelDiagramNameField.setEditable(false);
        FormBuilder.createButton((Composite)containerGroup, (String)CONTAINER_BROWSE_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.browseModelDiagrams();
            }

            private void browseModelDiagrams() {
                List selectedResources = ExportCarnotModelDiagramWizardPage.this.getSelectedResources();
                if (selectedResources.isEmpty()) {
                    return;
                }
                IFile modelFile = (IFile)selectedResources.get(0);
                DiagramSelectionDialog dialog = new DiagramSelectionDialog(ExportCarnotModelDiagramWizardPage.this.getShell(), modelFile, null, false, ExportCarnotModelDiagramWizardPage.this.editor);
                dialog.setTitle(Diagram_Messages.TITLE_ModelDialog);
                dialog.setMessage(MessageFormat.format(Diagram_Messages.WIZARD_MSG_SelectDiagram, modelFile.toString()));
                if (dialog.open() == 0) {
                    ExportCarnotModelDiagramWizardPage.this.modelDiagrams = new ArrayList<Object>(Arrays.asList(dialog.getResult()));
                    StringBuffer selectedDiagrams = new StringBuffer();
                    int i = 0;
                    Iterator iter = ExportCarnotModelDiagramWizardPage.this.modelDiagrams.iterator();
                    while (iter.hasNext()) {
                        selectedDiagrams.append(String.valueOf(((DiagramType)iter.next()).getName()) + (ExportCarnotModelDiagramWizardPage.this.modelDiagrams.size() != ++i ? ", " : ""));
                    }
                    ExportCarnotModelDiagramWizardPage.this.modelDiagramNameField.setText(selectedDiagrams.toString());
                    ExportCarnotModelDiagramWizardPage.this.updateDestinationField();
                }
            }
        });
        Label label = new Label(containerGroup, 0);
        label.setText(PROC_DEF_LABEL);
        label.setFont(parent.getFont());
        this.procDefNameField = new Text(containerGroup, 2052);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.procDefNameField.setLayoutData((Object)data);
        this.procDefNameField.setFont(parent.getFont());
        this.procDefNameField.setEditable(false);
        this.procDefNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExportCarnotModelDiagramWizardPage.this.setCompletionState();
            }
        });
        Button procDefBrowseButton = new Button(containerGroup, 8);
        procDefBrowseButton.setText(CONTAINER_BROWSE_BUTTON_LABEL);
        procDefBrowseButton.setFont(parent.getFont());
        procDefBrowseButton.setLayoutData((Object)new GridData(256));
        procDefBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ExportCarnotModelDiagramWizardPage.this.browseProcessDefinitions();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ExportCarnotModelDiagramWizardPage.this.browseProcessDefinitions();
            }
        });
        label = new Label(containerGroup, 0);
        label.setText(DIAGRAM_LABEL);
        label.setFont(parent.getFont());
        this.diagramNameField = new Text(containerGroup, 2052);
        data = new GridData(768);
        data.widthHint = 250;
        this.diagramNameField.setLayoutData((Object)data);
        this.diagramNameField.setFont(parent.getFont());
        this.diagramNameField.setEditable(false);
        this.diagramNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExportCarnotModelDiagramWizardPage.this.setCompletionState();
            }
        });
        Button diagramBrowseButton = new Button(containerGroup, 8);
        diagramBrowseButton.setText(CONTAINER_BROWSE_BUTTON_LABEL);
        diagramBrowseButton.setFont(parent.getFont());
        diagramBrowseButton.setLayoutData((Object)new GridData(256));
        diagramBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ExportCarnotModelDiagramWizardPage.this.browseDiagrams();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ExportCarnotModelDiagramWizardPage.this.browseDiagrams();
            }
        });
        label = new Label(containerGroup, 0);
        label.setText(FILE_LABEL);
        label.setFont(parent.getFont());
        this.fileNameField = new Text(containerGroup, 2052);
        data = new GridData(768);
        data.widthHint = 250;
        this.fileNameField.setLayoutData((Object)data);
        this.fileNameField.setFont(parent.getFont());
        this.fileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExportCarnotModelDiagramWizardPage.this.setCompletionState();
            }
        });
        Button containerBrowseButton = new Button(containerGroup, 8);
        containerBrowseButton.setText(CONTAINER_BROWSE_BUTTON_LABEL);
        containerBrowseButton.setFont(parent.getFont());
        containerBrowseButton.setLayoutData((Object)new GridData(256));
        containerBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ExportCarnotModelDiagramWizardPage.this.browseForFile();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ExportCarnotModelDiagramWizardPage.this.browseForFile();
            }
        });
        this.setPageComplete(false);
        this.setTitle(Diagram_Messages.WIZARD_LB_Select);
        this.setDescription(Diagram_Messages.WIZARD_DESCRIPTION_Export);
        this.setControl((Control)containerGroup);
        ImageDescriptor imageDescrip = WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_EXPORT_WIZ");
        this.setImageDescriptor(imageDescrip);
    }

    private void browseForFile() {
        if (this.getDiagram().size() <= 1) {
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            String[] filterExtensions = this.pngRadioButton.getSelection() ? new String[]{"*.png"} : (this.jpgRadioButton.getSelection() ? new String[]{"*.jpg"} : new String[]{"*.gif"});
            dialog.setFilterExtensions(filterExtensions);
            String directory = dialog.open();
            if (directory != null && new File(directory).exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Diagram_Messages.Title_FileExists, (String)Diagram_Messages.MSG_AnotherFileAlreadyExists)) {
                directory = null;
            }
            this.fileNameField.setText(directory != null ? directory : "");
        } else {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            String directory = dialog.open();
            this.fileNameField.setText(directory != null ? directory : "");
        }
    }

    private void browseProcessDefinitions() {
        List selectedResources = this.getSelectedResources();
        if (selectedResources.isEmpty()) {
            return;
        }
        IFile modelFile = (IFile)selectedResources.get(0);
        ModelElementSelectionDialog dialog = new ModelElementSelectionDialog(this.getShell(), modelFile, new Class[]{ProcessDefinitionType.class}, this.editor);
        dialog.setTitle(Diagram_Messages.TITLE_ModelDialog);
        dialog.setMessage(MessageFormat.format(Diagram_Messages.MSG_SelectProcess, modelFile.toString()));
        if (dialog.open() == 0) {
            Object[] modelElements = dialog.getResult();
            this.processDefinition = (ProcessDefinitionType)modelElements[0];
            this.procDefNameField.setText(this.processDefinition.getName());
            this.diagrams = null;
            this.diagramNameField.setText("");
        }
    }

    private void browseDiagrams() {
        List selectedResources = this.getSelectedResources();
        if (selectedResources.isEmpty()) {
            return;
        }
        IFile modelFile = (IFile)selectedResources.get(0);
        DiagramSelectionDialog dialog = new DiagramSelectionDialog(this.getShell(), modelFile, this.processDefinition, true, this.editor);
        dialog.setTitle(Diagram_Messages.TITLE_ModelDialog);
        dialog.setMessage(MessageFormat.format(Diagram_Messages.WIZARD_MSG_SelectDiagram, modelFile.toString()));
        if (dialog.open() == 0) {
            this.diagrams = new ArrayList<Object>(Arrays.asList(dialog.getResult()));
            StringBuffer selectedDiagrams = new StringBuffer();
            int i = 0;
            Iterator iter = this.diagrams.iterator();
            while (iter.hasNext()) {
                selectedDiagrams.append(String.valueOf(((DiagramType)iter.next()).getName()) + (this.diagrams.size() != ++i ? ", " : ""));
            }
            this.diagramNameField.setText(selectedDiagrams.toString());
            this.updateDestinationField();
        }
    }

    private void updateDestinationField() {
        String fileName = this.fileNameField.getText();
        if (!StringUtils.isEmpty((String)fileName)) {
            if (this.diagrams.size() == 1) {
                this.fileNameField.setText(!new File(fileName).isDirectory() ? fileName : this.createFileName((DiagramType)this.diagrams.get(0), fileName).getAbsolutePath());
            }
            if (this.diagrams.size() > 1) {
                this.fileNameField.setText(new File(fileName).isDirectory() ? fileName : new File(fileName).getParent());
            }
        }
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        optionsGroup.setText(Diagram_Messages.WIZARD_LB_FileFormat);
        this.pngRadioButton = new Button((Composite)optionsGroup, 16);
        this.pngRadioButton.setText("PNG");
        this.pngRadioButton.setSelection(true);
        this.pngRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportCarnotModelDiagramWizardPage.this.updateFileExtension("PNG");
            }
        });
        this.jpgRadioButton = new Button((Composite)optionsGroup, 16);
        this.jpgRadioButton.setText("JPEG");
        this.jpgRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportCarnotModelDiagramWizardPage.this.updateFileExtension("JPEG");
            }
        });
        this.gifRadioButton = new Button((Composite)optionsGroup, 16);
        this.gifRadioButton.setText("GIF");
        this.gifRadioButton.setEnabled(false);
        this.gifRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportCarnotModelDiagramWizardPage.this.updateFileExtension("GIF");
            }
        });
    }

    public void handleEvent(Event event) {
    }

    public List getDiagram() {
        ArrayList allDiagrams = new ArrayList();
        if (this.modelDiagrams != null) {
            allDiagrams.addAll(this.modelDiagrams);
        }
        if (this.diagrams != null) {
            allDiagrams.addAll(this.diagrams);
        }
        return allDiagrams;
    }

    public String getFileName() {
        return this.fileNameField.getText();
    }

    public String getImageFormat() {
        if (this.pngRadioButton.getSelection()) {
            return "png";
        }
        if (this.jpgRadioButton.getSelection()) {
            return "jpeg";
        }
        return "gif";
    }

    protected List getTypesToExport() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("cwm");
        return list;
    }

    private void setCompletionState() {
        boolean complete = false;
        if ((this.diagrams != null && this.diagrams.size() > 0 || this.modelDiagrams != null && this.modelDiagrams.size() > 0) && !StringUtils.isEmpty((String)this.fileNameField.getText())) {
            complete = true;
        }
        this.setPageComplete(complete);
    }

    private File createFileName(DiagramType diagram, String baseDir) {
        EObject rawContainer;
        StringBuffer buffer = new StringBuffer();
        if (baseDir != null) {
            buffer.append(baseDir).append(File.separatorChar);
        }
        if ((rawContainer = diagram.eContainer()) instanceof ModelType) {
            ModelType model = (ModelType)rawContainer;
            buffer.append(model.getId()).append("_");
        } else if (rawContainer instanceof ProcessDefinitionType) {
            ProcessDefinitionType process = (ProcessDefinitionType)rawContainer;
            ModelType model = (ModelType)process.eContainer();
            buffer.append(model.getId()).append("_");
            buffer.append(process.getId()).append("_");
        } else {
            return null;
        }
        buffer.append(diagram.getName());
        buffer.append("." + this.getImageFormat());
        return new File(buffer.toString());
    }

    private void updateFileExtension(String extension) {
        String fileName = this.fileNameField.getText();
        if (!(StringUtils.isEmpty((String)fileName) || new File(fileName).isDirectory() || fileName.endsWith(extension))) {
            fileName = String.valueOf(fileName.substring(0, fileName.lastIndexOf(".") + 1)) + extension.toLowerCase();
            this.fileNameField.setText(fileName);
        }
    }

    protected void updateWidgetEnablements() {
        this.modelDiagramNameField.setText("");
        this.procDefNameField.setText("");
        this.diagramNameField.setText("");
        this.fileNameField.setText("");
        if (this.diagrams != null) {
            this.diagrams.clear();
        }
        if (this.modelDiagrams != null) {
            this.modelDiagrams.clear();
        }
    }
}

