/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.annotations;

import org.eclipse.stardust.engine.core.struct.Utils;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GenericElementAdapter {
    private Element adapted;

    public GenericElementAdapter(Element adapted) {
        this.adapted = adapted;
    }

    public GenericElementAdapter getChild(String name, String namespace) {
        NodeList children = this.adapted.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1 && name.equals(Utils.getNodeName((Node)node))) {
                return new GenericElementAdapter((Element)node);
            }
            ++i;
        }
        return null;
    }

    public boolean removeChild(String name, String namespace) {
        NodeList children = this.adapted.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1 && name.equals(Utils.getNodeName((Node)node))) {
                this.adapted.removeChild(node);
                return true;
            }
            ++i;
        }
        return false;
    }

    public GenericElementAdapter createChild(String name, String namespace, String defaultPrefix) {
        Document document = this.adapted.getOwnerDocument();
        String prefix = this.getPrefix(namespace, defaultPrefix);
        String qualifiedName = prefix == null ? name : String.valueOf(prefix) + ':' + name;
        Element child = document.createElementNS(namespace, qualifiedName);
        this.adapted.appendChild(child);
        return new GenericElementAdapter(child);
    }

    public Attr getAttribute(String name) {
        return this.adapted.getAttributeNode(name);
    }

    public Attr createAttribute(String name) {
        Document document = this.adapted.getOwnerDocument();
        Attr attribute = document.createAttribute(name);
        this.adapted.setAttributeNode(attribute);
        return attribute;
    }

    public String getValue() {
        StringBuffer sb = new StringBuffer();
        Node child = this.adapted.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                sb.append(((Text)child).getNodeValue());
            }
            child = child.getNextSibling();
        }
        return sb.length() == 0 ? null : sb.toString().trim();
    }

    public void setValue(String value) {
        Node child = this.adapted.getFirstChild();
        while (child != null && child.getNodeType() != 3) {
            this.adapted.removeChild(child);
            child = child.getNextSibling();
        }
        if (child == null) {
            child = this.adapted.getOwnerDocument().createTextNode(value);
            this.adapted.appendChild(child);
        } else {
            ((Text)child).setNodeValue(value);
            child = child.getNextSibling();
            while (child != null && child.getNodeType() != 3) {
                this.adapted.removeChild(child);
                child = child.getNextSibling();
            }
        }
    }

    public void removeAttribute(String name, String namespace) {
        this.adapted.removeAttributeNS(namespace, name);
    }

    public String getPrefix(String namespace, String defaultPrefix) {
        if (namespace == null) {
            return null;
        }
        Node node = this.adapted;
        while (node != null) {
            if (namespace.equals(node.getNamespaceURI())) {
                return node.getPrefix();
            }
            node = node.getParentNode();
        }
        return defaultPrefix;
    }

    public static XSDAnnotation getAnnotation(XSDFeature element) {
        if (element instanceof XSDElementDeclaration) {
            return ((XSDElementDeclaration)element).getAnnotation();
        }
        if (element instanceof XSDAttributeDeclaration) {
            return ((XSDAttributeDeclaration)element).getAnnotation();
        }
        return null;
    }

    public static void setAnnotation(XSDFeature element, XSDAnnotation annotation) {
        if (element instanceof XSDElementDeclaration) {
            ((XSDElementDeclaration)element).setAnnotation(annotation);
        }
        if (element instanceof XSDAttributeDeclaration) {
            ((XSDAttributeDeclaration)element).setAnnotation(annotation);
        }
    }
}

