/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.common.ui.IWorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.types.ActivityInstanceDigest;
import org.eclipse.stardust.modeling.debug.debugger.types.DataMappingDigest;
import org.eclipse.stardust.modeling.debug.model.CWMDebugTarget;
import org.eclipse.stardust.modeling.debug.model.ManualApplicationDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class UiAccessor {
    public static boolean isModelLoaded(IFile file) {
        IEditorPart p = UiAccessor.getActiveEditPart();
        if (p != null && p instanceof IWorkflowModelEditor) {
            FileEditorInput input = (FileEditorInput)p.getEditorInput();
            IFile currentFile = input.getFile();
            return currentFile.equals((Object)file);
        }
        return false;
    }

    public static WorkflowModelEditor loadModel(IFile file, boolean activate) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ModelLoader loader = new ModelLoader(workbench, file, activate);
        workbench.getDisplay().syncExec((Runnable)loader);
        PartInitException x = loader.getException();
        if (x != null) {
            throw new InternalException(MessageFormat.format(Debug_Messages.EXP_ErrorOccuredWhileLoadingModelFile, file.getName()), (Throwable)x);
        }
        return loader.getEditor();
    }

    public static IViewPart findWorkbenchView(String viewId) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        WorkbenchViewRetriever workbenchViewRetriever = new WorkbenchViewRetriever(workbench, viewId);
        workbench.getDisplay().syncExec((Runnable)workbenchViewRetriever);
        IViewPart view = workbenchViewRetriever.getViewPart();
        return view;
    }

    public static IEditorPart getActiveEditPart() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        EditorPartRetriever editorPartRetriever = new EditorPartRetriever(workbench);
        workbench.getDisplay().syncExec((Runnable)editorPartRetriever);
        IEditorPart p = editorPartRetriever.getEditorPart();
        return p;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ActiveWorkbenchWindowReceiver receiver = new ActiveWorkbenchWindowReceiver(workbench);
        workbench.getDisplay().syncExec((Runnable)receiver);
        return receiver.getWorkbenchWindow();
    }

    public static WorkflowModelEditor activateDiagram(WorkflowModelEditor editor, DiagramType diagram) throws CoreException {
        IEditorPart p;
        if (editor == null && (p = UiAccessor.getActiveEditPart()) instanceof WorkflowModelEditor) {
            editor = (WorkflowModelEditor)p;
        }
        if (editor != null) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            DiagramActivator diagramActivator = new DiagramActivator(workbench, editor, diagram);
            workbench.getDisplay().syncExec((Runnable)diagramActivator);
            CoreException x = diagramActivator.getException();
            if (x != null) {
                throw x;
            }
        }
        return editor;
    }

    public static EditPart findEditPart(WorkflowModelEditor editor, Object model) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        EditPartFinder finder = new EditPartFinder(editor, model);
        workbench.getDisplay().syncExec((Runnable)finder);
        return finder.getEditPart();
    }

    public static boolean openQuestionDialog(String title, String message) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        QuestionDialogExecutor executor = new QuestionDialogExecutor(workbench, title, message);
        workbench.getDisplay().syncExec((Runnable)executor);
        return executor.getResult();
    }

    public static int openManualActivityDialog(ActivityInstanceDigest ai, DataMappingDigest[] dataMappings) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ManualActivityDialogExecutor executor = new ManualActivityDialogExecutor(workbench, ai, dataMappings);
        workbench.getDisplay().syncExec((Runnable)executor);
        return executor.getResult();
    }

    public static void activateDiagramForProcess(CWMDebugTarget target, String processDefinitionId) {
        QName qname = QName.valueOf(processDefinitionId);
        String namespace = qname.getNamespaceURI();
        WorkflowModelEditor editor = UiAccessor.getEditor(target, namespace);
        ModelType model = editor.getWorkflowModel();
        ProcessDefinitionType processDefinition = (ProcessDefinitionType)ModelUtils.findIdentifiableElement((List)model.getProcessDefinition(), (String)qname.getLocalPart());
        if (processDefinition.getDiagram().size() > 0) {
            DiagramType diagram = (DiagramType)processDefinition.getDiagram().get(0);
            try {
                UiAccessor.activateDiagram(editor, diagram);
            }
            catch (CoreException coreException) {}
        }
    }

    private static WorkflowModelEditor getEditor(CWMDebugTarget target, String namespace) {
        IWorkflowModelEditor editor = target.getEditor();
        ModelType model = editor.getWorkflowModel();
        if (!(editor instanceof WorkflowModelEditor && namespace.equals(model.getId()) || (editor = UiAccessor.getEditorForModel(CollectionUtils.newSet(), model, namespace)) != null)) {
            throw new RuntimeException(MessageFormat.format(Debug_Messages.EXP_CannotFindEditorForModelNamespace, namespace));
        }
        return (WorkflowModelEditor)editor;
    }

    public static WorkflowModelEditor getEditorForModel(Set<String> visited, ModelType model, String namespace) {
        String location = WorkspaceUtils.getLocation((ModelType)model);
        if (!visited.contains(location)) {
            visited.add(location);
            ExternalPackages packs = model.getExternalPackages();
            if (packs != null) {
                ModelType externalModel;
                for (ExternalPackage pack : packs.getExternalPackage()) {
                    IFile file;
                    if (!namespace.equals(pack.getHref()) || (externalModel = ModelUtils.getExternalModel((ExternalPackage)pack)) == null) continue;
                    Path path = new Path(WorkspaceUtils.getLocation((ModelType)externalModel));
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IFile iFile = file = path.isAbsolute() ? root.getFileForLocation((IPath)path) : root.getFile((IPath)path);
                    if (!file.exists()) continue;
                    return UiAccessor.loadModel(file, true);
                }
                for (ExternalPackage pack : packs.getExternalPackage()) {
                    WorkflowModelEditor editor;
                    externalModel = ModelUtils.getExternalModel((ExternalPackage)pack);
                    if (externalModel == null || (editor = UiAccessor.getEditorForModel(visited, externalModel, namespace)) == null) continue;
                    return editor;
                }
            }
        }
        return null;
    }

    private static final class ActiveWorkbenchWindowReceiver
    implements Runnable {
        private final IWorkbench workbench;
        private IWorkbenchWindow window;

        private ActiveWorkbenchWindowReceiver(IWorkbench workbench) {
            this.workbench = workbench;
            this.window = null;
        }

        @Override
        public void run() {
            this.window = this.workbench.getActiveWorkbenchWindow();
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            return this.window;
        }
    }

    private static final class DiagramActivator
    implements Runnable {
        private final IWorkbench workbench;
        private final WorkflowModelEditor editor;
        private final DiagramType diagram;
        private CoreException exception;

        private DiagramActivator(IWorkbench workbench, WorkflowModelEditor editor, DiagramType diagram) {
            this.workbench = workbench;
            this.editor = editor;
            this.diagram = diagram;
            this.exception = null;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
            if (window != null && this.editor.equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor())) {
                try {
                    this.editor.showDiagramPage(this.diagram);
                }
                catch (CoreException x) {
                    this.exception = x;
                }
            }
        }

        public CoreException getException() {
            return this.exception;
        }
    }

    private static final class EditPartFinder
    implements Runnable {
        private final WorkflowModelEditor editor;
        private final Object model;
        private EditPart editPart;

        private EditPartFinder(WorkflowModelEditor editor, Object model) {
            this.editor = editor;
            this.model = model;
        }

        @Override
        public void run() {
            this.editPart = this.editor.findEditPart(this.model);
        }

        public EditPart getEditPart() {
            return this.editPart;
        }
    }

    private static final class EditorPartRetriever
    implements Runnable {
        private final IWorkbench workbench;
        private IEditorPart editorPart;

        private EditorPartRetriever(IWorkbench workbench) {
            this.workbench = workbench;
            this.editorPart = null;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
            if (window != null) {
                this.editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
        }

        public IEditorPart getEditorPart() {
            return this.editorPart;
        }
    }

    private static final class ManualActivityDialogExecutor
    implements Runnable {
        private final IWorkbench workbench;
        private final ActivityInstanceDigest ai;
        private final DataMappingDigest[] dataMappings;
        private ManualApplicationDialog dlg;
        private int result;

        private ManualActivityDialogExecutor(IWorkbench workbench, ActivityInstanceDigest ai, DataMappingDigest[] dataMappings) {
            this.workbench = workbench;
            this.ai = ai;
            this.dataMappings = dataMappings;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
            if (window != null) {
                this.dlg = new ManualApplicationDialog(window.getShell(), this.ai, this.dataMappings);
                this.dlg.setBlockOnOpen(true);
                this.result = this.dlg.open();
            }
        }

        public int getResult() {
            return this.result;
        }
    }

    private static final class ModelLoader
    implements Runnable {
        private final IWorkbench workbench;
        private IFile file;
        private boolean activate;
        private PartInitException exception;
        private WorkflowModelEditor editor;

        private ModelLoader(IWorkbench workbench, IFile file, boolean activate) {
            this.workbench = workbench;
            this.file = file;
            this.activate = activate;
        }

        @Override
        public void run() {
            this.editor = null;
            IWorkbenchWindow wbw = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage wbp = wbw.getActivePage();
            try {
                IEditorPart part = IDE.openEditor((IWorkbenchPage)wbp, (IFile)this.file, (boolean)this.activate);
                if (part instanceof WorkflowModelEditor) {
                    this.editor = (WorkflowModelEditor)part;
                }
            }
            catch (PartInitException x) {
                this.exception = x;
            }
        }

        public PartInitException getException() {
            return this.exception;
        }

        public WorkflowModelEditor getEditor() {
            return this.editor;
        }
    }

    private static final class QuestionDialogExecutor
    implements Runnable {
        private final IWorkbench workbench;
        private final String title;
        private final String message;
        private boolean result;

        private QuestionDialogExecutor(IWorkbench workbench, String title, String message) {
            this.workbench = workbench;
            this.title = title;
            this.message = message;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
            if (window != null) {
                this.result = MessageDialog.openQuestion(null, (String)this.title, (String)this.message);
            }
        }

        public boolean getResult() {
            return this.result;
        }
    }

    private static final class WorkbenchViewRetriever
    implements Runnable {
        private final IWorkbench workbench;
        private final String viewId;
        private IViewPart viewPart;

        private WorkbenchViewRetriever(IWorkbench workbench, String viewId) {
            this.workbench = workbench;
            this.viewId = viewId;
            this.viewPart = null;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
            if (window != null) {
                this.viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(this.viewId);
            }
        }

        public IViewPart getViewPart() {
            return this.viewPart;
        }
    }
}

