/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.engine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.common.Action;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.rt.IActionCarrier;
import org.eclipse.stardust.engine.core.runtime.beans.ActionRunner;
import org.eclipse.stardust.engine.core.runtime.beans.ForkingService;
import org.eclipse.stardust.engine.core.runtime.beans.InvocationManager;
import org.eclipse.stardust.engine.core.runtime.beans.interceptors.CallingInterceptor;
import org.eclipse.stardust.engine.core.runtime.beans.interceptors.DebugInterceptor;
import org.eclipse.stardust.engine.core.runtime.beans.interceptors.POJOExceptionHandler;
import org.eclipse.stardust.engine.core.runtime.beans.interceptors.PropertyLayerProviderInterceptor;
import org.eclipse.stardust.modeling.debug.engine.ActivityThreadCarrier;
import org.eclipse.stardust.modeling.debug.engine.DebugForkingInterceptor;
import org.eclipse.stardust.modeling.debug.engine.DebugSessionInterceptor;
import org.eclipse.stardust.modeling.debug.engine.ManagedRunner;

public class DebugForkingService
implements ForkingService {
    private final ActionRunner isolator;

    public DebugForkingService() {
        MyInvocationManager manager = new MyInvocationManager(new MyActionRunner());
        this.isolator = (ActionRunner)Proxy.newProxyInstance(ActionRunner.class.getClassLoader(), new Class[]{ActionRunner.class}, (InvocationHandler)((Object)manager));
    }

    public Object isolate(Action action) {
        return this.isolator.execute(action);
    }

    public void fork(IActionCarrier action, boolean transacted) {
        if (transacted) {
            List successors = (List)Parameters.instance().get("Engine.ForkList");
            successors.add(action);
        } else {
            boolean isActivityThread = action instanceof ActivityThreadCarrier;
            ManagedRunner runnable = new ManagedRunner(action.createAction(), new DebugForkingService(), isActivityThread);
            ThreadGroup group = (ThreadGroup)Parameters.instance().get(isActivityThread ? "ThreadGroup.Infinity Activity Thread" : "ThreadGroup.Infinity Helper Thread");
            new Thread(group, runnable).start();
        }
    }

    private static class MyActionRunner
    implements ActionRunner {
        private MyActionRunner() {
        }

        public Object execute(Action action) {
            return action.execute();
        }
    }

    private static class MyInvocationManager
    extends InvocationManager {
        private static final long serialVersionUID = 1L;

        public MyInvocationManager(Object serviceInstance) {
            super(serviceInstance, MyInvocationManager.setupInterceptors());
        }

        private static List setupInterceptors() {
            ArrayList<Object> interceptors = new ArrayList<Object>();
            interceptors.add(new DebugInterceptor());
            interceptors.add(new PropertyLayerProviderInterceptor());
            interceptors.add(new DebugForkingInterceptor());
            interceptors.add(new DebugSessionInterceptor("AuditTrail"));
            interceptors.add(new POJOExceptionHandler());
            interceptors.add(new CallingInterceptor());
            return interceptors;
        }
    }
}

