/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.stardust.common.config.ParametersFacade;
import org.eclipse.stardust.engine.core.persistence.Session;
import org.eclipse.stardust.engine.core.persistence.jdbc.SessionFactory;
import org.eclipse.stardust.engine.core.runtime.beans.interceptors.ManagedResource;
import org.eclipse.stardust.engine.core.runtime.interceptor.MethodInterceptor;
import org.eclipse.stardust.engine.core.runtime.interceptor.MethodInvocation;

public class DebugSessionInterceptor
implements MethodInterceptor {
    private static final long serialVersionUID = 1L;
    private final String sessionName;

    public DebugSessionInterceptor(String sessionName) {
        this.sessionName = sessionName;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Session session = SessionFactory.getSession((String)this.sessionName);
        ArrayList managedResources = new ArrayList(2);
        HashMap locals = new HashMap();
        locals.put("managed.resources", managedResources);
        ParametersFacade.pushLayer(locals);
        try {
            Object result = invocation.proceed();
            session.save();
            Iterator i = managedResources.iterator();
            while (i.hasNext()) {
                ((ManagedResource)i.next()).commit();
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            session.rollback();
            Iterator i = managedResources.iterator();
            while (i.hasNext()) {
                ((ManagedResource)i.next()).rollback();
            }
            throw e;
        }
        finally {
            ParametersFacade.popLayer();
        }
    }
}

