/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.engine;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.stardust.common.Assert;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.core.persistence.ResultIterator;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;

public class TypeFilterIterator
implements ResultIterator {
    private static final Logger trace = LogManager.getLogger(TypeFilterIterator.class);
    private final Iterator iterator;
    private final Class type;
    private final Predicate predicate;
    private Object nextObject;

    TypeFilterIterator(Iterator iterator, Class type) {
        this.iterator = iterator;
        this.type = type;
        this.predicate = null;
        this.fetch();
    }

    TypeFilterIterator(Iterator iterator, Class type, Predicate predicate) {
        this.iterator = iterator;
        this.type = type;
        this.predicate = predicate;
        trace.debug((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_TypeFilterOnTypeWithPredicate"), type.getName(), predicate));
        this.fetch();
    }

    private void fetch() {
        this.nextObject = null;
        while (this.iterator.hasNext() && this.nextObject == null) {
            this.nextObject = this.iterator.next();
            if (!this.type.isAssignableFrom(this.nextObject.getClass())) {
                this.nextObject = null;
                continue;
            }
            if (this.predicate == null || this.predicate.accept(this.nextObject)) continue;
            this.nextObject = null;
        }
        trace.debug((Object)MessageFormat.format(Internal_Debugger_Messages.getString("MSG_RetrievedObjectIs"), this.nextObject != null ? this.nextObject.getClass().getName() : "null"));
    }

    public boolean hasNext() {
        return this.nextObject != null;
    }

    public Object next() {
        Assert.isNotNull((Object)this.nextObject);
        Object returnObject = this.nextObject;
        this.fetch();
        return returnObject;
    }

    public void remove() {
    }

    public void close() {
    }

    public int getStartIndex() {
        return 0;
    }

    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public boolean hasMore() {
        return false;
    }

    public boolean hasTotalCount() {
        return false;
    }

    public long getTotalCount() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Internal_Debugger_Messages.getString("EXP_DebugModeLimitation"));
    }

    public long getTotalCountThreshold() {
        return Long.MAX_VALUE;
    }
}

