/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.engine;

import org.eclipse.stardust.engine.api.runtime.ProcessInstanceState;
import org.eclipse.stardust.engine.core.runtime.beans.IProcessInstance;
import org.eclipse.stardust.modeling.debug.debugger.Debugger;
import org.eclipse.stardust.modeling.debug.debugger.types.ProcessInstanceDigest;
import org.eclipse.stardust.modeling.debug.engine.ManagedRunnerHelper;

public class WorkflowCompletionWaiter
implements Runnable {
    private Debugger debugger;
    private IProcessInstance processInstance;
    private boolean isSuspended = true;

    public WorkflowCompletionWaiter(Debugger debugger, IProcessInstance processInstance) {
        this.debugger = debugger;
        this.processInstance = processInstance;
    }

    @Override
    public void run() {
        do {
            ManagedRunnerHelper.suspendThread();
            boolean bl = this.isSuspended = this.processInstance.getState() != ProcessInstanceState.Aborted && this.processInstance.getState() != ProcessInstanceState.Completed;
        } while (this.isSuspended);
        WorkflowCompletionRunner runnable = new WorkflowCompletionRunner();
        new Thread(runnable).start();
    }

    private class WorkflowCompletionRunner
    implements Runnable {
        private WorkflowCompletionRunner() {
        }

        @Override
        public void run() {
            ProcessInstanceDigest pi = new ProcessInstanceDigest(WorkflowCompletionWaiter.this.processInstance);
            this.communicateWithSuspendedProcessInstance(pi);
            WorkflowCompletionWaiter.this.debugger.finish();
        }

        private void communicateWithSuspendedProcessInstance(ProcessInstanceDigest processInstance) {
            ManagedRunnerHelper.suspendThread();
        }
    }
}

