/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.highlighting;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.FilteringIterator;
import org.eclipse.stardust.common.Functor;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.TransformingIterator;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.IDiagramChangeListener;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractConnectionSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractModelElementNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.IHighliteableGraphicalObject;
import org.eclipse.stardust.modeling.core.highlighting.HighlightState;
import org.eclipse.stardust.modeling.core.highlighting.HighlightUtils;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.debugger.UiAccessor;
import org.eclipse.stardust.modeling.debug.highlighting.IHighlightable;
import org.eclipse.stardust.modeling.debug.util.EmptyIterator;
import org.eclipse.stardust.modeling.debug.util.WorkflowModelUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public class HighlightManager
implements IPartListener,
IDiagramChangeListener {
    private static HighlightManager highlightManager;
    private Map<IHighlightable, HighlightState> highlightedElements = CollectionUtils.newMap();
    private Map<WorkflowModelEditor, List<DiagramType>> editorDiagrams = CollectionUtils.newMap();
    private IHighlightable currentSelected = null;

    private HighlightManager() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int windowIdx = 0;
        while (windowIdx < windows.length) {
            IWorkbenchPage[] pages = windows[windowIdx].getPages();
            int pageIdx = 0;
            while (pageIdx < pages.length) {
                pages[pageIdx].addPartListener((IPartListener)this);
                IEditorReference[] editorRefs = pages[pageIdx].getEditorReferences();
                int editorIdx = 0;
                while (editorIdx < editorRefs.length) {
                    IEditorPart editor = editorRefs[editorIdx].getEditor(false);
                    if (editor != null && editor instanceof WorkflowModelEditor) {
                        this.addWorkflowModelEditor((WorkflowModelEditor)editor);
                    }
                    ++editorIdx;
                }
                ++pageIdx;
            }
            ++windowIdx;
        }
    }

    private Iterator getEditPartIterator(WorkflowModelEditor editor, DiagramType diagram, IHighlightable highlightable) {
        ModelType model = editor.getWorkflowModel();
        final String processDefinitionId = highlightable.getProcessDefinitionId();
        ProcessDefinitionType processDefinition = null;
        if (processDefinitionId != null) {
            QName qproc = QName.valueOf(processDefinitionId);
            String namespace = qproc.getNamespaceURI();
            if (!namespace.equals(model.getId())) {
                throw new RuntimeException(MessageFormat.format(Debug_Messages.EXP_CannotFindEditorForModelNamespace, namespace));
            }
            processDefinition = WorkflowModelUtils.findProcessDefinition(model, qproc.getLocalPart());
        }
        if (processDefinition == null) {
            return new EmptyIterator();
        }
        final String processDefinitionChildId = highlightable.getProcessDefinitionChildId();
        IIdentifiableModelElement modelElement = null;
        if (processDefinitionChildId != null) {
            QName qchild = QName.valueOf(processDefinitionChildId);
            if (!qchild.getNamespaceURI().equals(model.getId())) {
                throw new RuntimeException(MessageFormat.format(Debug_Messages.EXP_CannotFindEditorForModelNamespace, qchild.getNamespaceURI()));
            }
            String childId = qchild.getLocalPart();
            EList contentList = processDefinition.eContents();
            for (Object rawContent : contentList) {
                if (rawContent instanceof IIdentifiableModelElement && childId.equals((modelElement = (IIdentifiableModelElement)rawContent).getId())) break;
            }
        }
        Iterator<Object> diagramElementIterator = null;
        if (modelElement instanceof ActivityType) {
            diagramElementIterator = WorkflowModelUtils.getActivitySymbols(diagram, (ActivityType)modelElement).iterator();
        } else if (modelElement instanceof TransitionType) {
            diagramElementIterator = WorkflowModelUtils.getTransitionConnections(diagram, (TransitionType)modelElement).iterator();
        } else {
            return new EmptyIterator();
        }
        FilteringIterator iterator = new FilteringIterator(diagramElementIterator, new Predicate(){

            public boolean accept(Object o) {
                if (o instanceof IModelElement) {
                    TransitionConnectionType transConnection;
                    TransitionType transition;
                    IModelElement modelElement = (IModelElement)o;
                    String pdId = "";
                    String childId = "";
                    if (modelElement instanceof ActivitySymbolType) {
                        ActivitySymbolType activitySymbol = (ActivitySymbolType)modelElement;
                        ActivityType activity = activitySymbol.getActivity();
                        ProcessDefinitionType process = (ProcessDefinitionType)activity.eContainer();
                        ModelType model = (ModelType)process.eContainer();
                        childId = String.valueOf('{') + model.getId() + '}' + activity.getId();
                        pdId = String.valueOf('{') + model.getId() + '}' + process.getId();
                    } else if (modelElement instanceof TransitionConnectionType && (transition = (transConnection = (TransitionConnectionType)modelElement).getTransition()) != null) {
                        ProcessDefinitionType process = (ProcessDefinitionType)transition.eContainer();
                        ModelType model = (ModelType)process.eContainer();
                        childId = String.valueOf('{') + model.getId() + '}' + transition.getId();
                        pdId = String.valueOf('{') + model.getId() + '}' + process.getId();
                    }
                    if (childId.equals(processDefinitionChildId) && pdId.equals(processDefinitionId)) {
                        return true;
                    }
                }
                return false;
            }
        });
        final WorkflowModelEditor modelEditor = editor;
        return new TransformingIterator((Iterator)iterator, new Functor(){

            public Object execute(Object source) {
                if (source instanceof IModelElement) {
                    return UiAccessor.findEditPart(modelEditor, source);
                }
                return null;
            }
        });
    }

    public static HighlightManager getDefault() {
        if (highlightManager == null) {
            highlightManager = new HighlightManager();
        }
        return highlightManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighlightState(IHighlightable highlightable, HighlightState state) {
        Map<IHighlightable, HighlightState> map = this.highlightedElements;
        synchronized (map) {
            if (highlightable.equals(this.currentSelected)) {
                this.currentSelected = null;
            }
            this.highlightedElements.put(highlightable, state);
            this.doHighlighting(highlightable, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSelected(IHighlightable highlightable) {
        IEditorPart activeEditor;
        QName qproc;
        String namespace;
        String processId;
        boolean found = false;
        Map<IHighlightable, HighlightState> map = this.highlightedElements;
        synchronized (map) {
            if (this.highlightedElements.containsKey(highlightable)) {
                IHighlightable previous = this.currentSelected;
                this.currentSelected = highlightable;
                if (previous != null) {
                    this.doHighlighting(previous, this.highlightedElements.get(previous));
                }
                if (this.currentSelected != null) {
                    found = this.doHighlighting(this.currentSelected, this.highlightedElements.get(this.currentSelected));
                }
            }
        }
        if (!found && this.currentSelected != null && (processId = highlightable.getProcessDefinitionId()) != null && !StringUtils.isEmpty((String)(namespace = (qproc = QName.valueOf(processId)).getNamespaceURI())) && (activeEditor = UiAccessor.getActiveEditPart()) instanceof WorkflowModelEditor) {
            ModelType model = ((WorkflowModelEditor)activeEditor).getWorkflowModel();
            WorkflowModelEditor editor = UiAccessor.getEditorForModel(CollectionUtils.newSet(), model, namespace);
            if (editor == null) {
                throw new RuntimeException(MessageFormat.format(Debug_Messages.EXP_CannotFindEditorForModelNamespace, namespace));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHighlightable getCurrentSelected() {
        Map<IHighlightable, HighlightState> map = this.highlightedElements;
        synchronized (map) {
            return this.currentSelected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHighlighting(WorkflowModelEditor modelEditor, DiagramType diagram) {
        Map<IHighlightable, HighlightState> map = this.highlightedElements;
        synchronized (map) {
            for (Map.Entry<IHighlightable, HighlightState> entry : this.highlightedElements.entrySet()) {
                IHighlightable highlightable = entry.getKey();
                String processId = highlightable.getProcessDefinitionId();
                if (processId == null) continue;
                QName qproc = QName.valueOf(processId);
                String namespace = qproc.getNamespaceURI();
                ModelType model = modelEditor.getWorkflowModel();
                if (!StringUtils.isEmpty((String)namespace) && !namespace.equals(model.getId())) continue;
                this.doHighlighting(modelEditor, diagram, highlightable, entry.getValue());
            }
        }
    }

    private boolean doHighlighting(IHighlightable highlightable, HighlightState state) {
        boolean found = false;
        String processId = highlightable.getProcessDefinitionId();
        if (processId != null) {
            QName qproc = QName.valueOf(processId);
            String namespace = qproc.getNamespaceURI();
            for (Map.Entry<WorkflowModelEditor, List<DiagramType>> entry : this.editorDiagrams.entrySet()) {
                WorkflowModelEditor editor = entry.getKey();
                ModelType model = editor.getWorkflowModel();
                if (!StringUtils.isEmpty((String)namespace) && !namespace.equals(model.getId())) continue;
                found = true;
                for (DiagramType diagram : entry.getValue()) {
                    this.doHighlighting(editor, diagram, highlightable, state);
                }
            }
        }
        return found;
    }

    private void doHighlighting(WorkflowModelEditor modelEditor, DiagramType diagram, IHighlightable highlightable, HighlightState state) {
        Iterator editPartIter = this.getEditPartIterator(modelEditor, diagram, highlightable);
        while (editPartIter.hasNext()) {
            GatewaySymbol gatewaySymbol;
            FlowControlType flowType;
            TransitionConnectionType transitionConnection;
            Object modelElement;
            Object rawEditPart = editPartIter.next();
            if (!(rawEditPart instanceof IHighliteableGraphicalObject)) continue;
            if (highlightable.equals(this.currentSelected)) {
                HighlightManager.highlightGraphicalObject((IHighliteableGraphicalObject)rawEditPart, HighlightState.SELECTED_LITERAL);
            } else {
                HighlightManager.highlightGraphicalObject((IHighliteableGraphicalObject)rawEditPart, state);
            }
            if (rawEditPart instanceof AbstractModelElementNodeSymbolEditPart) {
                modelElement = ((AbstractModelElementNodeSymbolEditPart)rawEditPart).getModel();
                if (!(modelElement instanceof ActivitySymbolType)) continue;
                ActivitySymbolType activitySymbol = (ActivitySymbolType)modelElement;
                for (GatewaySymbol gatewaySymbol2 : activitySymbol.getGatewaySymbols()) {
                    FlowControlType flowType2 = gatewaySymbol2.getFlowKind();
                    ArrayList connections = new ArrayList();
                    if (flowType2.equals((Object)FlowControlType.JOIN_LITERAL)) {
                        HighlightManager.highlightGraphicalObject((IHighliteableGraphicalObject)UiAccessor.findEditPart(modelEditor, gatewaySymbol2), state);
                        connections.addAll(gatewaySymbol2.getOutTransitions());
                    }
                    if (connections.size() <= 0) continue;
                    int ci = 0;
                    while (ci < connections.size()) {
                        TransitionConnectionType transitionConnection2 = (TransitionConnectionType)connections.get(ci);
                        HighlightManager.highlightGraphicalObject((IHighliteableGraphicalObject)UiAccessor.findEditPart(modelEditor, transitionConnection2), state);
                        ++ci;
                    }
                }
                continue;
            }
            if (!(rawEditPart instanceof AbstractConnectionSymbolEditPart) || !((modelElement = ((AbstractConnectionSymbolEditPart)rawEditPart).getModel()) instanceof TransitionConnectionType) || !((transitionConnection = (TransitionConnectionType)modelElement).getSourceActivitySymbol() instanceof GatewaySymbol) || !(flowType = (gatewaySymbol = (GatewaySymbol)transitionConnection.getSourceActivitySymbol()).getFlowKind()).equals((Object)FlowControlType.SPLIT_LITERAL)) continue;
            if (state.equals(HighlightState.ACTIVE_LITERAL)) {
                HighlightManager.highlightGraphicalObject((IHighliteableGraphicalObject)UiAccessor.findEditPart(modelEditor, gatewaySymbol), HighlightState.DONE_LITERAL);
            } else {
                HighlightManager.highlightGraphicalObject((IHighliteableGraphicalObject)UiAccessor.findEditPart(modelEditor, gatewaySymbol), state);
            }
            EList inTransitions = gatewaySymbol.getInTransitions();
            for (Object entry : inTransitions) {
                if (!(entry instanceof TransitionConnectionType)) continue;
                if (state.equals(HighlightState.ACTIVE_LITERAL)) {
                    HighlightManager.highlightGraphicalObject((IHighliteableGraphicalObject)UiAccessor.findEditPart(modelEditor, (TransitionConnectionType)entry), HighlightState.DONE_LITERAL);
                    continue;
                }
                HighlightManager.highlightGraphicalObject((IHighliteableGraphicalObject)UiAccessor.findEditPart(modelEditor, (TransitionConnectionType)entry), state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlightable(IHighlightable highlightable) {
        Map<IHighlightable, HighlightState> map = this.highlightedElements;
        synchronized (map) {
            if (this.highlightedElements.containsKey(highlightable)) {
                if (highlightable.equals(this.currentSelected)) {
                    this.currentSelected = null;
                }
                this.highlightedElements.remove(highlightable);
                this.doHighlighting(highlightable, HighlightState.DEFAULT_LITERAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllHighlightables() {
        Map<IHighlightable, HighlightState> map = this.highlightedElements;
        synchronized (map) {
            this.currentSelected = null;
            for (IHighlightable highlightable : this.highlightedElements.keySet()) {
                this.doHighlighting(highlightable, HighlightState.DEFAULT_LITERAL);
            }
            this.highlightedElements.clear();
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof WorkflowModelEditor) {
            WorkflowModelEditor modelEditor = (WorkflowModelEditor)part;
            modelEditor.removeDiagramChangeListener((IDiagramChangeListener)this);
            this.editorDiagrams.remove(modelEditor);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof WorkflowModelEditor) {
            this.addWorkflowModelEditor((WorkflowModelEditor)part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diagramPageChanged(DiagramEditorPage page) {
        WorkflowModelEditor editor;
        if (page != null && this.addDiagram(editor = this.getModelEditor(page), page.getDiagram())) {
            Map<IHighlightable, HighlightState> map = this.highlightedElements;
            synchronized (map) {
                this.doHighlighting(editor, page.getDiagram());
            }
        }
    }

    public void diagramPageClosed(DiagramEditorPage page) {
    }

    public void diagramPageOpened(DiagramEditorPage page) {
    }

    private WorkflowModelEditor getModelEditor(DiagramEditorPage page) {
        MultiPageEditorPart editorPart;
        IWorkbenchPartSite site;
        if (page != null && (site = page.getSite()) instanceof MultiPageEditorSite && (editorPart = ((MultiPageEditorSite)site).getMultiPageEditor()) instanceof WorkflowModelEditor) {
            return (WorkflowModelEditor)editorPart;
        }
        return null;
    }

    private boolean addDiagram(WorkflowModelEditor modelEditor, DiagramType diagram) {
        List<DiagramType> diagramList;
        if (this.editorDiagrams.containsKey(modelEditor) && !(diagramList = this.editorDiagrams.get(modelEditor)).contains(diagram)) {
            diagramList.add(diagram);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkflowModelEditor(WorkflowModelEditor modelEditor) {
        modelEditor.addDiagramChangeListener((IDiagramChangeListener)this);
        List diagramList = CollectionUtils.newList();
        diagramList.addAll(modelEditor.getOpenedDiagrams());
        this.editorDiagrams.put(modelEditor, diagramList);
        for (DiagramType diagram : diagramList) {
            Map<IHighlightable, HighlightState> map = this.highlightedElements;
            synchronized (map) {
                this.doHighlighting(modelEditor, diagram);
            }
        }
    }

    private static void highlightGraphicalObject(IHighliteableGraphicalObject object, HighlightState state) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        HighlightUtils.GraphicalObjectHighlighter highlighter = new HighlightUtils.GraphicalObjectHighlighter(object, state);
        workbench.getDisplay().syncExec((Runnable)highlighter);
        RuntimeException x = highlighter.getException();
        if (x != null) {
            x.printStackTrace();
        }
    }
}

