/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.interpreter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.eclipse.stardust.common.NamedValues;
import org.eclipse.stardust.engine.core.compatibility.gui.Entry;
import org.eclipse.stardust.engine.core.compatibility.gui.GUI;
import org.eclipse.stardust.engine.core.compatibility.gui.GenericTable;
import org.eclipse.stardust.engine.core.compatibility.gui.GuiMapper;
import org.eclipse.stardust.engine.core.compatibility.gui.LabeledComponentsPanel;
import org.eclipse.stardust.modeling.debug.interpreter.Data;
import org.eclipse.stardust.modeling.debug.interpreter.DataController;
import org.eclipse.stardust.modeling.debug.interpreter.DataGroup;
import org.eclipse.stardust.modeling.debug.interpreter.Interpreter;
import org.eclipse.stardust.modeling.debug.interpreter.TableData;

public class DefaultInterpreter
extends Interpreter
implements NamedValues {
    private DataController controller = new DataController();

    public DataController getController() {
        return this.controller;
    }

    public void setData(Object object) {
        this.controller.clear();
    }

    public Object get(String name) {
        return this.controller.get(name);
    }

    public void set(String name, Object value) {
        this.controller.set(name, value);
    }

    public JPanel createGroupPanel(DataGroup dataGroup) {
        return (JPanel)this.createGroupComponent(dataGroup, 1);
    }

    @Override
    public JComponent createGroupComponent(DataGroup dataGroup) {
        return this.createGroupComponent(dataGroup, 1);
    }

    private JComponent createGroupComponent(DataGroup dataGroup, int level) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(GUI.getEmptyPanelBorder());
        HashSet<String> writeableData = new HashSet<String>();
        Iterator allData = dataGroup.getAllData();
        while (allData.hasNext()) {
            Data data = (Data)allData.next();
            if (data.getReadonly()) continue;
            writeableData.add(data.getID());
        }
        Iterator iterator = dataGroup.getAllData();
        Box box = Box.createVerticalBox();
        LabeledComponentsPanel components = new LabeledComponentsPanel();
        GenericTable table = null;
        Vector<String> _processedData = new Vector<String>();
        while (iterator.hasNext()) {
            Data data = (Data)iterator.next();
            if (_processedData.contains(data.getID())) continue;
            _processedData.add(data.getID());
            if (data instanceof TableData) {
                table = new GenericTable(Data.class, new String[]{"Label", "Label", "Label"}, new String[]{"Column1", "Column2", "Column3"});
                table.setMaximumSize(new Dimension(table.getMaximumSize().width, 100));
                table.setPreferredSize(new Dimension(100, 100));
                continue;
            }
            JComponent component = GuiMapper.getComponentForClass((Class)data.getType());
            components.add(component, data.getLabel());
            if (!(component instanceof Entry)) continue;
            ((Entry)component).setReadonly(!writeableData.contains(data.getID()));
            ((Entry)component).setMandatory(data.getMandatory());
            this.controller.add((Entry)component, data.getID());
        }
        components.pack();
        components.setMinimumSize(components.getPreferredSize());
        components.setMaximumSize(components.getPreferredSize());
        box.add((Component)components);
        if (table != null) {
            box.add(Box.createVerticalStrut(10));
            box.add((Component)table);
        }
        box.add(Box.createVerticalGlue());
        box.add(Box.createVerticalGlue());
        panel.add(box);
        panel.add(Box.createHorizontalStrut(10));
        iterator = dataGroup.getAllSubGroups();
        if (iterator.hasNext()) {
            JPanel grid = new JPanel();
            grid.setLayout(new GridBagLayout());
            iterator = dataGroup.getAllSubGroups();
            while (iterator.hasNext()) {
                DataGroup subGroup = (DataGroup)iterator.next();
                JPanel subGroupPanel = new JPanel();
                subGroupPanel.add(this.createGroupComponent(subGroup, level + 1));
                subGroupPanel.setBorder(new TitledBorder(new EtchedBorder(), subGroup.getLabel()));
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.fill = 1;
                constraints.weightx = 100.0;
                constraints.weighty = 100.0;
                constraints.gridx = subGroup.getColumn() - 1;
                constraints.gridy = subGroup.getRow() - 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                grid.add((Component)subGroupPanel, constraints);
            }
            grid.setMaximumSize(new Dimension(grid.getPreferredSize().width, grid.getMaximumSize().height));
            panel.add(grid);
        }
        return panel;
    }

    public Map getValues() {
        return this.controller.getValues();
    }
}

