/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.interpreter;

import java.io.Serializable;
import java.util.Hashtable;

public abstract class MetadataPropertyHolder
implements Serializable {
    private Hashtable properties = new Hashtable();

    public String getString(String id) {
        return (String)this.properties.get(id);
    }

    public byte getByte(String id) {
        String string = (String)this.properties.get(id);
        if (string == null) {
            return -128;
        }
        return Byte.parseByte(string);
    }

    public short getShort(String id) {
        String string = (String)this.properties.get(id);
        if (string == null) {
            return Short.MIN_VALUE;
        }
        return Short.parseShort(string);
    }

    public int getInteger(String id) {
        String string = (String)this.properties.get(id);
        if (string == null) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(string);
    }

    public long getLong(String id) {
        String string = (String)this.properties.get(id);
        if (string == null) {
            return Long.MIN_VALUE;
        }
        return Long.parseLong(string);
    }

    public float getFloat(String id) {
        String string = (String)this.properties.get(id);
        if (string == null) {
            return Float.MIN_VALUE;
        }
        return Float.parseFloat(string);
    }

    public double getDouble(String id) {
        String string = (String)this.properties.get(id);
        if (string == null) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(string);
    }

    public boolean getBoolean(String id) {
        String string = (String)this.properties.get(id);
        return string != null && string.compareTo("false") != 0;
    }

    public void setString(String id, String value) {
        this.properties.put(id, value);
    }

    public void setProperties(Hashtable properties) {
        this.properties = properties;
    }
}

