/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.ejb30;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class TypeSelector {
    TypeInfo type;
    private ArrayList<TypeListener> listeners = new ArrayList();

    private TypeSelector(final TypeFinder finder, Composite parent, final String title, final int style) {
        final Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        GridData gd = FormBuilder.createDefaultSingleLineWidgetGridData();
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        composite.setLayoutData((Object)gd);
        this.createText(composite);
        this.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TypeInfo old = TypeSelector.this.type;
                String newType = TypeSelector.this.getText();
                if (finder.getModelElement() != null) {
                    ModelType model = (ModelType)finder.getModelElement().eContainer();
                    newType = VariableContextHelper.getInstance().getContext(model).replaceAllVariablesByDefaultValue(newType);
                }
                if (newType.length() == 0) {
                    TypeSelector.this.type = null;
                    if (old != null) {
                        TypeSelector.this.notifyListeners(old);
                    }
                } else if (old == null || !CompareHelper.areEqual((Object)old.getFullName(), (Object)newType)) {
                    TypeSelector.this.type = finder.findType(newType);
                    TypeSelector.this.notifyListeners(old);
                }
            }
        });
        FormBuilder.createButton((Composite)composite, (String)Diagram_Messages.Btn_Browse, (SelectionListener)new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ApplicationWindow context = new ApplicationWindow(composite.getShell());
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{finder.getJavaProject()});
                try {
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)composite.getShell(), (IRunnableContext)context, (IJavaSearchScope)scope, (int)style, (boolean)false);
                    dialog.setTitle(title);
                    if (dialog.open() == 0) {
                        IType result = (IType)dialog.getResult()[0];
                        TypeInfo old = TypeSelector.this.type;
                        TypeSelector.this.type = new TypeInfo(finder, result, null);
                        TypeSelector.this.setText(TypeSelector.this.type.getFullName());
                        TypeSelector.this.notifyListeners(old);
                    }
                }
                catch (JavaModelException exception) {
                    exception.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    protected void notifyListeners(TypeInfo old) {
        if (!CompareHelper.areEqual((Object)old, (Object)this.type)) {
            for (TypeListener listener : this.listeners) {
                listener.typeChanged(this.type);
            }
        }
    }

    public TypeInfo getType() {
        return this.type;
    }

    public void addListener(TypeListener listener) {
        this.listeners.add(listener);
    }

    protected abstract void setText(String var1);

    protected abstract String getText();

    protected abstract void addModifyListener(ModifyListener var1);

    protected abstract void createText(Composite var1);

    /* synthetic */ TypeSelector(TypeFinder typeFinder, Composite composite, String string, int n, TypeSelector typeSelector) {
        this(typeFinder, composite, string, n);
    }

    public static class ComboSelector
    extends TypeSelector {
        private Combo typeCombo;
        private List<TypeInfo> classes;

        public ComboSelector(TypeFinder finder, Composite parent, String title, int style) {
            super(finder, parent, title, style, null);
        }

        @Override
        protected void addModifyListener(ModifyListener listener) {
            this.typeCombo.addModifyListener(listener);
        }

        @Override
        protected void createText(Composite composite) {
            this.typeCombo = FormBuilder.createCombo((Composite)composite, (int)4, (int)1);
            this.typeCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    int index = ComboSelector.this.typeCombo.getSelectionIndex();
                    ComboSelector.this.type = index < 0 ? null : (TypeInfo)ComboSelector.this.classes.get(index);
                }
            });
        }

        @Override
        protected String getText() {
            return this.typeCombo.getText().trim();
        }

        @Override
        protected void setText(String text) {
            this.typeCombo.setText(text);
        }

        public Combo getComboControl() {
            return this.typeCombo;
        }

        public void setTypesList(List<TypeInfo> classes) {
            this.classes = classes;
            this.typeCombo.removeAll();
            for (TypeInfo typeInfo : classes) {
                this.typeCombo.add(typeInfo.getFullName());
            }
        }
    }

    public static class TextSelector
    extends TypeSelector {
        private Text typeText;

        public TextSelector(TypeFinder finder, Composite parent, String title, int style) {
            super(finder, parent, title, style, null);
        }

        @Override
        protected void addModifyListener(ModifyListener listener) {
            this.typeText.addModifyListener(listener);
        }

        @Override
        protected void createText(Composite composite) {
            this.typeText = FormBuilder.createText((Composite)composite);
        }

        @Override
        protected String getText() {
            return this.typeText.getText().trim();
        }

        @Override
        protected void setText(String text) {
            this.typeText.setText(text);
        }

        public Text getTextControl() {
            return this.typeText;
        }
    }

    public static interface TypeListener {
        public void typeChanged(TypeInfo var1);
    }
}

