/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.spring.application;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.BindingManager;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.integration.spring.SpringModelingPlugin;
import org.eclipse.stardust.modeling.integration.spring.Spring_Messages;
import org.eclipse.stardust.modeling.integration.spring.application.BeanBrowserResourceLoader;
import org.eclipse.stardust.modeling.integration.spring.application.DirectModelAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.EntityResolver;

public class BeanBrowser
extends Dialog {
    private BindingManager bndMgr = new BindingManager();
    private String appContextFile;
    private BeanDefinitionRegistry beanRegistry;
    private ListViewer vwBeans;
    private String beanId;
    private String beanType;

    public BeanBrowser(Shell parentShell) {
        super(parentShell);
    }

    public String getBeanId() {
        return this.beanId;
    }

    public String getBeanType() {
        return this.beanType;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dlgArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)dlgArea.getLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        LabeledText txtAppContextFile = FormBuilder.createLabeledText((Composite)dlgArea, (String)Spring_Messages.LB_AppCtxFile);
        this.bndMgr.bind((IModelAdapter)new DirectModelAdapter(){

            public Object getModel() {
                return BeanBrowser.this.appContextFile;
            }

            public void updateModel(Object value) {
                BeanBrowser.this.appContextFile = (String)value;
            }
        }, BindingManager.createWidgetAdapter((Text)txtAppContextFile.getText()));
        FormBuilder.createButton((Composite)dlgArea, (String)Spring_Messages.LB_Reload, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeanBrowser.this.reloadApplicationContext();
            }
        });
        FormBuilder.createLabel((Composite)dlgArea, (String)Spring_Messages.LB_DecBeans);
        this.vwBeans = new ListViewer(FormBuilder.createList((Composite)dlgArea, (int)2));
        this.vwBeans.setContentProvider((IContentProvider)new ArrayContentProvider());
        ((GridData)this.vwBeans.getControl().getLayoutData()).heightHint = 100;
        String storedPath = SpringModelingPlugin.instance().getPluginPreferences().getString("applicationContextPath");
        if (!StringUtils.isEmpty((String)storedPath)) {
            txtAppContextFile.getText().setText(storedPath);
            this.reloadApplicationContext();
        }
        return dlgArea;
    }

    protected void okPressed() {
        if (this.beanRegistry != null) {
            ISelection selBeanId = this.vwBeans.getSelection();
            if (!selBeanId.isEmpty() && selBeanId instanceof StructuredSelection) {
                this.beanId = (String)((StructuredSelection)selBeanId).getFirstElement();
                BeanDefinition beanDef = this.beanRegistry.getBeanDefinition(this.beanId);
                this.beanType = beanDef instanceof AbstractBeanDefinition ? ((AbstractBeanDefinition)beanDef).getBeanClassName() : null;
            }
        } else {
            this.beanId = null;
            this.beanType = null;
        }
        SpringModelingPlugin.instance().getPluginPreferences().setValue("applicationContextPath", this.appContextFile);
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.beanId = null;
        this.beanType = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Spring_Messages.LB_BrowseBeans);
    }

    private void reloadApplicationContext() {
        IResource appContextResource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.appContextFile);
        if (appContextResource != null && appContextResource.exists() && appContextResource instanceof IFile && appContextResource.getLocation() != null) {
            try {
                String appContextPath = appContextResource.getLocation().toOSString();
                if (!appContextPath.startsWith("/")) {
                    appContextPath = "/" + appContextPath;
                }
                this.beanRegistry = this.loadBeans(appContextPath);
                String[] beanNames = this.beanRegistry.getBeanDefinitionNames();
                this.vwBeans.setInput((Object)beanNames);
            }
            catch (BeansException e) {
                MessageDialog.openError((Shell)this.getParentShell(), (String)Spring_Messages.MSG_FailedLoadingBeanDef, (String)e.getMessage());
            }
        }
    }

    private BeanDefinitionRegistry loadBeans(String appContextPath) {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        beanDefinitionReader.setResourceLoader((ResourceLoader)new BeanBrowserResourceLoader());
        beanDefinitionReader.setEntityResolver((EntityResolver)new ResourceEntityResolver(beanDefinitionReader.getResourceLoader()));
        beanDefinitionReader.setBeanClassLoader(null);
        beanDefinitionReader.loadBeanDefinitions(appContextPath);
        return beanFactory;
    }
}

