/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelexport;

import java.text.ParseException;
import java.util.Date;
import org.eclipse.stardust.common.DateUtils;
import org.eclipse.stardust.modeling.modelexport.Export_Messages;

public class ModelInfo {
    private String name;
    private String id;
    private long oid;
    private Date validFrom;
    private Date validTo;
    private static final String UNSPECIFIED = Export_Messages.STR_Unspecified;
    private boolean active;

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOID(String oid) {
        this.oid = Long.parseLong(oid);
    }

    public void setValidFrom(String validFrom) {
        this.validFrom = this.parseDate(validFrom);
    }

    public void setValidTo(String validTo) {
        this.validTo = this.parseDate(validTo);
    }

    private Date parseDate(String date) {
        try {
            if (!UNSPECIFIED.equals(date)) {
                return DateUtils.getNoninteractiveDateFormat().parse(date);
            }
        }
        catch (ParseException parseException) {}
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getOID() {
        return this.oid;
    }

    public String getValidFromString() {
        return this.format(this.validFrom);
    }

    public String getValidToString() {
        return this.format(this.validTo);
    }

    private String format(Date date) {
        return date == null ? UNSPECIFIED : DateUtils.getNoninteractiveDateFormat().format(date);
    }

    public void setActive() {
        this.active = true;
    }

    public boolean isActive() {
        return this.active;
    }
}

