/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelexport;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.projectnature.BpmProjectNature;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.deploy.DeployUtil;
import org.eclipse.stardust.modeling.modelexport.ExportPlugin;
import org.eclipse.stardust.modeling.modelexport.Export_Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SelectCarnotModelWizardPage
extends WizardExportResourcesPage {
    private static final String CONTAINER_BROWSE_BUTTON_LABEL = Export_Messages.BTN_Browse;
    private ExpandableComposite sctAdvanced;
    private Button chkWithCarnotHome;
    private Text txtCarnotHome;
    private Button btnBrowseCarnotWork;
    private Button chkWithCarnotWork;
    private Text txtCarnotWork;
    private Button btnBrowseCarnotHome;
    private IProject projectContext;
    private ModifyListener txtModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            SelectCarnotModelWizardPage.this.updatePageCompletion();
        }
    };

    public SelectCarnotModelWizardPage(String pageId, IStructuredSelection selection) {
        super(pageId, selection);
        Set projects = CollectionUtils.newSet();
        if (!selection.isEmpty()) {
            for (IResource resource : selection) {
                projects.add(resource.getProject());
            }
            if (1 == projects.size()) {
                this.projectContext = (IProject)projects.iterator().next();
            }
        }
    }

    public boolean deployModel() {
        List resources = this.getSelectedResources();
        return DeployUtil.deployModel((List)resources, (String)this.getCarnotHomeLocation(), (String)this.getCarnotWorkLocation());
    }

    protected void createDestinationGroup(Composite parent) {
        this.sctAdvanced = new ExpandableComposite(parent, 66);
        GridLayout layout = new GridLayout();
        this.sctAdvanced.setLayout((Layout)layout);
        this.sctAdvanced.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        this.sctAdvanced.setText(Export_Messages.LB_ADVANCED);
        Composite containerGroup = FormBuilder.createComposite((Composite)this.sctAdvanced, (int)3);
        this.sctAdvanced.setClient((Control)containerGroup);
        this.chkWithCarnotHome = FormBuilder.createCheckBox((Composite)containerGroup, (String)Export_Messages.BTN_CUSTOM_CARNOT_HOME);
        this.txtCarnotHome = FormBuilder.createText((Composite)containerGroup);
        FormBuilder.applyDefaultTextControlWidth((Control)this.txtCarnotHome);
        this.btnBrowseCarnotHome = FormBuilder.createButton((Composite)containerGroup, (String)CONTAINER_BROWSE_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectCarnotModelWizardPage.this.browseForFile(SelectCarnotModelWizardPage.this.txtCarnotHome);
            }
        });
        this.chkWithCarnotWork = FormBuilder.createCheckBox((Composite)containerGroup, (String)Export_Messages.BTN_CUSTOM_CARNOT_WORKSPACE);
        this.txtCarnotWork = FormBuilder.createText((Composite)containerGroup);
        FormBuilder.applyDefaultTextControlWidth((Control)this.txtCarnotWork);
        this.btnBrowseCarnotWork = FormBuilder.createButton((Composite)containerGroup, (String)CONTAINER_BROWSE_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectCarnotModelWizardPage.this.browseForFile(SelectCarnotModelWizardPage.this.txtCarnotWork);
            }
        });
        this.chkWithCarnotHome.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectCarnotModelWizardPage.this.updateLocationStatus(SelectCarnotModelWizardPage.this.chkWithCarnotHome, SelectCarnotModelWizardPage.this.txtCarnotHome, SelectCarnotModelWizardPage.this.btnBrowseCarnotHome);
            }
        });
        this.chkWithCarnotWork.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectCarnotModelWizardPage.this.updateLocationStatus(SelectCarnotModelWizardPage.this.chkWithCarnotWork, SelectCarnotModelWizardPage.this.txtCarnotWork, SelectCarnotModelWizardPage.this.btnBrowseCarnotWork);
            }
        });
        this.txtCarnotHome.addModifyListener(this.txtModifyListener);
        this.txtCarnotWork.addModifyListener(this.txtModifyListener);
        this.setTitle(Export_Messages.LB_Select);
        this.setDescription(Export_Messages.DESC_DeployModelEnvironment);
        this.setImageDescriptor(ExportPlugin.getImageDescriptor("icons/full/wizbean/export_wiz.zip"));
        this.restoreWidgetValues();
    }

    protected boolean validateSourceGroup() {
        if (super.validateSourceGroup()) {
            return !this.getSelectedResources().isEmpty();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.saveWidgetValues();
        }
    }

    protected void restoreWidgetValues() {
        String carnotHome = null;
        String workspace = null;
        if (this.projectContext != null && this.projectContext.isAccessible()) {
            try {
                carnotHome = this.projectContext.getPersistentProperty(BpmProjectNature.PREFERENCE_CARNOT_HOME);
            }
            catch (CoreException coreException) {}
            try {
                workspace = this.projectContext.getPersistentProperty(BpmProjectNature.PREFERENCE_CARNOT_WORK);
            }
            catch (CoreException coreException) {}
        }
        this.chkWithCarnotHome.setSelection(!StringUtils.isEmpty(carnotHome));
        this.updateLocationStatus(this.chkWithCarnotHome, this.txtCarnotHome, this.btnBrowseCarnotHome);
        if (this.chkWithCarnotHome.getSelection()) {
            this.txtCarnotHome.setText(carnotHome);
        }
        this.chkWithCarnotWork.setSelection(!StringUtils.isEmpty((String)workspace));
        this.updateLocationStatus(this.chkWithCarnotWork, this.txtCarnotWork, this.btnBrowseCarnotWork);
        if (this.chkWithCarnotWork.getSelection()) {
            this.txtCarnotWork.setText(workspace);
        }
        this.sctAdvanced.setExpanded(this.chkWithCarnotHome.getSelection() || this.chkWithCarnotWork.getSelection());
    }

    protected void saveWidgetValues() {
        IProject project;
        List resources = this.getSelectedResources();
        IProject iProject = project = resources.isEmpty() ? null : ((IResource)resources.get(0)).getProject();
        if (project != null && project.isAccessible()) {
            try {
                project.setPersistentProperty(BpmProjectNature.PREFERENCE_CARNOT_HOME, this.getCarnotHomeLocation());
            }
            catch (CoreException coreException) {}
            try {
                project.setPersistentProperty(BpmProjectNature.PREFERENCE_CARNOT_WORK, this.getCarnotWorkLocation());
            }
            catch (CoreException coreException) {}
        }
    }

    protected boolean validateDestinationGroup() {
        String carnotHome = this.getCarnotHomeLocation();
        String carnotWork = this.getCarnotWorkLocation();
        boolean valid = !(this.chkWithCarnotHome.getSelection() && StringUtils.isEmpty((String)carnotHome) || this.chkWithCarnotWork.getSelection() && StringUtils.isEmpty((String)carnotWork));
        return valid;
    }

    protected void updateLocationStatus(Button chkWithLocation, Text txtLocation, Button btnBrowseLocation) {
        if (!chkWithLocation.isDisposed()) {
            txtLocation.setEnabled(chkWithLocation.getSelection());
            btnBrowseLocation.setEnabled(chkWithLocation.getSelection());
            if (!chkWithLocation.getSelection()) {
                txtLocation.setText("");
            }
        }
        this.updatePageCompletion();
    }

    protected void browseForFile(Text txtTarget) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setFilterPath(txtTarget.getText());
        String directory = dialog.open();
        if (directory != null) {
            txtTarget.setText(directory);
        }
    }

    public void handleEvent(Event event) {
    }

    protected List<String> getTypesToExport() {
        List list = CollectionUtils.newList();
        list.add("cwm");
        return list;
    }

    protected void createOptionsGroup(Composite parent) {
    }

    public String getCarnotHomeLocation() {
        return this.txtCarnotHome.getText();
    }

    public String getCarnotWorkLocation() {
        return this.txtCarnotWork.getText();
    }
}

