/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stardust.modeling.modelimport.IImportModelWizardPage;
import org.eclipse.stardust.modeling.modelimport.ImportModelWizardPage;
import org.eclipse.stardust.modeling.modelimport.ImportPlugin;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class ImportModelWizard
extends Wizard
implements IImportWizard {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    private ImportModelWizardPage importModelWizardPage;

    public ImportModelWizard() {
        this.setWindowTitle(Import_Messages.DESC_ImportFile);
        String WIZARD_NAME = Import_Messages.NAME_ImportCarnotProcessModelWiz;
        ImportPlugin plugin = ImportPlugin.getDefault();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(WIZARD_NAME);
        if (section == null) {
            section = workbenchSettings.addNewSection(WIZARD_NAME);
        }
        this.setDialogSettings(section);
    }

    public boolean performFinish() {
        return ((IImportModelWizardPage)this.getContainer().getCurrentPage()).performFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
    }

    public void addPages() {
        this.importModelWizardPage = new ImportModelWizardPage(Import_Messages.NAME_CarnotWorkflowImportPage, this.selection);
        this.addPage((IWizardPage)this.importModelWizardPage);
    }

    public ImportModelWizardPage getModelImportPage() {
        return this.importModelWizardPage;
    }

    public void openEditor(IProgressMonitor monitor, final IFile file, final boolean reopen) {
        monitor.setTaskName(Import_Messages.TASK_OpenFile);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart part = page.findEditor((IEditorInput)new FileEditorInput(file));
                    if (part != null && reopen) {
                        page.closeEditor(part, true);
                    }
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(2);
    }
}

