/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.common.projectnature.BpmProjectNature;
import org.eclipse.stardust.modeling.common.projectnature.classpath.BpmClasspathUtils;
import org.eclipse.stardust.modeling.modelimport.IImportModelWizardPage;
import org.eclipse.stardust.modeling.modelimport.ISourceGroupProvider;
import org.eclipse.stardust.modeling.modelimport.ImportModelWizard;
import org.eclipse.stardust.modeling.modelimport.ImportPlugin;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.internal.WorkbenchImages;

public class ImportModelWizardPage
extends WizardResourceImportPage
implements IImportModelWizardPage {
    private ISourceGroupProvider sourceGroupProvider;
    private Combo modelTypsCombo;
    private Map sourceGroupControls;
    private Map additionalOptionsControls;
    private Map advancedExpandableControls;
    private StackLayout sourceGroupLayout;
    private StackLayout additionOptionsGroupLayout;
    private StackLayout advancedExpandableGroupLayout;
    protected CarnotWorkflowModelPackage carnotWorkflowModelPackage = CarnotWorkflowModelPackage.eINSTANCE;
    protected CarnotWorkflowModelFactory carnotWorkflowModelFactory = this.carnotWorkflowModelPackage.getCarnotWorkflowModelFactory();
    private IProject projectContext;

    public ImportModelWizardPage(String pageId, IStructuredSelection selection) {
        super(pageId, selection);
        IWorkspaceRoot root;
        IProject[] projects;
        if (!selection.isEmpty()) {
            HashSet<IProject> projects2 = new HashSet<IProject>();
            for (Object obj : selection) {
                if (!(obj instanceof IResource)) continue;
                IResource resource = (IResource)obj;
                projects2.add(resource.getProject());
            }
            if (1 == projects2.size()) {
                this.projectContext = (IProject)projects2.iterator().next();
            }
        }
        if (this.projectContext == null && (projects = (root = ResourcesPlugin.getWorkspace().getRoot()).getProjects()).length == 0) {
            this.projectContext = this.createNewProject(root);
        }
        if (this.projectContext != null) {
            this.setContainerFieldValue(this.projectContext.getName());
        }
    }

    private IProject createNewProject(IWorkspaceRoot root) {
        IProject project = root.getProject("carnot-bpm");
        try {
            project.create(null);
            project.open(null);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IProjectDescription description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            project.setDescription(description, null);
            javaProject.setRawClasspath(new IClasspathEntry[]{JavaRuntime.getDefaultJREContainerEntry()}, null);
            BpmProjectNature.enableBpmNature((IProject)project);
            BpmClasspathUtils.addBpmCoreLibsContainer((IProject)project);
        }
        catch (CoreException coreException) {}
        return project;
    }

    @Override
    public void updateButtons() {
        this.getWizard().getContainer().updateButtons();
    }

    @Override
    public IDialogSettings getWizardSettings() {
        return this.getDialogSettings();
    }

    @Override
    public IProject getProjectContext() {
        return this.projectContext;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.createAdvancedExpandedComposite(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    protected void createSourceGroup(Composite parent) {
        this.sourceGroupControls = new HashMap();
        Composite sgContainer = new Composite(parent, 0);
        GridData data = new GridData(0);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        sgContainer.setLayoutData((Object)data);
        this.sourceGroupLayout = new StackLayout();
        sgContainer.setLayout((Layout)this.sourceGroupLayout);
        for (String key : ImportPlugin.getSourceGroupProviders().keySet()) {
            ISourceGroupProvider provider = (ISourceGroupProvider)ImportPlugin.getSourceGroupProviders().get(key);
            Control control = provider.createSourceGroup(sgContainer, this);
            this.sourceGroupControls.put(key, control);
        }
        this.setPageComplete(false);
        this.setTitle(Import_Messages.LB_Select);
        this.setDescription(Import_Messages.DESC_ImportFile);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_IMPORT_WIZ"));
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.createModelTypeOptions((Composite)optionsGroup);
        Composite aogContainer = new Composite((Composite)optionsGroup, 0);
        GridData data = new GridData(0);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        aogContainer.setLayoutData((Object)data);
        this.additionOptionsGroupLayout = new StackLayout();
        aogContainer.setLayout((Layout)this.additionOptionsGroupLayout);
        this.additionalOptionsControls = new HashMap();
        for (String key : ImportPlugin.getSourceGroupProviders().keySet()) {
            ISourceGroupProvider provider = (ISourceGroupProvider)ImportPlugin.getSourceGroupProviders().get(key);
            Control control = provider.createAdditionalOptionsGroup(aogContainer, true);
            this.additionalOptionsControls.put(key, control);
        }
    }

    private void createAdvancedExpandedComposite(Composite parent) {
        Composite advancedComp = new Composite(parent, 0);
        GridData data = new GridData(0);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        advancedComp.setLayoutData((Object)data);
        this.advancedExpandableGroupLayout = new StackLayout();
        this.advancedExpandableGroupLayout.marginHeight = 5;
        advancedComp.setLayout((Layout)this.advancedExpandableGroupLayout);
        this.advancedExpandableControls = new HashMap();
        for (String key : ImportPlugin.getSourceGroupProviders().keySet()) {
            ISourceGroupProvider provider = (ISourceGroupProvider)ImportPlugin.getSourceGroupProviders().get(key);
            Control control = provider.createAdvancedExpandableControl(advancedComp, this);
            if (control == null) continue;
            this.advancedExpandableControls.put(key, control);
        }
        this.onModelTypeSelection();
    }

    private void createModelTypeOptions(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label modelTypsComboLabel = new Label(composite, 0);
        modelTypsComboLabel.setText(Import_Messages.LB_Types);
        this.modelTypsCombo = new Combo(composite, 8);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                this.widgetDefaultSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ImportModelWizardPage.this.onModelTypeSelection();
            }
        };
        this.modelTypsCombo.addSelectionListener(listener);
        IConfigurationElement firstConfig = (IConfigurationElement)ImportPlugin.getExtensions().get("File");
        this.modelTypsCombo.add(firstConfig.getAttribute("name"));
        for (String extension : ImportPlugin.getExtensions().keySet()) {
            IConfigurationElement config = (IConfigurationElement)ImportPlugin.getExtensions().get(extension);
            if (config.equals((Object)firstConfig)) continue;
            this.modelTypsCombo.add(config.getAttribute("name"));
        }
        this.modelTypsCombo.select(0);
    }

    protected ITreeContentProvider getFileProvider() {
        return null;
    }

    protected ITreeContentProvider getFolderProvider() {
        return null;
    }

    protected void updateWidgetEnablements() {
        this.setMessage(null, 2);
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
        if (this.getMessage() == null && pageComplete) {
            this.validateSelectedModelId();
        }
    }

    private void validateSelectedModelId() {
        if (this.sourceGroupProvider != null) {
            if (this.checkFileExists()) {
                this.setMessage(Import_Messages.ImportModelWizardPage_WarningIdAlreadyExists, 2);
            } else {
                this.setMessage(null, 2);
            }
        }
    }

    public boolean checkFileExists() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath location = root.getLocation();
        IPath resourcePath = this.sourceGroupProvider.getResourcePath(this.getContainerFullPath());
        if (resourcePath == null) {
            return false;
        }
        String path = String.valueOf(location.toString()) + resourcePath.toString();
        File targetFile = new File(path);
        return targetFile.exists();
    }

    @Override
    public boolean performFinish() {
        final boolean[] result = new boolean[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        IPath resourcePath = ImportModelWizardPage.this.sourceGroupProvider.getResourcePath(ImportModelWizardPage.this.getContainerFullPath());
                        if (resourcePath != null) {
                            WorkflowModelManager wspModelManager = new WorkflowModelManager();
                            URI uri = URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)false);
                            ModelType model = wspModelManager.createModel(uri);
                            Resource wspResource = model.eResource();
                            Resource extResource = ImportModelWizardPage.this.sourceGroupProvider.getExternalResource();
                            if (extResource != null) {
                                Map options = CollectionUtils.newMap();
                                options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                                extResource.load(options);
                                wspResource.getContents().clear();
                                wspResource.getContents().addAll((Collection)extResource.getContents());
                                wspModelManager.save(wspResource.getURI());
                                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                                IFile file = (IFile)root.findMember(resourcePath);
                                ((ImportModelWizard)ImportModelWizardPage.this.getWizard()).openEditor(monitor, file, false);
                                result[0] = true;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Import_Messages.MSG_Err, (String)realException.getMessage());
        }
        return result[0];
    }

    public boolean determinePageCompletion() {
        boolean pageComplete = super.determinePageCompletion();
        if (this.sourceGroupProvider == null || !this.sourceGroupProvider.isComplete()) {
            pageComplete = false;
        }
        if (this.getResourcePath() == null || this.getResourcePath().isEmpty()) {
            pageComplete = false;
        }
        if (!this.validateDestinationGroup()) {
            pageComplete = false;
        }
        return pageComplete;
    }

    private void onModelTypeSelection() {
        this.onModelTypeSelection(this.modelTypsCombo.getText());
        this.updateButtons();
    }

    private void onModelTypeSelection(String selectionIds) {
        for (String key : this.sourceGroupControls.keySet()) {
            Control sourceGroupControl = (Control)this.sourceGroupControls.get(key);
            Control additionalOptionsControl = (Control)this.additionalOptionsControls.get(key);
            Control advancedExpandableControl = (Control)this.advancedExpandableControls.get(key);
            if (key.equals(selectionIds)) {
                sourceGroupControl.setVisible(true);
                this.sourceGroupProvider = (ISourceGroupProvider)ImportPlugin.getSourceGroupProviders().get(key);
                this.sourceGroupLayout.topControl = sourceGroupControl;
                additionalOptionsControl.setVisible(true);
                this.additionOptionsGroupLayout.topControl = additionalOptionsControl;
                if (advancedExpandableControl == null) continue;
                advancedExpandableControl.setVisible(true);
                this.advancedExpandableGroupLayout.topControl = advancedExpandableControl;
                continue;
            }
            sourceGroupControl.setVisible(false);
            additionalOptionsControl.setVisible(false);
            if (advancedExpandableControl == null) continue;
            advancedExpandableControl.setVisible(false);
        }
    }

    public ISourceGroupProvider getSourceGroupProvider() {
        return this.sourceGroupProvider;
    }
}

