/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.carnot;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stardust.model.xpdl.carnot.util.CarnotWorkflowModelResourceFactoryImpl;
import org.eclipse.stardust.modeling.modelimport.IImportModelWizardPage;
import org.eclipse.stardust.modeling.modelimport.ISourceGroupProvider;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.stardust.modeling.modelimport.ThirdPartySourceGroupProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardResourceImportPage;

public class CarnotXmlSourceGroupProvider
extends ThirdPartySourceGroupProvider
implements ISourceGroupProvider,
IExecutableExtension {
    private static final int SIZING_BUTTON_WIDTH = 75;
    private static final int SIZING_TEXT_LABEL_WIDTH = 55;
    private static final String XML_SOURCE_FILE_LABEL = Import_Messages.LB_FromXML;
    private static final String CONTAINER_BROWSE_BUTTON_LABEL = Import_Messages.BTN_Browse;
    private IImportModelWizardPage wizardPage;
    private Text fileNameField;
    private Composite parent;
    private boolean complete;

    @Override
    public Control createAdditionalOptionsGroup(Composite optionsGroup, boolean enabled) {
        Control control = super.createAdditionalOptionsGroup(optionsGroup, false);
        control.setEnabled(false);
        return control;
    }

    @Override
    public Control createSourceGroup(Composite parent, IImportModelWizardPage wizardPage) {
        this.parent = parent;
        this.wizardPage = wizardPage;
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        containerGroup.setLayoutData((Object)gridData);
        containerGroup.setFont(parent.getFont());
        Label label = new Label(containerGroup, 0);
        label.setText(XML_SOURCE_FILE_LABEL);
        label.setFont(parent.getFont());
        GridData data = new GridData();
        data.widthHint = 55;
        label.setLayoutData((Object)data);
        this.fileNameField = new Text(containerGroup, 2052);
        this.fileNameField.setLayoutData((Object)new GridData(768));
        this.fileNameField.setFont(parent.getFont());
        this.fileNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                CarnotXmlSourceGroupProvider.this.setComplete(CarnotXmlSourceGroupProvider.this.fileNameField.getText().trim().length() > 0);
            }
        });
        Button containerBrowseButton = new Button(containerGroup, 8);
        containerBrowseButton.setText(CONTAINER_BROWSE_BUTTON_LABEL);
        containerBrowseButton.setFont(parent.getFont());
        GridData data2 = new GridData(256);
        data2.widthHint = 75;
        containerBrowseButton.setLayoutData((Object)data2);
        containerBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CarnotXmlSourceGroupProvider.this.browseForFile();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                CarnotXmlSourceGroupProvider.this.browseForFile();
            }
        });
        return containerGroup;
    }

    protected void browseForFile() {
        FileDialog dialog = new FileDialog(this.parent.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.xpdl", "*.xml", "*.*"});
        dialog.setFilterNames(new String[]{Import_Messages.STR_XpdlFiles, Import_Messages.STR_XmlFiles, Import_Messages.STR_AnyFile});
        String filename = dialog.open();
        if (filename != null) {
            this.fileNameField.setText(filename);
        }
    }

    @Override
    public Resource getExternalResource() {
        Path sPath = new Path(this.fileNameField.getText());
        String lastSegment = sPath.lastSegment();
        if (lastSegment == null) {
            return null;
        }
        Resource resource = new CarnotWorkflowModelResourceFactoryImpl().createResource(URI.createFileURI((String)sPath.toString()));
        return resource;
    }

    @Override
    public IPath getResourcePath(IPath containerFullPath) {
        Path sPath = new Path(this.fileNameField.getText());
        String lastSegment = sPath.lastSegment();
        if (lastSegment == null) {
            return null;
        }
        StringBuffer modelName = new StringBuffer();
        int ix = lastSegment.lastIndexOf(46);
        modelName.append(ix < 0 ? lastSegment : lastSegment.substring(0, ix));
        modelName.append(".").append("xpdl");
        return containerFullPath.append(modelName.toString());
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
        if (this.wizardPage instanceof WizardResourceImportPage) {
            Event event = new Event();
            event.type = 24;
            ((WizardResourceImportPage)this.wizardPage).handleEvent(event);
        }
        this.wizardPage.updateButtons();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    @Override
    public Control createAdvancedExpandableControl(Composite parent, IImportModelWizardPage page) {
        return null;
    }
}

