/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.carnot.audittrail;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stardust.common.Base64;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.CarnotWorkflowModelResourceFactoryImpl;
import org.eclipse.stardust.modeling.common.projectnature.BpmProjectNature;
import org.eclipse.stardust.modeling.common.projectnature.classpath.BpmCoreLibrariesClasspathContainer;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.modelimport.IImportModelWizardPage;
import org.eclipse.stardust.modeling.modelimport.ISourceGroupProvider;
import org.eclipse.stardust.modeling.modelimport.ImportModelWizardPage;
import org.eclipse.stardust.modeling.modelimport.Import_Messages;
import org.eclipse.stardust.modeling.modelimport.ThirdPartySourceGroupProvider;
import org.eclipse.stardust.modeling.modelimport.carnot.audittrail.ModelImportTool;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class CarnotAuditTrailSourceGroupProvider
extends ThirdPartySourceGroupProvider
implements ISourceGroupProvider,
IExecutableExtension {
    public static final String ATTR_CARNOT_HOME = "org.eclipse.stardust.modeling.modelimport.deployment.CARNOT_HOME";
    public static final String ATTR_CARNOT_WORK = "org.eclipse.stardust.modeling.modelimport.deployment.CARNOT_WORK";
    public static final String ATTR_CARNOT_USER = "org.eclipse.stardust.modeling.modelimport.deployment.User";
    private static final String CONTAINER_BROWSE_BUTTON_LABEL = Import_Messages.BTN_Browse;
    private IImportModelWizardPage wizardPage;
    private Button chkWithCarnotHome;
    private Text txtCarnotHome;
    private Button btnBrowseCarnotWork;
    private Button chkWithCarnotWork;
    private Text txtCarnotWork;
    private Button btnBrowseCarnotHome;
    private LabeledText txtTargetFileName;
    private Composite parent;
    private boolean complete;
    private ModifyListener txtModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            CarnotAuditTrailSourceGroupProvider.this.complete = CarnotAuditTrailSourceGroupProvider.this.wizardPage instanceof ImportModelWizardPage ? !StringUtils.isEmpty((String)CarnotAuditTrailSourceGroupProvider.this.txtTargetFileName.getText().getText()) : true;
            ((WizardPage)CarnotAuditTrailSourceGroupProvider.this.wizardPage).setPageComplete(CarnotAuditTrailSourceGroupProvider.this.complete);
        }
    };
    private ExpandableComposite expComp;

    public String getTargetFileName() {
        return this.txtTargetFileName.getText().getText();
    }

    @Override
    public Control createAdditionalOptionsGroup(Composite optionsGroup, boolean enabled) {
        Control control = super.createAdditionalOptionsGroup(optionsGroup, false);
        control.setEnabled(false);
        return control;
    }

    @Override
    public Control createSourceGroup(Composite composite, IImportModelWizardPage wizardPage) {
        this.parent = composite;
        this.wizardPage = wizardPage;
        Composite containerGroup = FormBuilder.createComposite((Composite)composite, (int)3);
        if (wizardPage instanceof ImportModelWizardPage) {
            this.txtTargetFileName = FormBuilder.createLabeledText((Composite)containerGroup, (String)Import_Messages.LB_TargetFile);
            ((GridData)this.txtTargetFileName.getText().getLayoutData()).horizontalSpan = 2;
            this.txtTargetFileName.getText().addModifyListener(this.txtModifyListener);
        }
        return containerGroup;
    }

    protected void browseForFile(Text txtTarget) {
        DirectoryDialog dialog = new DirectoryDialog(this.parent.getShell(), 4096);
        dialog.setFilterPath(txtTarget.getText());
        String directory = dialog.open();
        if (directory != null) {
            txtTarget.setText(directory);
        }
    }

    protected void updateLocationStatus(Button chkWithLocation, Text txtLocation, Button btnBrowseLocation) {
        if (!chkWithLocation.isDisposed()) {
            txtLocation.setEnabled(chkWithLocation.getSelection());
            btnBrowseLocation.setEnabled(chkWithLocation.getSelection());
            if (!chkWithLocation.getSelection()) {
                txtLocation.setText("");
            }
        }
        this.setComplete(true);
    }

    @Override
    public Resource getExternalResource() {
        Resource result = null;
        File sourceFile = this.importModel();
        if (sourceFile != null) {
            Path sPath = new Path(sourceFile.getAbsolutePath());
            result = new CarnotWorkflowModelResourceFactoryImpl().createResource(URI.createFileURI((String)sPath.toString()));
        }
        return result;
    }

    @Override
    public IPath getResourcePath(IPath containerFullPath) {
        StringBuffer modelName = new StringBuffer();
        modelName.append(this.getTargetFileName());
        if (!modelName.toString().endsWith("xpdl")) {
            if (!modelName.toString().endsWith(".")) {
                modelName.append(".");
            }
            modelName.append("xpdl");
        }
        return containerFullPath.append(modelName.toString());
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        boolean bl = this.complete = complete && (this.txtTargetFileName == null || !StringUtils.isEmpty((String)this.getTargetFileName()));
        if (this.parent.isVisible()) {
            this.wizardPage.updateButtons();
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public String getCarnotHomeLocation() {
        return this.txtCarnotHome.getText();
    }

    public String getCarnotWorkLocation() {
        return this.txtCarnotWork.getText();
    }

    public File importModel() {
        File targetFile;
        try {
            targetFile = File.createTempFile("carnot-model", ".xml");
            targetFile.deleteOnExit();
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            ILaunchConfigurationWorkingCopy wc = type.newInstance(null, "Infinity AuditTrail Process Model Import");
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.wizardPage.getProjectContext().getName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.stardust.modeling.common.projectnature.carnotToolClasspathProvider");
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, ModelImportTool.class.getName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "--filename64 " + new String(Base64.encode((byte[])targetFile.getAbsolutePath().getBytes())));
            wc.setAttribute("CARNOT_HOME", this.getCarnotHomeLocation());
            wc.setAttribute("CARNOT_WORK", this.getCarnotWorkLocation());
            wc.setAttribute("CARNOT_EXTRA_LOCATION", BpmCoreLibrariesClasspathContainer.getLibraryLocation((String)"org.eclipse.stardust.modeling.modelimport", (String[])new String[]{"bin", ""}).toString());
            ILaunchConfiguration config = wc.doSave();
            ILaunch toolLaunch = config.launch("run", null);
            boolean started = toolLaunch.getProcesses().length > 0;
            config.delete();
            wc.delete();
            while (started && !toolLaunch.isTerminated()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (started) {
                this.saveWidgetValues();
                IProcess[] tools = toolLaunch.getProcesses();
                int i = 0;
                while (i < tools.length) {
                    if (1 != tools[i].getExitValue()) {
                        targetFile = null;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            targetFile = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            targetFile = null;
        }
        return targetFile;
    }

    protected void restoreWidgetValues() {
        String carnotHome = null;
        String workspace = null;
        IProject project = this.wizardPage.getProjectContext();
        if (project != null && project.exists() && project.isOpen()) {
            try {
                carnotHome = project.getPersistentProperty(BpmProjectNature.PREFERENCE_CARNOT_HOME);
                workspace = project.getPersistentProperty(BpmProjectNature.PREFERENCE_CARNOT_WORK);
            }
            catch (CoreException coreException) {}
        }
        this.chkWithCarnotHome.setSelection(!StringUtils.isEmpty(carnotHome));
        this.updateLocationStatus(this.chkWithCarnotHome, this.txtCarnotHome, this.btnBrowseCarnotHome);
        if (this.chkWithCarnotHome.getSelection()) {
            this.txtCarnotHome.setText(carnotHome);
        }
        this.chkWithCarnotWork.setSelection(!StringUtils.isEmpty((String)workspace));
        this.updateLocationStatus(this.chkWithCarnotWork, this.txtCarnotWork, this.btnBrowseCarnotWork);
        if (this.chkWithCarnotWork.getSelection()) {
            this.txtCarnotWork.setText(workspace);
        }
        this.expComp.setExpanded(this.chkWithCarnotHome.getSelection() || this.chkWithCarnotWork.getSelection());
    }

    protected void saveWidgetValues() {
        IProject project;
        IProject iProject = project = this.wizardPage.getProjectContext() != null ? this.wizardPage.getProjectContext() : null;
        if (project != null && project.exists() && project.isOpen() && project.isLocal(0)) {
            try {
                project.setPersistentProperty(BpmProjectNature.PREFERENCE_CARNOT_HOME, this.getCarnotHomeLocation());
            }
            catch (CoreException coreException) {}
            try {
                project.setPersistentProperty(BpmProjectNature.PREFERENCE_CARNOT_WORK, this.getCarnotWorkLocation());
            }
            catch (CoreException coreException) {}
        }
    }

    @Override
    public Control createAdvancedExpandableControl(Composite advancedComp, IImportModelWizardPage page) {
        this.expComp = new ExpandableComposite(advancedComp, 66);
        GridLayout layout = new GridLayout();
        this.expComp.setLayout((Layout)layout);
        this.expComp.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        this.expComp.setText(Import_Messages.CarnotAuditTrailSourceGroupProvider_1);
        Composite containerGroup = FormBuilder.createComposite((Composite)this.expComp, (int)3);
        this.expComp.setClient((Control)containerGroup);
        this.chkWithCarnotHome = FormBuilder.createCheckBox((Composite)containerGroup, (String)Import_Messages.CarnotAuditTrailSourceGroupProvider_2);
        this.txtCarnotHome = FormBuilder.createText((Composite)containerGroup);
        FormBuilder.applyDefaultTextControlWidth((Control)this.txtCarnotHome);
        this.btnBrowseCarnotHome = FormBuilder.createButton((Composite)containerGroup, (String)CONTAINER_BROWSE_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CarnotAuditTrailSourceGroupProvider.this.browseForFile(CarnotAuditTrailSourceGroupProvider.this.txtCarnotHome);
            }
        });
        this.chkWithCarnotWork = FormBuilder.createCheckBox((Composite)containerGroup, (String)Import_Messages.CarnotAuditTrailSourceGroupProvider_3);
        this.txtCarnotWork = FormBuilder.createText((Composite)containerGroup);
        FormBuilder.applyDefaultTextControlWidth((Control)this.txtCarnotWork);
        this.btnBrowseCarnotWork = FormBuilder.createButton((Composite)containerGroup, (String)CONTAINER_BROWSE_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CarnotAuditTrailSourceGroupProvider.this.browseForFile(CarnotAuditTrailSourceGroupProvider.this.txtCarnotWork);
            }
        });
        this.chkWithCarnotHome.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CarnotAuditTrailSourceGroupProvider.this.updateLocationStatus(CarnotAuditTrailSourceGroupProvider.this.chkWithCarnotHome, CarnotAuditTrailSourceGroupProvider.this.txtCarnotHome, CarnotAuditTrailSourceGroupProvider.this.btnBrowseCarnotHome);
            }
        });
        this.chkWithCarnotWork.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CarnotAuditTrailSourceGroupProvider.this.updateLocationStatus(CarnotAuditTrailSourceGroupProvider.this.chkWithCarnotWork, CarnotAuditTrailSourceGroupProvider.this.txtCarnotWork, CarnotAuditTrailSourceGroupProvider.this.btnBrowseCarnotWork);
            }
        });
        this.txtCarnotHome.addModifyListener(this.txtModifyListener);
        this.txtCarnotWork.addModifyListener(this.txtModifyListener);
        this.restoreWidgetValues();
        return this.expComp;
    }
}

