/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.carnot.audittrail;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.eclipse.stardust.common.Base64;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.LoginFailedException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.api.runtime.ServiceFactory;
import org.eclipse.stardust.engine.api.runtime.ServiceFactoryLocator;
import org.eclipse.stardust.engine.core.compatibility.gui.ErrorDialog;
import org.eclipse.stardust.engine.core.model.removethis.AuditTrailModelsDialog;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.modeling.modelimport.carnot.audittrail.Internal_ImportMessages;

public class ModelImportTool {
    private static final Logger trace = LogManager.getLogger(ModelImportTool.class);
    private static final long INVALID_MODEL_OID = -1L;
    private ServiceFactory serviceFactory;

    public static void main(String[] args) {
        trace.info((Object)Internal_ImportMessages.getString("MSG_Starting"));
        String modelFile = null;
        int i = 0;
        while (i < args.length) {
            if ("--filename".equals(args[i]) && i + 1 < args.length) {
                modelFile = args[++i];
            } else if ("--filename64".equals(args[i]) && i + 1 < args.length) {
                modelFile = new String(Base64.decode((byte[])args[++i].getBytes()));
            }
            ++i;
        }
        trace.info((Object)(String.valueOf(Internal_ImportMessages.getString("MSG_ImportingModel")) + modelFile));
        if (!StringUtils.isEmpty(modelFile)) {
            new ModelImportTool(modelFile);
        } else {
            trace.error((Object)Internal_ImportMessages.getString("MSG_NoModelSpecified"));
            System.exit(-1);
        }
    }

    public ModelImportTool(String modelFile) {
        int exitCode = -1;
        if (this.importModel(modelFile)) {
            exitCode = 1;
            JOptionPane.showMessageDialog(null, Internal_ImportMessages.getString("MSG_ModelImported"));
        }
        System.exit(exitCode);
    }

    private boolean importModel(String modelFile) {
        boolean imported = false;
        try {
            long oid;
            this.getServiceFactory();
            if (AuditTrailModelsDialog.showDialog((ServiceFactory)this.serviceFactory, null) && (oid = (long)AuditTrailModelsDialog.getOIDForSelectedModel()) != -1L) {
                String xmlString = this.serviceFactory.getQueryService().getModelAsXML(oid);
                if (!modelFile.endsWith("xpdl")) {
                    xmlString = XpdlUtils.convertXpdl2Carnot((String)xmlString);
                }
                try {
                    BufferedWriter writer = new BufferedWriter(new FileWriter(modelFile));
                    writer.write(xmlString);
                    writer.close();
                    imported = true;
                }
                catch (IOException iOException) {
                    imported = false;
                }
            }
            this.serviceFactory.close();
        }
        catch (LoginFailedException e) {
            if (e.getReason() == -1) {
                return imported;
            }
            JOptionPane.showMessageDialog(null, String.valueOf(Internal_ImportMessages.getString("MSG_LoginFailed")) + e.getMessage());
        }
        catch (Exception x) {
            trace.warn((Object)"", (Throwable)x);
            ErrorDialog.showDialog(null, (String)"", (Throwable)x);
        }
        return imported;
    }

    private void getServiceFactory() {
        if (this.serviceFactory == null || ServiceFactoryLocator.hasMultipleIdentities()) {
            if (this.serviceFactory != null) {
                this.serviceFactory.close();
            }
            this.serviceFactory = ServiceFactoryLocator.get((int)1);
        }
    }
}

