/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.effort;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.modeling.project.Project_Messages;
import org.eclipse.stardust.modeling.project.effort.EffortParameter;
import org.eclipse.stardust.modeling.project.effort.EffortParameters;
import org.eclipse.stardust.modeling.project.effort.NamedItem;
import org.eclipse.stardust.modeling.project.effort.NamedItemList;

public final class EffortParameterScope
extends NamedItemList
implements NamedItem {
    private Class<?> scopeClass;
    private String filter;
    private EffortParameters parameters;

    EffortParameterScope(EffortParameters parameters, Class<?> scope, String filter) {
        this.parameters = parameters;
        this.scopeClass = scope;
        this.filter = filter;
    }

    public boolean isApplicable(Class<?> scope, String filter) {
        return CompareHelper.areEqual(this.scopeClass, scope) && CompareHelper.areEqual((Object)this.filter, (Object)filter);
    }

    public boolean isApplicable(Object target) {
        boolean result = this.scopeClass.isInstance(target);
        return this.filter == null ? result : this.filter(target);
    }

    private boolean filter(Object target) {
        ApplicationType app = (ApplicationType)target;
        if ("Interactive".equals(this.filter)) {
            return app.isInteractive();
        }
        if ("Service".equals(this.filter)) {
            return !app.isInteractive();
        }
        return false;
    }

    public String getFilter() {
        return this.filter;
    }

    public Class<?> getScopeClass() {
        return this.scopeClass;
    }

    public String getDisplayName() {
        return Project_Messages.getString(this.getName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getSimpleName() {
        String name = this.getScopeClass().getName();
        int ix = name.lastIndexOf(46);
        if (ix > 0) {
            name = name.substring(ix + 1);
        }
        return name;
    }

    @Override
    public String getName() {
        return this.filter == null ? this.getSimpleName() : this.filter;
    }

    public void addParameter(EffortParameter parameter) {
        this.add(parameter);
        this.parameters.markModified();
    }

    public void removeParameter(EffortParameter parameter) {
        this.remove(parameter);
        this.parameters.markModified();
    }

    public Iterator<String> getParameterNames() {
        return this.getNames();
    }

    public boolean hasParameter(String name) {
        return this.get(name) != null;
    }

    public EffortParameter getParameter(String name) {
        EffortParameter parameter = (EffortParameter)this.get(name);
        if (parameter != null) {
            return parameter;
        }
        throw new IllegalArgumentException(MessageFormat.format("Effort driver ID {0} is not supported.", name));
    }

    public int parameterCount() {
        return this.size();
    }

    public EffortParameters getEffortParameters() {
        return this.parameters;
    }
}

