/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.effort;

import java.util.StringTokenizer;
import org.eclipse.stardust.modeling.project.Project_Messages;
import org.eclipse.stardust.modeling.project.effort.EffortEvent;
import org.eclipse.stardust.modeling.project.effort.EffortNotifier;
import org.eclipse.stardust.modeling.project.effort.ScopedItem;

public class EffortPerUnit
extends EffortNotifier {
    public static final String[] DEFAULT_LABELS = new String[]{Project_Messages.getString("EffortPerUnit.DefineColumnLabel"), Project_Messages.getString("EffortPerUnit.DesignColumnLabel"), Project_Messages.getString("EffortPerUnit.ImplementationColumnLabel"), Project_Messages.getString("EffortPerUnit.ValidationColumnLabel"), Project_Messages.getString("EffortPerUnit.RolloutColumnLabel")};
    private double[] values;
    private String[] labels;
    private ScopedItem parent;

    public EffortPerUnit(ScopedItem parent, double value) {
        this(parent, DEFAULT_LABELS, value);
    }

    public EffortPerUnit(ScopedItem parent, String initializer) {
        this(parent, DEFAULT_LABELS, initializer == null || initializer.indexOf(59) >= 0 ? 0.0 : Double.parseDouble(initializer));
        if (initializer != null && initializer.indexOf(59) >= 0) {
            this.setValuesFromInitializer(initializer);
        }
    }

    private EffortPerUnit(ScopedItem parent, String[] labels, double value) {
        this.parent = parent;
        this.labels = labels == null ? new String[]{} : labels;
        this.values = new double[this.labels.length];
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = value;
            ++i;
        }
    }

    public int elementCount() {
        return this.values.length;
    }

    public double getEffort(int index) {
        return this.values[index];
    }

    public void setEffort(int index, double value) {
        Double oldValue = new Double(this.values[index]);
        this.values[index] = value;
        this.notifyListeners(new EffortEvent(this, this.labels[index], new Double(value), oldValue));
    }

    public String getLabel(int index) {
        return this.labels[index];
    }

    private void setValuesFromInitializer(String initializer) {
        StringTokenizer st = new StringTokenizer(initializer, ";");
        int i = 0;
        while (st.hasMoreTokens() && i < this.values.length) {
            this.values[i++] = Double.parseDouble(st.nextToken());
        }
    }

    public String getInitializer() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.values.length) {
            if (i > 0) {
                sb.append(';');
            }
            sb.append(this.values[i]);
            ++i;
        }
        return sb.toString();
    }

    public double[] getEffort() {
        return (double[])this.values.clone();
    }

    public void setEffort(String property, double newValue) {
        int i = 0;
        while (i < this.labels.length) {
            if (property.equals(this.labels[i])) {
                double oldValue = this.values[i];
                this.values[i] = newValue;
                this.parent.getScope().getEffortParameters().markModified();
                this.notifyListeners(new EffortEvent(this, property, new Double(newValue), new Double(oldValue)));
            }
            ++i;
        }
    }
}

