/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.project.effort;

import java.util.Iterator;
import java.util.List;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.modeling.project.effort.EffortEvent;
import org.eclipse.stardust.modeling.project.effort.EffortNotifier;
import org.eclipse.stardust.modeling.project.effort.NamedItem;

public abstract class NamedItemList
extends EffortNotifier {
    public static final String ADD_PROPERTY = "items.add";
    public static final String REMOVE_PROPERTY = "items.remove";
    private List<NamedItem> items = CollectionUtils.newList();

    void add(NamedItem item) {
        if (!this.items.contains(item)) {
            this.items.add(item);
            this.notifyListeners(new EffortEvent(this, ADD_PROPERTY, item, null));
        }
    }

    void remove(int index) {
        NamedItem item = this.items.remove(index);
        this.notifyListeners(new EffortEvent(this, REMOVE_PROPERTY, null, item));
    }

    void remove(NamedItem item) {
        if (this.items.remove(item)) {
            this.notifyListeners(new EffortEvent(this, REMOVE_PROPERTY, null, item));
        }
    }

    void clear() {
        this.items.clear();
    }

    int size() {
        return this.items.size();
    }

    NamedItem get(int index) {
        return this.items.get(index);
    }

    NamedItem get(String name) {
        int i = 0;
        while (i < this.items.size()) {
            NamedItem item = this.items.get(i);
            if (CompareHelper.areEqual((Object)item.getName(), (Object)name)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    String getName(int index) {
        return this.items.get(index).getName();
    }

    Iterator<String> getNames() {
        final Iterator<NamedItem> source = this.items.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public String next() {
                return ((NamedItem)source.next()).getName();
            }

            @Override
            public void remove() {
                source.remove();
            }
        };
    }
}

