/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.refactoring.operators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.EventConditionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.refactoring.operators.IJdtOperator;
import org.eclipse.stardust.modeling.refactoring.operators.OperatorsRegistry;
import org.eclipse.stardust.modeling.refactoring.query.matches.EObjectMatch;
import org.eclipse.stardust.modeling.refactoring.refactoring.changes.AttributeValueChange;

public class ConditionOperator
implements IJdtOperator {
    private String typeId;
    private String[] classNames;

    public ConditionOperator(String type, String[] attributes) {
        this.typeId = type;
        this.classNames = attributes;
    }

    @Override
    public List getRefactoringChanges(ModelType model, Object element, RefactoringArguments arguments) {
        if (!(element instanceof IType)) {
            return Collections.EMPTY_LIST;
        }
        String originalClassName = ((IType)element).getFullyQualifiedName();
        String newClassName = OperatorsRegistry.getNewClassName((IType)element, arguments);
        if (newClassName.equals(originalClassName)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AttributeValueChange> result = new ArrayList<AttributeValueChange>();
        EList conditionTypes = model.getEventConditionType();
        int i = 0;
        while (i < conditionTypes.size()) {
            EventConditionTypeType type = (EventConditionTypeType)conditionTypes.get(i);
            if (this.typeId.equals(type.getId())) {
                EList eventHandlers = type.getEventHandlers();
                int j = 0;
                while (j < eventHandlers.size()) {
                    EventHandlerType handler = (EventHandlerType)eventHandlers.get(j);
                    int k = 0;
                    while (k < this.classNames.length) {
                        String className;
                        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)handler, (String)this.classNames[k]);
                        if (attribute != null && originalClassName.equals(className = attribute.getValue())) {
                            result.add(new AttributeValueChange(attribute, newClassName));
                        }
                        ++k;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }

    @Override
    public List getQueryMatches(IFile file, ModelType model, Object element) {
        if (!(element instanceof IType)) {
            return Collections.EMPTY_LIST;
        }
        String className = ((IType)element).getFullyQualifiedName();
        ArrayList<EObjectMatch> result = new ArrayList<EObjectMatch>();
        EList conditionTypes = model.getEventConditionType();
        int i = 0;
        while (i < conditionTypes.size()) {
            EventConditionTypeType type = (EventConditionTypeType)conditionTypes.get(i);
            if (this.typeId.equals(type.getId())) {
                EList eventHandlers = type.getEventHandlers();
                int j = 0;
                while (j < eventHandlers.size()) {
                    EventHandlerType handler = (EventHandlerType)eventHandlers.get(j);
                    int k = 0;
                    while (k < this.classNames.length) {
                        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)handler, (String)this.classNames[k]);
                        if (attribute != null && className.equals(attribute.getValue())) {
                            result.add(new EObjectMatch(file, attribute, 0, className.length()));
                        }
                        ++k;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return result;
    }
}

