/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugElement;
import org.eclipse.stardust.modeling.transformation.debug.model.JsDebugTarget;
import org.eclipse.stardust.modeling.transformation.debug.model.JsVariable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebuggableObject;

public class JsValue
extends JsDebugElement
implements IValue {
    private JsVariable variable;
    private Object rawValue;
    private String reservedValueType = null;
    private boolean isPrimitive;

    public JsValue(JsVariable variable, Object rawValue) {
        super((JsDebugTarget)variable.getDebugTarget());
        this.variable = variable;
        this.rawValue = rawValue;
    }

    public JsValue(JsVariable variable, Object rawValue, boolean isPrimitive) {
        super((JsDebugTarget)variable.getDebugTarget());
        this.variable = variable;
        this.rawValue = rawValue;
        this.isPrimitive = isPrimitive;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.variable.getReferenceTypeName();
    }

    public String getValueString() throws DebugException {
        return this.rawValue == null ? "" : this.rawValue.toString();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() {
        return (IVariable[])Context.call((ContextAction)new ContextAction(){

            public Object run(Context arg0) {
                try {
                    return JsValue.this.getVariablesActionImpl();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return JsVariable.NO_VARS;
                }
            }
        });
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public static boolean isValidJsValue(Object val) {
        return val != Scriptable.NOT_FOUND && !(val instanceof Undefined) && !(val instanceof NativeJavaMethod) && !(val instanceof NativeJavaConstructor) && !(val instanceof NativeJavaPackage);
    }

    private IVariable[] getVariablesActionImpl() throws DebugException {
        if (this.reservedValueType != null) {
            return JsVariable.NO_VARS;
        }
        Object valObj = this.rawValue;
        if (this.rawValue instanceof NativeJavaObject) {
            valObj = ((NativeJavaObject)this.rawValue).unwrap();
        }
        if (valObj == null || valObj.getClass().isPrimitive() || this.isPrimitive) {
            return JsVariable.NO_VARS;
        }
        ArrayList<JsVariable> children = new ArrayList<JsVariable>();
        if (valObj.getClass().isArray()) {
            int len = Array.getLength(valObj);
            boolean primitive = valObj.getClass().getComponentType().isPrimitive();
            int i = 0;
            while (i < len) {
                Object aobj = Array.get(valObj, i);
                if (JsValue.isValidJsValue(aobj)) {
                    children.add(new JsVariable(this.variable.getFrame(), this.variable, "[" + children.size() + "]", aobj, primitive));
                }
                ++i;
            }
        } else if (valObj instanceof Scriptable) {
            Object[] ids = valObj instanceof DebuggableObject ? ((DebuggableObject)valObj).getAllIds() : ((Scriptable)valObj).getIds();
            if (ids == null || ids.length == 0) {
                return JsVariable.NO_VARS;
            }
            int i = 0;
            while (i < ids.length) {
                if (ids[i] instanceof String) {
                    Object val = ScriptableObject.getProperty((Scriptable)((Scriptable)valObj), (String)((String)ids[i]));
                    if (val instanceof NativeJavaObject) {
                        val = ((NativeJavaObject)val).unwrap();
                    }
                    if (JsValue.isValidJsValue(val)) {
                        children.add(new JsVariable(this.variable.getFrame(), this.variable, (String)ids[i], val));
                    }
                }
                ++i;
            }
        } else {
            this.reflectMembers(valObj, children);
        }
        if (children.size() == 0) {
            return JsVariable.NO_VARS;
        }
        return children.toArray(new IVariable[children.size()]);
    }

    private void reflectMembers(Object obj, List children) {
        HashMap names = new HashMap();
        Class<?> clazz = obj.getClass();
        Field field = null;
        try {
            while (clazz != null) {
                Field[] fields = clazz.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    field = fields[i];
                    field.setAccessible(true);
                    if (!(Modifier.isStatic(field.getModifiers()) || names.containsKey(field.getName()) || obj instanceof LinkedHashMap && "header".equals(field.getName()))) {
                        JsVariable jsVar = new JsVariable(this.variable.getFrame(), this.variable, field.getName(), field.get(obj), field.getType().isPrimitive());
                        jsVar.setReferenceTypeName(JsValue.convertArrayTypeName(field.getType(), field.getType().isPrimitive()));
                        children.add(jsVar);
                        names.put(field.getName(), null);
                    }
                    ++i;
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String convertArrayTypeName(Class clz, boolean explicitPrimitive) {
        if (clz.isArray()) {
            return String.valueOf(JsValue.convertPrimativeTypeName(clz.getComponentType(), explicitPrimitive)) + "[]";
        }
        return JsValue.convertPrimativeTypeName(clz, explicitPrimitive);
    }

    private static String convertPrimativeTypeName(Class clz, boolean explictPrimitive) {
        if (clz.isPrimitive() || explictPrimitive) {
            if (Boolean.class.equals((Object)clz) || Boolean.TYPE.equals(clz)) {
                return "boolean";
            }
            if (Character.class.equals((Object)clz) || Character.TYPE.equals(clz)) {
                return "char";
            }
            if (Byte.class.equals((Object)clz) || Byte.TYPE.equals(clz)) {
                return "byte";
            }
            if (Short.class.equals((Object)clz) || Short.TYPE.equals(clz)) {
                return "short";
            }
            if (Integer.class.equals((Object)clz) || Integer.TYPE.equals(clz)) {
                return "int";
            }
            if (Long.class.equals((Object)clz) || Long.TYPE.equals(clz)) {
                return "long";
            }
            if (Float.class.equals((Object)clz) || Float.TYPE.equals(clz)) {
                return "float";
            }
            if (Double.class.equals((Object)clz) || Double.TYPE.equals(clz)) {
                return "double";
            }
            if (Void.class.equals((Object)clz) || Void.TYPE.equals(clz)) {
                return "void";
            }
        }
        return clz.getName();
    }
}

