/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.debug.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.transformation.debug.WatchExpressionDelegate;
import org.eclipse.stardust.modeling.transformation.debug.model.AbstractVariable;
import org.eclipse.stardust.modeling.transformation.debug.model.JsStackFrame;
import org.eclipse.stardust.modeling.transformation.debug.model.JsValue;

public class JsVariable
extends AbstractVariable {
    public static final IVariable[] NO_VARS = new IVariable[0];
    private JsValue value;
    private String name;
    private String typeName;

    public JsVariable(JsStackFrame frame, AbstractVariable parent, String name, Object dataField) {
        this(frame, parent, name, dataField, false);
    }

    public JsVariable(JsStackFrame frame, AbstractVariable parent, String name, Object dataField, boolean isPrimitive) {
        super(frame, parent);
        this.name = name;
        this.value = new JsValue(this, dataField, isPrimitive);
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return StringUtils.isEmpty((String)this.typeName) ? "<no type available>" : this.typeName;
    }

    public void setReferenceTypeName(String typeName) throws DebugException {
        this.typeName = typeName;
    }

    public void setValue(String expression) throws DebugException {
        IWatchExpressionResult result;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        AbstractVariable parent = this.getParent();
        while (parent != null) {
            buffer.insert(0, ".").insert(0, parent.getQualifiedName());
            parent = parent.getParent();
        }
        buffer.append(" = ").append(expression);
        if (this.verifyValue(buffer.toString()) && !(result = WatchExpressionDelegate.evaluateExpression(buffer.toString(), this.getFrame())).hasErrors() && result.getValue() instanceof JsValue) {
            this.value = (JsValue)result.getValue();
            this.hasChanged = true;
            this.fireChangeEvent(512);
        }
    }
}

