/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.launch;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataConverter;
import org.eclipse.stardust.engine.extensions.transformation.format.IMessageFormat;
import org.eclipse.stardust.engine.extensions.transformation.format.ParsingException;
import org.eclipse.stardust.engine.extensions.transformation.javascript.JScriptManager3;
import org.eclipse.stardust.engine.extensions.transformation.model.MappingModelUtil;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.FieldMapping;
import org.eclipse.stardust.engine.extensions.transformation.model.mapping.TransformationProperty;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.transformation.messaging.format.FormatManager;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransformationLaunchDelegate
extends LaunchConfigurationDelegate {
    private Document schemaDocument;
    private ModelType model;
    private JScriptManager3 jsManager;
    private ApplicationType applicationType;
    private TransformationProperty trafoProp;
    private List fieldMappings;
    private boolean containsPrimitive;

    public void launch(ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        MessageConsole myConsole = new MessageConsole(Modeling_Messages.CSL_OP_CSL, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{myConsole});
        final MessageConsoleStream msgStream = myConsole.newMessageStream();
        final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations();
        List launchers = configuration.getAttribute("inputMessageConfiguration", new ArrayList());
        HashMap<String, ILaunchConfiguration> processingLauncherMap = new HashMap<String, ILaunchConfiguration>();
        int i = 0;
        while (i < launchConfigurations.length) {
            ILaunchConfiguration launchConfiguration = launchConfigurations[i];
            for (String launcher : launchers) {
                String[] launchertupel = launcher.split(",");
                if (!launchConfiguration.getName().equalsIgnoreCase(launchertupel[1])) continue;
                processingLauncherMap.put(launchertupel[0], launchConfiguration);
            }
            ++i;
        }
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(configuration.getAttribute("projectName", ""));
        this.model = null;
        String modelUri = configuration.getAttribute("processModelFilePath", "");
        try {
            this.model = this.loadModel(modelUri);
        }
        catch (Exception e) {
            throw new RuntimeException(Modeling_Messages.EXC_MD_NOT_LOD, e);
        }
        Map inputMessage = null;
        final HashMap<String, Map> inputMessagesMap = new HashMap<String, Map>();
        for (String messageID : processingLauncherMap.keySet()) {
            ILaunchConfiguration processingLaunchConfiguration = (ILaunchConfiguration)processingLauncherMap.get(messageID);
            try {
                FileInputStream fis = new FileInputStream(processingLaunchConfiguration.getAttribute("sourceFilePath", null));
                String sourceFormat = processingLaunchConfiguration.getAttribute("sourceFormat", null);
                String declaredTypeId = processingLaunchConfiguration.getAttribute("legoData", null);
                TypeDeclarationType typeDeclaration = this.model.getTypeDeclarations().getTypeDeclaration(declaredTypeId);
                this.schemaDocument = typeDeclaration.getSchema().getDocument();
                if (this.schemaDocument != null) {
                    inputMessage = this.performMessageParsing(fis, sourceFormat, this.schemaDocument, declaredTypeId, processingLaunchConfiguration);
                }
                inputMessagesMap.put(messageID, inputMessage);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(Modeling_Messages.EXC_IMPO_FILE_NOT_FOUND, e);
            }
            catch (ParsingException e) {
                throw new RuntimeException(Modeling_Messages.EXC_PB_PR_FILE_CONTENT, e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(Modeling_Messages.EXC_PB_PR_FILE_CONTENT, e);
            }
        }
        final String applicationID = configuration.getAttribute("applicationId", "");
        final Map outputMessages = CollectionUtils.newMap();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        TransformationLaunchDelegate.this.initializeModel(TransformationLaunchDelegate.this.model, applicationID, outputMessages);
                        if (TransformationLaunchDelegate.this.containsPrimitive) {
                            msgStream.println(Modeling_Messages.MSG_WR_CURR_MSG_TRANS_LAUNCHERS_NOT_SUPPORTED_USAGE_PRIMI_DATA);
                            msgStream.println(Modeling_Messages.MSG_MAPPING_CONTAIN_PRIMI_MSG_IGN);
                            TransformationLaunchDelegate.this.containsPrimitive = false;
                        }
                        TransformationLaunchDelegate.this.jsManager.initializeContext(inputMessagesMap, outputMessages, new ArrayList());
                        TransformationLaunchDelegate.this.initOnDebug(launch, project, TransformationLaunchDelegate.this.getApplicationType());
                        int i = 0;
                        while (i < TransformationLaunchDelegate.this.fieldMappings.size()) {
                            FieldMapping fieldMapping = (FieldMapping)TransformationLaunchDelegate.this.fieldMappings.get(i);
                            if (!TransformationLaunchDelegate.this.initBeforeNextScript(fieldMapping.getFieldPath())) {
                                msgStream.println(Modeling_Messages.MSG_SCRIPT_DEB_TERM);
                                break;
                            }
                            String type = fieldMapping.isAdvancedMapping() ? "advanced" : "basic";
                            msgStream.println("Field '" + fieldMapping.getFieldPath() + "', " + type + " expression: " + fieldMapping.getMappingExpression());
                            Object result = TransformationLaunchDelegate.this.jsManager.executeMapping(fieldMapping.getMappingExpression());
                            if (fieldMapping.isAdvancedMapping()) {
                                result = TransformationLaunchDelegate.this.jsManager.executeMapping(fieldMapping.getFieldPath().replace('/', '.'));
                            }
                            String stringifiedResult = result == null ? "<null>" : result.toString();
                            msgStream.println(String.valueOf(Modeling_Messages.MSG_RESULT) + stringifiedResult);
                            msgStream.println("---");
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        try {
                            launch.terminate();
                            launchManager.removeLaunch(launch);
                        }
                        catch (DebugException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        launch.terminate();
                        launchManager.removeLaunch(launch);
                    }
                    catch (DebugException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        thread.start();
    }

    protected void initOnDebug(ILaunch launch, IProject project, ApplicationType applicationType) throws CoreException {
    }

    protected boolean initBeforeNextScript(String fieldPath) throws CoreException {
        return true;
    }

    public ModelType loadModel(String modelUri) throws Exception {
        WorkflowModelManager modelManager = new WorkflowModelManager();
        modelManager.load(URI.createURI((String)modelUri));
        ModelType model = modelManager.getModel();
        return model;
    }

    public Map performMessageParsing(FileInputStream fis, String sourceFormat, Object schemaDocument, String legoTypeName, ILaunchConfiguration launchConfiguration) throws ParsingException {
        Map outputMessage = null;
        try {
            IMessageFormat messageFormat = FormatManager.getMessageFormat(sourceFormat, launchConfiguration);
            Document sourceDoc = messageFormat.parse((InputStream)fis, schemaDocument);
            IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((ModelType)this.model, (String)legoTypeName);
            StructuredDataConverter structuredDataConverter = new StructuredDataConverter(xPathMap);
            String serializedDoc = XmlUtils.toString((Node)sourceDoc);
            outputMessage = (Map)structuredDataConverter.toCollection(serializedDoc, "", true);
        }
        catch (Exception exception) {}
        return outputMessage;
    }

    protected ApplicationType getApplicationType() {
        return this.applicationType;
    }

    protected JScriptManager3 getJsManager() {
        return this.jsManager;
    }

    private void initializeModel(ModelType model, String appId, Map outputMessages) {
        this.applicationType = this.getApplicationByID(model, appId);
        this.jsManager = new JScriptManager3();
        int i = 0;
        while (i < this.applicationType.getAccessPoint().size()) {
            AccessPointType accessPoint = (AccessPointType)this.applicationType.getAccessPoint().get(i);
            String declaredTypeId = AttributeUtil.getAttributeValue((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType");
            TypeDeclarationType typeDeclaration = ModelUtils.getTypeDeclaration((IModelElement)this.applicationType, (String)declaredTypeId);
            if (accessPoint.getType().getId().equalsIgnoreCase("struct")) {
                IXPathMap xPathMap = StructuredTypeUtils.getXPathMap((ModelType)model, (String)typeDeclaration.getId());
                if (accessPoint.getDirection().equals((Object)DirectionType.IN_LITERAL)) {
                    this.jsManager.registerInAccessPointType(accessPoint.getId(), xPathMap.getRootXPath());
                } else {
                    this.jsManager.registerOutAccessPointType(accessPoint.getId(), xPathMap.getRootXPath());
                    outputMessages.put(accessPoint.getId(), CollectionUtils.newMap());
                }
            } else {
                this.containsPrimitive = true;
            }
            ++i;
        }
        String xmlString = AttributeUtil.getAttributeValue((IExtensibleElement)this.applicationType, (String)"messageTransformation:TransformationProperty");
        if (xmlString == null) {
            throw new RuntimeException(Modeling_Messages.EXC_MESSAGE_TRANSF_APP_NOT_CONFI_PROPERLY);
        }
        this.trafoProp = (TransformationProperty)MappingModelUtil.transformXML2Ecore((String)xmlString);
        this.fieldMappings = this.trafoProp.getFieldMappings();
    }

    private ApplicationType getApplicationByID(ModelType modelType, String applicationID) {
        EList applications = modelType.getApplication();
        for (ApplicationType appType : applications) {
            if (!appType.getId().equalsIgnoreCase(applicationID)) continue;
            return appType;
        }
        return null;
    }
}

