/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets;

import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.IMessageTransformationApplicationView;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MessageRenameDialog;
import org.eclipse.swt.widgets.Display;

public class RenameMessageAction
extends Action {
    private MessageTransformationController controller;
    private IMessageTransformationApplicationView view;
    private boolean isSource;

    public RenameMessageAction(IMessageTransformationApplicationView view, MessageTransformationController controller, boolean isSource) {
        this.controller = controller;
        this.view = view;
        this.isSource = isSource;
    }

    public void run() {
        super.run();
        MessageRenameDialog dialog = new MessageRenameDialog(Display.getCurrent().getActiveShell(), this.controller, this.isSource);
        if (dialog.open() == 0) {
            if (this.isSource) {
                this.controller.performSourceMessageRemovement();
                this.controller.addSourceMessageType(dialog.getMessageType(), MessageRenameDialog.getMessageName());
            } else {
                this.controller.performTargetMessageRemovement();
                this.controller.addTargetMessageType(dialog.getMessageType(), MessageRenameDialog.getMessageName());
            }
            this.view.refreshModel();
            this.view.refreshDocument();
        }
    }

    public String getText() {
        String message = Modeling_Messages.TXT_MODIFY;
        return MessageFormat.format(message, this.controller.getNameString());
    }

    public boolean isEnabled() {
        if (this.isSource) {
            return this.controller.isDeleteSourceMessageAvailable();
        }
        return this.controller.isDeleteTargetMessageAvailable();
    }
}

